/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.rest;

import java.time.YearMonth;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.service.KudosService;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/kudos/api/kudos")
@RolesAllowed(value={"users"})
public class KudosREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(KudosREST.class);
    private KudosService kudosService;

    public KudosREST(KudosService kudosService) {
        this.kudosService = kudosService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveKudos")
    @RolesAllowed(value={"users"})
    public Response saveKudos(Kudos kudos) {
        if (kudos == null) {
            LOG.warn((Object)"Bad request sent to server with empty kudos");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)kudos.getReceiverId()) || StringUtils.isBlank((String)kudos.getReceiverType())) {
            LOG.warn((Object)"Bad request sent to server with empty 'receiver id or type'");
            return Response.status((int)400).build();
        }
        if (StringUtils.isNotBlank((String)kudos.getSenderId())) {
            LOG.warn((Object)"Bad request sent to server with a preset 'sender'");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)kudos.getEntityId()) || StringUtils.isBlank((String)kudos.getEntityType())) {
            LOG.warn((Object)"Bad request sent to server with empty 'attached entity id or type'");
            return Response.status((int)400).build();
        }
        kudos.setSenderId(Utils.getCurrentUserId());
        try {
            this.kudosService.sendKudos(Utils.getCurrentUserId(), kudos);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving kudos", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @Path(value="getKudos")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getKudos(@QueryParam(value="identityId") String identityId) {
        if (StringUtils.isBlank((String)identityId)) {
            LOG.warn((Object)"Bad request sent to server with empty 'identity id'");
            return Response.status((int)400).build();
        }
        List<Kudos> allKudosBySender = this.kudosService.getAllKudosByMonthAndSender(YearMonth.now(), identityId);
        return Response.ok(allKudosBySender).build();
    }

    @Path(value="getEntityKudos")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getEntityKudos(@QueryParam(value="entityType") String entityType, @QueryParam(value="entityId") String entityId) {
        if (StringUtils.isBlank((String)entityType) || StringUtils.isBlank((String)entityId)) {
            LOG.warn((Object)"Bad request sent to server with empty 'attached entity id or type'");
            return Response.status((int)400).build();
        }
        List<Kudos> allKudosByEntity = this.kudosService.getAllKudosByEntity(entityType, entityId);
        return Response.ok(allKudosByEntity).build();
    }

    @Path(value="getKudosByMonth")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getKudosByMonth(@QueryParam(value="month") long monthInSeconds) {
        if (monthInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'month' parameter");
            return Response.status((int)400).build();
        }
        List<Kudos> allKudosByMonth = this.kudosService.getAllKudosByMonth(YearMonth.from(Utils.timeFromSeconds(monthInSeconds)));
        return Response.ok(allKudosByMonth).build();
    }
}

