/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.kudos.model.AccountSettings;
import org.exoplatform.addon.kudos.service.KudosService;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/kudos/api/account")
@RolesAllowed(value={"users"})
public class KudosAccountREST
implements ResourceContainer {
    private KudosService kudosService;

    public KudosAccountREST(KudosService kudosService) {
        this.kudosService = kudosService;
    }

    @Path(value="settings")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getSettings() {
        AccountSettings accountDetail = this.kudosService.getAccountSettings(Utils.getCurrentUserId());
        if (accountDetail == null) {
            return Response.ok((Object)"{}").build();
        }
        return Response.ok((Object)accountDetail).build();
    }

    @Path(value="isAuthorized")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response isAuthorized(@QueryParam(value="username") String username) {
        if (this.kudosService.isAuthorized(username)) {
            return Response.ok().build();
        }
        return Response.status((int)403).build();
    }
}

