/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.service;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.kudos.model.AccountSettings;
import org.exoplatform.addon.kudos.model.GlobalSettings;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.model.KudosPeriod;
import org.exoplatform.addon.kudos.service.KudosStorage;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class KudosService
implements Startable {
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private KudosStorage kudosStorage;
    private SettingService settingService;
    private GlobalSettings globalSettings;

    public KudosService(KudosStorage kudosStorage, SettingService settingService, SpaceService spaceService, IdentityManager identityManager, ListenerService listenerService, InitParams params) {
        this.kudosStorage = kudosStorage;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.settingService = settingService;
        this.listenerService = listenerService;
        if (params != null) {
            this.globalSettings = new GlobalSettings();
            if (params.containsKey((Object)"defaultAccessPermission")) {
                String defaultAccessPermission = params.getValueParam("defaultAccessPermission").getValue();
                this.globalSettings.setAccessPermission(defaultAccessPermission);
            }
            if (params.containsKey((Object)"defaultKudosPerPeriod")) {
                String defaultKudosPerPeriod = params.getValueParam("defaultKudosPerPeriod").getValue();
                this.globalSettings.setKudosPerPeriod(Long.parseLong(defaultKudosPerPeriod));
            }
        }
    }

    public void start() {
        GlobalSettings loadedGlobalSettings = this.loadGlobalSettings();
        if (loadedGlobalSettings != null) {
            this.globalSettings = loadedGlobalSettings;
        }
    }

    public void stop() {
    }

    public AccountSettings getAccountSettings(String username) {
        AccountSettings accountSettings = new AccountSettings();
        if (!this.isAuthorized(username)) {
            accountSettings.setDisabled(true);
            return accountSettings;
        }
        long sentKudos = this.countKudosBySenderInCurrentPeriod(Utils.getCurrentUserId());
        accountSettings.setRemainingKudos(this.getKudosPerPeriod() - sentKudos);
        return accountSettings;
    }

    public void sendKudos(String senderId, Kudos kudos) throws Exception {
        if (!StringUtils.equals((String)senderId, (String)kudos.getSenderId())) {
            throw new IllegalAccessException("User with id '" + senderId + "' is not authorized to send kudos on behalf of " + kudos.getSenderId());
        }
        if (StringUtils.equals((String)senderId, (String)kudos.getReceiverId())) {
            throw new IllegalAccessException("User with username '" + senderId + "' is not authorized to send kudos to himseld!");
        }
        KudosPeriod currentPeriod = this.getCurrentKudosPeriod();
        if (this.kudosStorage.countKudosByPeriodAndSender(currentPeriod, senderId) >= this.getKudosPerPeriod()) {
            throw new IllegalAccessException("User having username'" + senderId + "' is not authorized to send more kudos");
        }
        Identity senderIdentity = (Identity)this.checkStatusAndGetReceiver("organization", senderId);
        if (kudos.getSenderIdentityId() == null) {
            kudos.setSenderIdentityId(senderIdentity.getId());
        }
        Object receiverObject = this.checkStatusAndGetReceiver(kudos.getReceiverType(), kudos.getReceiverId());
        if (kudos.getReceiverIdentityId() == null) {
            if (receiverObject instanceof Identity) {
                kudos.setReceiverIdentityId(((Identity)receiverObject).getId());
            } else if (receiverObject instanceof Space) {
                kudos.setReceiverIdentityId(((Space)receiverObject).getId());
            }
        }
        kudos.setTime(LocalDateTime.now());
        kudos = this.kudosStorage.createKudos(kudos);
        this.listenerService.broadcast("exo.addons.kudos.sent", (Object)this, (Object)kudos);
    }

    public List<Kudos> getAllKudosByPeriod(long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod period = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getAllKudosByPeriod(period);
    }

    public List<Kudos> getAllKudosByPeriodOfDate(long dateInSeconds) {
        KudosPeriod period = this.getKudosPeriodOfTime(dateInSeconds);
        return this.kudosStorage.getAllKudosByPeriod(period);
    }

    public List<Kudos> getAllKudosByEntity(String entityType, String entityId) {
        return this.kudosStorage.getAllKudosByEntity(entityType, entityId);
    }

    public List<Kudos> getAllKudosByEntityTypeInCurrentPeriod(String entityType) {
        return this.kudosStorage.getAllKudosByPeriodAndEntityType(this.getCurrentKudosPeriod(), entityType);
    }

    public List<Kudos> getAllKudosBySenderInCurrentPeriod(String identityId) {
        List<Kudos> kudosBySender = this.kudosStorage.getKudosByPeriodAndSender(this.getCurrentKudosPeriod(), identityId);
        if (kudosBySender != null) {
            Collections.sort(kudosBySender);
        }
        return kudosBySender;
    }

    public long countKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return 0L;
        }
        return this.kudosStorage.countKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId());
    }

    public List<Kudos> getKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.kudosStorage.getKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId());
    }

    public List<Kudos> getKudosByReceiverInCurrentPeriod(String receiverType, String receiverId) {
        List<Kudos> kudosList = this.kudosStorage.getKudosByPeriodAndReceiver(this.getCurrentKudosPeriod(), receiverType, receiverId);
        if (kudosList != null) {
            Collections.sort(kudosList);
        }
        return kudosList;
    }

    public long countKudosBySenderInCurrentPeriod(String senderId) {
        return this.kudosStorage.countKudosByPeriodAndSender(this.getCurrentKudosPeriod(), senderId);
    }

    public void saveGlobalSettings(GlobalSettings settings) {
        this.settingService.set(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS", SettingValue.create((String)settings.toStringToPersist()));
        this.globalSettings = null;
    }

    public GlobalSettings getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = this.loadGlobalSettings();
        }
        return this.globalSettings;
    }

    public long getKudosPerPeriod() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? 0L : storedGlobalSettings.getKudosPerPeriod();
    }

    public String getAccessPermission() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? null : storedGlobalSettings.getAccessPermission();
    }

    public boolean isAuthorized(String username) {
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        String accessPermission = this.getAccessPermission();
        if (StringUtils.isBlank((String)accessPermission)) {
            return true;
        }
        Space space = Utils.getSpace(accessPermission);
        return this.spaceService.isSuperManager(username) || space != null && this.spaceService.isMember(space, username);
    }

    private KudosPeriod getCurrentKudosPeriod() {
        return Utils.getCurrentPeriod(this.getGlobalSettings());
    }

    private KudosPeriod getKudosPeriodOfTime(long dateInSeconds) {
        return Utils.getPeriodOfTime(this.getGlobalSettings(), Utils.timeFromSeconds(dateInSeconds));
    }

    private Object checkStatusAndGetReceiver(String type, String id) {
        if ("user".equals(type) || "organization".equals(type)) {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", id, true);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                throw new IllegalStateException("User '" + id + "' doesn't have a valid and enabled social identity");
            }
            if (!this.isAuthorized(id)) {
                throw new IllegalStateException("User '" + id + "' isn't member of authorized group to send/receive kudos: " + this.getAccessPermission());
            }
            return identity;
        }
        Space space = Utils.getSpace(id);
        if (space == null) {
            throw new IllegalStateException("Space '" + id + "' wasn't found, thus it can't receive/send kudos");
        }
        return space;
    }

    private GlobalSettings loadGlobalSettings() {
        SettingValue globalSettingsValue = this.settingService.get(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS");
        if (globalSettingsValue == null || StringUtils.isBlank((String)globalSettingsValue.getValue().toString())) {
            return null;
        }
        return GlobalSettings.parseStringToObject(globalSettingsValue.getValue().toString());
    }
}

