/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.rest;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.model.KudosPeriod;
import org.exoplatform.addon.kudos.model.KudosPeriodType;
import org.exoplatform.addon.kudos.service.KudosService;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/kudos/api/kudos")
@RolesAllowed(value={"users"})
public class KudosREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(KudosREST.class);
    private KudosService kudosService;

    public KudosREST(KudosService kudosService) {
        this.kudosService = kudosService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveKudos")
    @RolesAllowed(value={"users"})
    public Response saveKudos(Kudos kudos) {
        if (kudos == null) {
            LOG.warn((Object)"Bad request sent to server with empty kudos");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)kudos.getReceiverId()) || StringUtils.isBlank((String)kudos.getReceiverType())) {
            LOG.warn((Object)"Bad request sent to server with empty 'receiver id or type'");
            return Response.status((int)400).build();
        }
        if (StringUtils.isNotBlank((String)kudos.getSenderId())) {
            LOG.warn((Object)"Bad request sent to server with a preset 'sender'");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)kudos.getEntityId()) || StringUtils.isBlank((String)kudos.getEntityType())) {
            LOG.warn((Object)"Bad request sent to server with empty 'attached entity id or type'");
            return Response.status((int)400).build();
        }
        try {
            kudos.setSenderId(Utils.getCurrentUserId());
            this.kudosService.sendKudos(Utils.getCurrentUserId(), kudos);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving kudos: {}", new Object[]{kudos, e});
            return Response.serverError().build();
        }
    }

    @Path(value="getKudos")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getKudos(@QueryParam(value="identityId") String identityId) {
        if (StringUtils.isBlank((String)identityId)) {
            LOG.warn((Object)"Bad request sent to server with empty 'identity id'");
            return Response.status((int)400).build();
        }
        try {
            List<Kudos> allKudosBySender = this.kudosService.getAllKudosBySenderInCurrentPeriod(identityId);
            return Response.ok(allKudosBySender).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos list of identity {}", new Object[]{identityId, e});
            return Response.serverError().build();
        }
    }

    @Path(value="getEntityKudos")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getEntityKudos(@QueryParam(value="entityType") String entityType, @QueryParam(value="entityId") String entityId) {
        if (StringUtils.isBlank((String)entityType) || StringUtils.isBlank((String)entityId)) {
            LOG.warn((Object)"Bad request sent to server with empty 'attached entity id or type'");
            return Response.status((int)400).build();
        }
        try {
            List<Kudos> allKudosByEntity = this.kudosService.getAllKudosByEntity(entityType, entityId);
            return Response.ok(allKudosByEntity).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos entity of entity {}/{}", new Object[]{entityType, entityId, e});
            return Response.serverError().build();
        }
    }

    @Path(value="getAllKudosByPeriod")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getAllKudosByPeriod(@QueryParam(value="startDateInSeconds") long startDateInSeconds, @QueryParam(value="endDateInSeconds") long endDateInSeconds) {
        if (startDateInSeconds == 0L || endDateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'start or end' dates parameter");
            return Response.status((int)400).build();
        }
        try {
            List<Kudos> allKudosByPeriod = this.kudosService.getAllKudosByPeriod(startDateInSeconds, endDateInSeconds);
            return Response.ok(allKudosByPeriod).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos list of period: from {} to {}", new Object[]{startDateInSeconds, endDateInSeconds, e});
            return Response.serverError().build();
        }
    }

    @Path(value="getAllKudosByPeriodOfDate")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getAllKudosByPeriodOfDate(@QueryParam(value="dateInSeconds") long dateInSeconds) {
        if (dateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'dateInSeconds' parameter");
            return Response.status((int)400).build();
        }
        try {
            List<Kudos> allKudosByPeriod = this.kudosService.getAllKudosByPeriodOfDate(dateInSeconds);
            return Response.ok(allKudosByPeriod).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos list of period with date {}", new Object[]{dateInSeconds, e});
            return Response.serverError().build();
        }
    }

    @Path(value="getPeriodDates")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getPeriodDates(@QueryParam(value="periodType") String periodType, @QueryParam(value="dateInSeconds") long dateInSeconds) {
        if (dateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'dateInSeconds' parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn((Object)"Bad request sent to server with empty 'periodType' parameter");
            return Response.status((int)400).build();
        }
        try {
            KudosPeriodType kudosPeriodType = KudosPeriodType.valueOf(periodType);
            KudosPeriod kudosPeriod = kudosPeriodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
            return Response.ok((Object)kudosPeriod.toString()).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting period dates of type {} and date {}", new Object[]{periodType, dateInSeconds, e});
            return Response.serverError().build();
        }
    }
}

