/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.listener;

import java.util.LinkedHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.model.KudosEntityType;
import org.exoplatform.addon.kudos.service.KudosService;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.storage.api.ActivityStorage;

public class NewKudosSentActivityCommentListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(NewKudosSentActivityCommentListener.class);
    private ActivityStorage activityStorage;

    public NewKudosSentActivityCommentListener(ActivityStorage activityStorage) {
        this.activityStorage = activityStorage;
    }

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        if (KudosEntityType.valueOf(kudos.getEntityType()) != KudosEntityType.ACTIVITY) {
            return;
        }
        String activityId = kudos.getEntityId();
        try {
            ExoSocialActivity activity = this.activityStorage.getActivity(activityId);
            if (activity == null) {
                throw new IllegalStateException("Activity with id '" + activityId + "' wasn't found");
            }
            ExoSocialActivity activityComment = this.createComment(kudos);
            this.activityStorage.saveComment(activity, activityComment);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error adding comment on activity with id '" + activityId + "' for Kudos with id " + kudos.getTechnicalId()), (Throwable)e);
        }
    }

    private ExoSocialActivity createComment(Kudos kudos) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("");
        comment.setType("exokudos:activity");
        comment.setTitleId("activity_kudos");
        comment.setUserId(kudos.getSenderIdentityId());
        String senderLink = "<a href='" + kudos.getSenderURL() + "'>" + kudos.getSenderFullName() + "</a>";
        senderLink = StringEscapeUtils.unescapeHtml((String)senderLink);
        String receiverLink = "<a href='" + kudos.getReceiverURL() + "'>" + kudos.getReceiverFullName() + "</a>";
        receiverLink = StringEscapeUtils.unescapeHtml((String)receiverLink);
        String message = StringUtils.isBlank((CharSequence)kudos.getMessage()) ? "." : StringEscapeUtils.escapeHtml((String)(": " + kudos.getMessage().replace("#", "${_}")));
        try {
            message = HTMLSanitizer.sanitize((String)message);
        }
        catch (Exception e) {
            LOG.warn("Error while sanitizing message", new Object[]{message});
        }
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("RESOURCE_BUNDLE_VALUES_PARAM", senderLink + "#" + receiverLink + "#" + message);
        comment.setTemplateParams(templateParams);
        return comment;
    }
}

