/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.listener;

import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class KudosActivityListener
extends ActivityListenerPlugin {
    private ActivityManager activityManager;
    private KudosService kudosService;

    public KudosActivityListener(KudosService kudosService, ActivityManager activityManager) {
        this.kudosService = kudosService;
        this.activityManager = activityManager;
    }

    public void saveActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void updateActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        long activityId;
        Kudos kudos;
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        if (activity.getType().equals("exokudos:activity") && (kudos = this.kudosService.getKudosByActivityId(activityId = Utils.getActivityId(activity.getId()))) != null) {
            String newMessage = activity.getTitle();
            kudos.setMessage(newMessage);
            this.kudosService.updateKudos(kudos);
            Utils.computeKudosActivityProperties(activity, kudos);
            this.activityManager.updateActivity(activity, false);
        }
    }

    public void saveComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void updateComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
        this.updateActivity(activityLifeCycleEvent);
    }

    public void likeActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void likeComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }
}

