/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class KudosActivityChildPlugin
extends AbstractNotificationChildPlugin {
    private KudosService kudosService;

    public KudosActivityChildPlugin(KudosService kudosService, InitParams initParams) {
        super(initParams);
        this.kudosService = kudosService;
    }

    public String makeContent(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        if (notification == null) {
            return "";
        }
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        Kudos kudos = this.kudosService.getKudosByActivityId(Long.parseLong(activityId.replace("comment", "")));
        if (kudos == null) {
            return "";
        }
        TemplateContext templateContext = new TemplateContext(this.getId(), this.getLanguage(notification));
        templateContext.put((Object)"MESSAGE", (Object)kudos.getMessage());
        return TemplateUtils.processGroovy((TemplateContext)templateContext);
    }

    public String getId() {
        return "exokudos:activity";
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }
}

