/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener;

import io.meeds.kudos.BaseKudosTest;
import io.meeds.kudos.listener.ProfileUpdateListener;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import java.util.Collections;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={BaseKudosTest.class})
public class ProfileUpdateListenerTest
extends BaseKudosTest {
    @Mock
    private KudosService kudosService;
    @Mock
    private CachedActivityStorage activityStorage;
    @Autowired
    private IdentityManager identityManager;

    @Test
    public void testUpdateProfileAndDetectChanges() {
        ProfileUpdateListener profileUpdateListener = new ProfileUpdateListener((ActivityStorage)this.activityStorage, this.kudosService, this.identityManager);
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root1");
        Profile profile = rootIdentity.getProfile();
        this.identityManager.registerProfileListener((ProfileListenerPlugin)profileUpdateListener);
        Kudos kudos = new Kudos();
        kudos.setActivityId(1L);
        Mockito.when((Object)this.kudosService.countKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)1L);
        Mockito.when((Object)this.kudosService.getKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenReturn(Collections.singletonList(kudos));
        ((CachedActivityStorage)Mockito.doNothing().when((Object)this.activityStorage)).clearActivityCached(ArgumentMatchers.anyString());
        profile.setProperty("firstName", (Object)"Changed Firstname");
        this.identityManager.updateProfile(profile);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)1))).clearActivityCached(ArgumentMatchers.anyString());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).countKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).getKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        profile.setProperty("aboutMe", (Object)"Changed ABOUT_ME");
        profile.removeProperty("firstName");
        this.identityManager.updateProfile(profile);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)1))).clearActivityCached(ArgumentMatchers.anyString());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).countKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)1))).getKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        profile.setProperty("avatar", (Object)"new/avatar");
        this.identityManager.updateProfile(profile);
        ((CachedActivityStorage)Mockito.verify((Object)this.activityStorage, (VerificationMode)Mockito.times((int)2))).clearActivityCached(ArgumentMatchers.anyString());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)2))).countKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((KudosService)Mockito.verify((Object)this.kudosService, (VerificationMode)Mockito.times((int)2))).getKudosByPeriodAndReceiver(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
    }
}

