/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosPeriodType;
import io.meeds.kudos.model.exception.KudosAlreadyLinkedException;
import io.meeds.kudos.rest.KudosREST;
import io.meeds.kudos.service.KudosService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={KudosREST.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class KudosRestTest {
    private static final String REST_PATH = "/kudos";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private KudosService kudosService;
    @MockBean
    private IdentityManager identityManager;
    private MockMvc mockMvc;

    @BeforeEach
    public void setUp() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void testGetAllKudos() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testGetAllKudosByUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void testGetReceivedKudos() throws Exception {
        Mockito.when((Object)this.kudosService.getDefaultKudosPeriodType()).thenReturn((Object)KudosPeriodType.DEFAULT);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/1/received?returnSize=true&limit=10", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void testGetSentKudos() throws Exception {
        Mockito.when((Object)this.kudosService.getDefaultKudosPeriodType()).thenReturn((Object)KudosPeriodType.DEFAULT);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/1/sent?returnSize=true&limit=10", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void countKudosNoEntity() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byEntity/sent/count", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void countKudosNoEntityId() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byEntity/sent/count?entityType=activity", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void countKudosNoEntityType() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byEntity/sent/count?entityId=1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void countKudos() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byEntity/sent/count?entityType=activity&entityId=1", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    public void testGetKudosByActivityIdForbidden() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = KudosRestTest.mockConversationState();){
            Mockito.when((Object)this.kudosService.getKudosByActivityId(Long.valueOf(ArgumentMatchers.anyLong()), (Identity)ArgumentMatchers.any())).thenThrow(IllegalAccessException.class);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byActivity/1", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isForbidden());
        }
    }

    @Test
    public void testGetKudosByActivityId() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = KudosRestTest.mockConversationState();){
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byActivity/1", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    public void testGetKudosListOfActivityForbidden() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = KudosRestTest.mockConversationState();){
            Mockito.when((Object)this.kudosService.getKudosListOfActivity((String)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any())).thenThrow(IllegalAccessException.class);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byActivity/1/all", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isForbidden());
        }
    }

    @Test
    public void testGetKudosListOfActivity() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = KudosRestTest.mockConversationState();){
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/kudos/byActivity/1/all", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    public void testSendKudosNoEntityId() throws Exception {
        Kudos kudos = this.newKudos();
        kudos.setEntityId(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).content(KudosRestTest.asJsonString(kudos)));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testSendKudosNoEntityType() throws Exception {
        Kudos kudos = this.newKudos();
        kudos.setEntityType(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).content(KudosRestTest.asJsonString(kudos)));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testSendKudosNoReceiverId() throws Exception {
        Kudos kudos = this.newKudos();
        kudos.setReceiverId(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).content(KudosRestTest.asJsonString(kudos)));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testSendKudosNoReceiverType() throws Exception {
        Kudos kudos = this.newKudos();
        kudos.setReceiverType(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).content(KudosRestTest.asJsonString(kudos)));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testSendKudos() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            Kudos kudos = this.newKudos();
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).contentType(MediaType.APPLICATION_JSON).content(KudosRestTest.asJsonString(kudos)));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    @Test
    public void testDeleteKudosForbidden() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            ((KudosService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.kudosService)).deleteKudosById(1L, SIMPLE_USER);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/kudos/1", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isForbidden());
        }
    }

    @Test
    public void testDeleteKudosNotFound() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            ((KudosService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.kudosService)).deleteKudosById(1L, SIMPLE_USER);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/kudos/1", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isNotFound());
        }
    }

    @Test
    public void testDeleteKudosAlreadyLinked() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            ((KudosService)Mockito.doThrow(KudosAlreadyLinkedException.class).when((Object)this.kudosService)).deleteKudosById(1L, SIMPLE_USER);
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/kudos/1", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
        }
    }

    @Test
    public void testDeleteKudos() throws Exception {
        try (MockedStatic<ConversationState> conversationStateMock = this.mockCurrentIdentityId();){
            ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/kudos/1", (Object[])new Object[0]).with(this.testSimpleUser()));
            response.andExpect(MockMvcResultMatchers.status().isOk());
        }
    }

    private Kudos newKudos() {
        Kudos kudos = new Kudos();
        kudos.setEntityType("activity");
        kudos.setEntityId("1");
        kudos.setReceiverType("user");
        kudos.setReceiverId("1");
        return kudos;
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    private RequestPostProcessor testAdminUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("administrators")});
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    public static MockedStatic<ConversationState> mockConversationState() {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        ConversationState conversationState = (ConversationState)Mockito.mock(ConversationState.class);
        MockedStatic conversationStateStatic = Mockito.mockStatic(ConversationState.class);
        conversationStateStatic.when(ConversationState::getCurrent).thenReturn((Object)conversationState);
        Mockito.when((Object)conversationState.getIdentity()).thenReturn((Object)identity);
        return conversationStateStatic;
    }

    public MockedStatic<ConversationState> mockCurrentIdentityId() {
        MockedStatic<ConversationState> conversationStateStatic = KudosRestTest.mockConversationState();
        Mockito.when((Object)ConversationState.getCurrent().getIdentity().getUserId()).thenReturn((Object)SIMPLE_USER);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(SIMPLE_USER)).thenReturn((Object)identity);
        return conversationStateStatic;
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

