/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.activity.processor;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.utils.MentionUtils;

public class ActivityKudosProcessor
extends BaseActivityProcessorPlugin {
    private KudosService kudosService;
    private String defaultPortal;

    public ActivityKudosProcessor(KudosService kudosService, UserPortalConfigService userPortalConfigService, InitParams initParams) {
        super(initParams);
        this.kudosService = kudosService;
        this.defaultPortal = userPortalConfigService.getMetaPortal();
    }

    public void processActivity(ExoSocialActivity activity) {
        List<Kudos> linkedKudosList;
        if (activity.isComment()) {
            return;
        }
        if (activity.getLinkedProcessedEntities() == null) {
            activity.setLinkedProcessedEntities(new HashMap());
        }
        if ((linkedKudosList = (List<Kudos>)activity.getLinkedProcessedEntities().get("kudosList")) == null) {
            linkedKudosList = this.kudosService.getKudosListOfActivity(activity.getId());
            activity.getLinkedProcessedEntities().put("kudosList", linkedKudosList);
        }
        if (linkedKudosList != null) {
            for (Kudos kudos : linkedKudosList) {
                kudos.setMessage(MentionUtils.substituteUsernames((String)this.defaultPortal, (String)kudos.getMessage()));
            }
        }
    }
}

