/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.layoutmanagement.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.layoutmanagement.utils.SiteManagementUtils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.gatein.api.Portal;
import org.gatein.api.Util;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;

@Path(value="v1/sites")
@Tag(name="v1/sites", description="Managing sites")
public class SiteManagementRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SiteManagementRestService.class);
    private Portal portal;
    private LayoutService layoutService;

    public SiteManagementRestService(Portal portal, LayoutService layoutService) {
        this.portal = portal;
        this.layoutService = layoutService;
    }

    @DELETE
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Delete a site", method="GET", description="This deletes the given site")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteSite(@Parameter(description="site type") @QueryParam(value="siteType") String siteType, @Parameter(description="site name") @QueryParam(value="siteName") String siteName) {
        try {
            SiteId siteId = Util.from((SiteKey)new SiteKey(siteType, siteName));
            Site site = this.portal.getSite(siteId);
            if (!SiteManagementUtils.canEditSite(site)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            this.portal.removeSite(siteId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Error when deleting the site with name {} and type {}", new Object[]{siteName, siteType, e});
            return Response.serverError().build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="update a site", method="PUT", description="This updates the given site")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateSite(@Context HttpServletRequest request, @Parameter(description="site type") @QueryParam(value="siteType") String siteType, @Parameter(description="site name") @QueryParam(value="siteName") String siteName, @Parameter(description="site Label") @QueryParam(value="siteLabel") String siteLabel, @Parameter(description="site description") @QueryParam(value="siteDescription") String siteDescription, @Parameter(description="site displayed in meta site") @QueryParam(value="displayed") boolean displayed, @Parameter(description="site display order") @QueryParam(value="displayOrder") int displayOrder, @Parameter(description="site banner UploadId") @QueryParam(value="bannerUploadId") String bannerUploadId, @Parameter(description="if site banner has been removed") @DefaultValue(value="false") @QueryParam(value="bannerRemoved") boolean bannerRemoved, @Parameter(description="Used to retrieve the site label and description in the requested language") @QueryParam(value="lang") String lang) {
        try {
            SiteId siteId = Util.from((SiteKey)new SiteKey(siteType, siteName));
            Site site = this.portal.getSite(siteId);
            if (!SiteManagementUtils.canEditSite(site)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            PortalConfig portalConfig = this.layoutService.getPortalConfig(new SiteKey(siteType, siteName));
            portalConfig.setDescription(siteDescription);
            portalConfig.setLabel(siteLabel);
            portalConfig.setDisplayed(displayed);
            portalConfig.setDisplayOrder(displayed ? displayOrder : 0);
            if (bannerRemoved && portalConfig.getBannerFileId() != 0L) {
                this.layoutService.removeSiteBanner(siteName);
                portalConfig.setBannerFileId(0L);
            } else if (StringUtils.isNotBlank((String)bannerUploadId)) {
                portalConfig.setBannerUploadId(bannerUploadId);
            }
            this.layoutService.save(portalConfig);
            return Response.ok((Object)EntityBuilder.buildSiteEntity((PortalConfig)portalConfig, (HttpServletRequest)request, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false, (Locale)this.getLocale(lang))).build();
        }
        catch (Exception e) {
            LOG.error("Error when updating the site with name {} and type {}", new Object[]{siteName, siteType, e});
            return Response.serverError().build();
        }
    }

    @Path(value="/permissions")
    @PATCH
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Update a page access and edit permission", method="PATCH", description="This updates the given page access and edit permission")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Page permissions updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Page not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateSitePermissions(@Context HttpServletRequest request, @Parameter(description="Site type", required=true) @QueryParam(value="siteType") String siteType, @Parameter(description="Site name", required=true) @QueryParam(value="siteName") String siteName, @Parameter(description="Site new edit permission", required=true) @QueryParam(value="editPermission") String editPermission, @Parameter(description="Site new access permissions", required=true) @QueryParam(value="accessPermissions") String accessPermissions, @Parameter(description="Used to retrieve the site label and description in the requested language") @QueryParam(value="lang") String lang) {
        try {
            if (StringUtils.isBlank((String)siteName) || StringUtils.isBlank((String)siteType)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"params are mandatory").build();
            }
            SiteId siteId = Util.from((SiteKey)new SiteKey(siteType, siteName));
            Site site = this.portal.getSite(siteId);
            if (site == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!SiteManagementUtils.canEditSite(site)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (!StringUtils.isBlank((String)editPermission)) {
                site.setEditPermission(Util.from((String[])new String[]{editPermission}));
            }
            if (!StringUtils.isBlank((String)accessPermissions)) {
                List accessPermissionsList = List.of(accessPermissions.split(",")).stream().distinct().toList();
                site.setAccessPermission(Util.from(accessPermissionsList));
            }
            this.portal.saveSite(site);
            PortalConfig portalConfig = this.layoutService.getPortalConfig(new SiteKey(siteType, siteName));
            return Response.ok((Object)EntityBuilder.buildSiteEntity((PortalConfig)portalConfig, (HttpServletRequest)request, (boolean)false, null, (boolean)false, (boolean)false, (boolean)false, (Locale)this.getLocale(lang))).build();
        }
        catch (Exception e) {
            LOG.error("Error when updating site permissions with name {} and type {}", new Object[]{siteName, siteType, e});
            return Response.serverError().build();
        }
    }

    private Locale getLocale(String lang) {
        return StringUtils.isBlank((String)lang) ? null : Locale.forLanguageTag(lang);
    }
}

