/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.navigation.webui.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.navigation.webui.TreeNode;
import org.exoplatform.navigation.webui.component.UINavigationNodeSelector;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationError;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;

@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/navigation/UINavigationNodeSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}, csrfCheck=false), @EventConfig(listeners={NodeModifiedActionListener.class})}), @ComponentConfig(id="NavigationNodePopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={EditPageNodeActionListener.class}), @EventConfig(listeners={EditSelectedNodeActionListener.class}), @EventConfig(listeners={CopyNodeActionListener.class}), @EventConfig(listeners={CutNodeActionListener.class}), @EventConfig(listeners={CloneNodeActionListener.class}), @EventConfig(listeners={PasteNodeActionListener.class}), @EventConfig(listeners={MoveUpActionListener.class}), @EventConfig(listeners={MoveDownActionListener.class}), @EventConfig(listeners={DeleteNodeActionListener.class}, confirm="UIPageNodeSelector.deleteNavigation")}), @ComponentConfig(id="UINavigationNodeSelectorPopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={PasteNodeActionListener.class})})})
public class UINavigationNodeSelector
extends UIContainer {
    private UserNavigation edittedNavigation;
    private TreeNode copyOfTreeNodeData;
    private TreeNode rootNode;
    private UserPortal userPortal;
    private UserNodeFilterConfig filterConfig;
    private Map<String, Map<Locale, State>> userNodeLabels;
    private static final Scope DEFAULT_SCOPE = Scope.GRANDCHILDREN;
    private Scope navigationScope = DEFAULT_SCOPE;

    public UINavigationNodeSelector() throws Exception {
        UIRightClickPopupMenu rightClickPopup = (UIRightClickPopupMenu)((UIRightClickPopupMenu)this.addChild(UIRightClickPopupMenu.class, "UINavigationNodeSelectorPopupMenu", null)).setRendered(true);
        rightClickPopup.setActions(new String[]{"AddNode", "PasteNode"});
        UITree uiTree = (UITree)this.addChild(UITree.class, null, "TreeNodeSelector");
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("Id");
        uiTree.setBeanChildCountField("childrenCount");
        uiTree.setBeanLabelField("encodedResolvedLabel");
        uiTree.setBeanIconField("icon");
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.createUIComponent(UIRightClickPopupMenu.class, "NavigationNodePopupMenu", null);
        uiPopupMenu.setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CloneNode", "CutNode", "DeleteNode", "MoveUp", "MoveDown"});
        uiTree.setUIRightClickPopupMenu(uiPopupMenu);
        this.userNodeLabels = new HashMap();
    }

    public void setUserNodeLabels(Map<String, Map<Locale, State>> labels) {
        this.userNodeLabels = labels;
    }

    public Map<String, Map<Locale, State>> getUserNodeLabels() {
        return this.userNodeLabels;
    }

    public void initTreeData() throws Exception {
        if (this.edittedNavigation == null || this.userPortal == null) {
            throw new IllegalStateException("edittedNavigation and userPortal must be initialized first");
        }
        try {
            TreeNode node = this.rootNode = new TreeNode(this.edittedNavigation, this.userPortal.getNode(this.edittedNavigation, this.navigationScope, this.filterConfig, null));
            if (this.rootNode.getChildren().size() > 0 && (node = this.rebaseNode(this.rootNode.getChild(0), this.navigationScope)) == null) {
                this.initTreeData();
                return;
            }
            this.selectNode(node);
        }
        catch (Exception ex) {
            this.rootNode = null;
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg." + NavigationError.NAVIGATION_NO_SITE.name(), null, 0));
            UIPopupWindow popup = (UIPopupWindow)this.getAncestorOfType(UIPopupWindow.class);
            popup.createEvent("ClosePopup", Event.Phase.PROCESS, context).broadcast();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChild(UIWorkingWorkspace.class);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            prContext.setFullRender(true);
        }
    }

    public TreeNode selectNode(TreeNode node) {
        if (node == null) {
            return null;
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        tree.setSelected((Object)node);
        if (node.getId().equals(this.rootNode.getId())) {
            tree.setChildren(null);
            tree.setSibbling((Collection)node.getChildren());
            tree.setParentSelected((Object)node);
        } else {
            TreeNode parentNode = node.getParent();
            tree.setChildren((Collection)node.getChildren());
            tree.setSibbling((Collection)parentNode.getChildren());
            tree.setParentSelected((Object)parentNode);
        }
        return node;
    }

    public TreeNode rebaseNode(TreeNode treeNode, Scope scope) {
        if (treeNode == null || treeNode.getNode() == null) {
            return null;
        }
        UserNode userNode = treeNode.getNode();
        if (userNode.getId() == null) {
            return treeNode;
        }
        this.userPortal.rebaseNode(userNode, scope, (NodeChangeListener)this.getRootNode());
        return this.findNode(treeNode.getId());
    }

    public void save() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        try {
            this.userPortal.saveNode(this.getRootNode().getNode(), (NodeChangeListener)this.getRootNode());
            DescriptionService descriptionService = (DescriptionService)this.getApplicationComponent(DescriptionService.class);
            Map i18nizedLabels = this.userNodeLabels;
            for (String treeNodeId : i18nizedLabels.keySet()) {
                Map labels;
                TreeNode node = this.findNode(treeNodeId);
                if (node == null || (labels = (Map)i18nizedLabels.get(treeNodeId)) == null || labels.size() <= 0) continue;
                descriptionService.setDescriptions(node.getNode().getId(), labels);
            }
        }
        catch (NavigationServiceException ex) {
            context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg." + ex.getError().name(), null, 0));
        }
    }

    public TreeNode getCopyNode() {
        return this.copyOfTreeNodeData;
    }

    public void setCopyNode(TreeNode copyNode) {
        this.copyOfTreeNodeData = copyNode;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public void setUserPortal(UserPortal userPortal) {
        this.userPortal = userPortal;
        this.setFilterConfig(UserNodeFilterConfig.builder().withReadWriteCheck().build());
    }

    private void setFilterConfig(UserNodeFilterConfig config) {
        this.filterConfig = config;
    }

    public void setEdittedNavigation(UserNavigation nav) {
        this.edittedNavigation = nav;
    }

    public UserNavigation getEdittedNavigation() {
        return this.edittedNavigation;
    }

    public TreeNode findNode(String nodeID) {
        if (this.getRootNode() == null) {
            return null;
        }
        return this.getRootNode().findNode(nodeID);
    }

    public void setScope(Scope scope) {
        this.navigationScope = scope;
    }

    public Scope getScope() {
        return this.navigationScope;
    }

    private void invokeI18NizedLabels(TreeNode node) {
        DescriptionService descriptionService = (DescriptionService)this.getApplicationComponent(DescriptionService.class);
        try {
            Map labels = descriptionService.getDescriptions(node.getId());
            node.setI18nizedLabels(labels);
        }
        catch (NullPointerException npe) {
            node.setI18nizedLabels(null);
        }
    }

    public TreeNode getSelectedNode() {
        return (TreeNode)((UITree)this.getChild(UITree.class)).getSelected();
    }

    static /* synthetic */ void access$000(UINavigationNodeSelector x0, TreeNode x1) {
        x0.invokeI18NizedLabels(x1);
    }
}

