/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.toolbar.portlet;

import java.util.List;
import javax.portlet.PortletPreferences;
import org.exoplatform.navigation.webui.Utils;
import org.exoplatform.navigation.webui.component.UINavigationManagement;
import org.exoplatform.navigation.webui.component.UIPageNodeForm;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.util.NavigationURLUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.toolbar.portlet.UIAdminToolbarContainer;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfigs(value={@ComponentConfig(events={@EventConfig(listeners={ChangeEditingActionListener.class}), @EventConfig(listeners={EditNavigationActionListener.class})}), @ComponentConfig(type=UIPageNodeForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={UIPageNodeForm.SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchLabelModeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ChangeLanguageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.SwitchVisibleActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.ClearPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm.CreatePageActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIAdminToolbarContainer
extends UIPortletApplication {
    public static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";
    private static final String SEO_COMPONENT_ID = "SEO";
    private static final String SEO_TOOLBAR_FORM_POPUP_CONTAINER_ID = "UISEOToolbarFormPopupContainer";
    private static final String EDIT_NAVIGATION_POPUP_CONTAINER_ID = "UIPopupWindow-UIEditNavigationPopupContainer";
    private static final String PAGE_MANAGEMENT_URI = "administration/pageManagement";
    private String pageManagementLink = null;
    private String userId = null;
    protected UINavigationManagement naviManager;
    protected UIExtension seoExtension;
    protected boolean useDrawer;

    public UIAdminToolbarContainer() throws Exception {
        PortalRequestContext context = Util.getPortalRequestContext();
        Boolean quickEdit = (Boolean)context.getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        if (quickEdit == null) {
            context.getRequest().getSession().setAttribute(TURN_ON_QUICK_EDIT, (Object)false);
        }
        this.addChild(UIPopupContainer.class, null, SEO_TOOLBAR_FORM_POPUP_CONTAINER_ID);
        UIExtensionManager uiExtensionManager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        this.seoExtension = ((UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class)).getUIExtension(UIAdminToolbarContainer.class.getName(), SEO_COMPONENT_ID);
        if (this.seoExtension != null) {
            uiExtensionManager.addUIExtension(this.seoExtension, null, (UIContainer)this);
        }
        PortletRequestContext pcontext = (PortletRequestContext)RequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        this.useDrawer = Boolean.parseBoolean(pref.getValue("useDrawer", "false"));
    }

    public String getTemplate() {
        if (this.useDrawer) {
            return "app:/groovy/navigation/webui/component/UIAdminToolbarDrawerContainer.gtmpl";
        }
        return "app:/groovy/navigation/webui/component/UIAdminToolbarContainer.gtmpl";
    }

    public String getPageManagementLink() {
        if (this.pageManagementLink == null) {
            UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
            String[] adminGroups = userACL.getAdminGroups().split(";");
            this.pageManagementLink = NavigationURLUtils.getURL((SiteKey)SiteKey.group((String)adminGroups[0]), (String)PAGE_MANAGEMENT_URI);
        }
        return this.pageManagementLink;
    }

    public boolean hasEditPermissionOnPortal() throws Exception {
        return Utils.hasEditPermissionOnPortal();
    }

    public boolean isGroupNavigation() throws Exception {
        return SiteType.GROUP.equals((Object)Utils.getSelectedNavigation().getKey().getType());
    }

    public boolean isPortaNavigation() throws Exception {
        return SiteType.PORTAL.equals((Object)Utils.getSelectedNavigation().getKey().getType());
    }

    public boolean isUserNavigation() throws Exception {
        return SiteType.USER.equals((Object)Utils.getSelectedNavigation().getKey().getType());
    }

    public boolean hasEditPermissionOnNavigation() throws Exception {
        return Utils.hasEditPermissionOnNavigation();
    }

    public boolean hasEditPermissionOnPage() throws Exception {
        return Utils.hasEditPermissionOnPage();
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        boolean canAccessMenu = this.canAcceedMenu();
        if (canAccessMenu) {
            super.processRender(app, context);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        boolean canAccessMenu = this.canAcceedMenu();
        if (canAccessMenu) {
            super.processRender(context);
        }
    }

    public static UserPortal getUserPortal() {
        UserPortalConfig portalConfig = Util.getPortalRequestContext().getUserPortalConfig();
        return portalConfig.getUserPortal();
    }

    public void renderChildren() throws Exception {
        List list = this.getChildren();
        for (UIComponent child : list) {
            if (child.getClass().equals(this.getSEOClass()) || !child.isRendered()) continue;
            this.renderChild(child);
        }
    }

    public Class<? extends UIComponent> getSEOClass() {
        if (this.seoExtension != null) {
            return this.seoExtension.getComponent();
        }
        return null;
    }

    public String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public String getUIPageId() {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIPage uiPage = (UIPage)portalApp.findFirstComponentOfType(UIPage.class);
        return uiPage.getId();
    }

    private boolean canAcceedMenu() throws Exception {
        return this.hasEditPermissionOnNavigation() || this.hasEditPermissionOnPage() || this.hasEditPermissionOnPortal();
    }
}

