/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.leadcapture.entity.ResponseEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ResponseDAO
extends GenericDAOJPAImpl<ResponseEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(ResponseDAO.class);

    public List<ResponseEntity> getResponsesByForm(long formId, long leadId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ResponseEntity.getResponsesByFormAndLead", ResponseEntity.class).setParameter("formId", (Object)formId).setParameter("leadId", (Object)leadId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<ResponseEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of responses by formId {}", new Object[]{formId, e});
            return new ArrayList<ResponseEntity>();
        }
    }

    public List<ResponseEntity> getResponsesByLead(long leadId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ResponseEntity.getResponsesByLead", ResponseEntity.class).setParameter("leadId", (Object)leadId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<ResponseEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of responses by lead {}", new Object[]{leadId, e});
            return new ArrayList<ResponseEntity>();
        }
    }
}

