/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.listeners;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.leadcapture.Utils;
import org.exoplatform.leadcapture.dao.LeadDAO;
import org.exoplatform.leadcapture.dto.LeadCaptureSettings;
import org.exoplatform.leadcapture.dto.MailContentDTO;
import org.exoplatform.leadcapture.dto.MailTemplateDTO;
import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.entity.MailTemplateEntity;
import org.exoplatform.leadcapture.services.LCMailService;
import org.exoplatform.leadcapture.services.LeadCaptureSettingsService;
import org.exoplatform.leadcapture.services.LeadsManagementService;
import org.exoplatform.leadcapture.services.MailTemplatesManagementService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.task.dto.TaskDto;

public class NewLeadListener
extends Listener<LeadEntity, String> {
    private static final Log LOG = ExoLogger.getLogger(NewLeadListener.class);
    private LCMailService lcMailService;
    private MailTemplatesManagementService mailTemplatesManagementService;
    private OrganizationService organizationService;
    private LeadDAO leadDAO;
    private LeadCaptureSettingsService leadCaptureSettingsService;
    private LeadsManagementService leadsManagementService;

    public NewLeadListener(LCMailService lcMailService, MailTemplatesManagementService mailTemplatesManagementService, OrganizationService organizationService, LeadsManagementService leadsManagementService, LeadDAO leadDAO, LeadCaptureSettingsService leadCaptureSettingsService) {
        this.lcMailService = lcMailService;
        this.mailTemplatesManagementService = mailTemplatesManagementService;
        this.organizationService = organizationService;
        this.leadDAO = leadDAO;
        this.leadCaptureSettingsService = leadCaptureSettingsService;
        this.leadsManagementService = leadsManagementService;
    }

    public void onEvent(Event<LeadEntity, String> event) throws Exception {
        LeadEntity lead = (LeadEntity)event.getSource();
        LeadCaptureSettings settings = this.leadCaptureSettingsService.getSettings();
        if (StringUtils.isEmpty((CharSequence)lead.getCommunityUserName())) {
            Query query = new Query();
            query.setEmail(lead.getMail());
            ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query);
            if (users.getSize() > 0) {
                User communityUser = ((User[])users.load(0, 1))[0];
                lead.setCommunityRegistration(true);
                lead.setCommunityUserName(communityUser.getUserName());
                lead.setCommunityRegistrationDate(communityUser.getCreatedDate());
                LOG.info("Lead {} has been associated to the community user {}", new Object[]{lead.getId(), communityUser.getUserName()});
            }
        }
        if (settings.getUserExperienceSpace() != null && settings.getUserExperienceBotUserName() != null) {
            TaskDto task;
            ExoSocialActivity activity = Utils.createActivity(lead);
            if (activity != null) {
                lead.setActivityId(activity.getId());
            }
            if (lead.getStatus().equals("Open") && (task = this.leadsManagementService.createTask(lead)) != null) {
                lead.setTaskId(task.getId());
                lead.setTaskUrl(LeadsManagementService.buildTaskURL(task));
                LOG.info("new task with id = {} has been associated to the lead {}", new Object[]{task.getId(), lead.getId()});
            }
        }
        this.leadDAO.update(lead);
        String leadEvent = "newLead";
        if (lead.getCaptureMethod().equals("Community registration")) {
            leadEvent = "newCommunityRegistration";
        }
        if (lead.getCaptureMethod().equals("Trial registration")) {
            leadEvent = "newTrialRegistration";
        }
        List<MailTemplateEntity> templates = this.mailTemplatesManagementService.getTemplatesbyEvent(leadEvent);
        for (MailTemplateEntity template : templates) {
            MailContentDTO content = null;
            MailTemplateDTO mailTemplateDTO = this.mailTemplatesManagementService.toMailTemplateDTO(template);
            if (mailTemplateDTO.getContents().size() <= 0 || (content = Utils.getContentForMail(mailTemplateDTO, lead)) == null) continue;
            this.lcMailService.sendMail(content.getContent(), content.getSubject(), lead, null, null);
            LOG.info("service=lead-capture operation=send_mail_to_lead parameters=\"lead_id:{},lead_name:{},mail_template_id:{},mail_template_name:{},reason: NewLead\"", new Object[]{lead.getId(), lead.getFirstName() + " " + lead.getLastName(), mailTemplateDTO.getId(), mailTemplateDTO.getName()});
        }
    }
}

