/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.leadcapture.dto.ResourceDTO;
import org.exoplatform.leadcapture.entity.ResourceEntity;
import org.exoplatform.leadcapture.services.ResourcesManagementService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;

@Path(value="/leadcapture/lcresources")
@Produces(value={"application/json"})
public class ResoucesManagementRest
implements ResourceContainer {
    private final Log LOG = ExoLogger.getLogger(ResoucesManagementRest.class);
    private final String portalContainerName = "portal";
    private ResourcesManagementService resourcesManagementService;

    public ResoucesManagementRest(ResourcesManagementService resourcesManagementService) {
        this.resourcesManagementService = resourcesManagementService;
    }

    @GET
    @Path(value="resources")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response getResources(@Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            return Response.ok(this.resourcesManagementService.getResources()).build();
        }
        catch (Exception e) {
            this.LOG.error((Object)"An error occured when trying to get resources list", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="resources")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response add(@Context UriInfo uriInfo, ResourceDTO resourceDTO) throws Exception {
        try {
            this.resourcesManagementService.addResource(resourceDTO);
            return Response.ok((Object)"Resource added").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to add new resource {}", new Object[]{resourceDTO.getName(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="resources/{id}")
    @RolesAllowed(value={"ux-team"})
    public Response delete(@Context UriInfo uriInfo, @PathParam(value="id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            ResourceEntity resourceEntity = this.resourcesManagementService.getResourceById(id);
            if (resourceEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Resource not found").build();
            }
            this.resourcesManagementService.deleteResource(resourceEntity);
            this.LOG.info("Resource {} deleted by {}", new Object[]{id, sourceIdentity.getRemoteId()});
            return Response.ok((Object)"Resource deleted").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to delete Resource {}", new Object[]{id, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="resources")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"ux-team"})
    public Response update(@Context UriInfo uriInfo, ResourceDTO resourceDTO) throws Exception {
        try {
            this.resourcesManagementService.updateResource(resourceDTO);
            return Response.ok((Object)"Resource updated").build();
        }
        catch (Exception e) {
            this.LOG.error("An error occured when trying to update Resource {}", new Object[]{resourceDTO.getId(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

