/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.listeners;

import org.exoplatform.leadcapture.entity.LeadEntity;
import org.exoplatform.leadcapture.services.LeadsManagementService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;

public class TaskUpdateListener
extends Listener<TaskService, TaskPayload> {
    private static final Log LOG = ExoLogger.getLogger(TaskUpdateListener.class);
    protected LeadsManagementService leadsManagementService;

    public TaskUpdateListener(LeadsManagementService leadsManagementService) {
        this.leadsManagementService = leadsManagementService;
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        Task before = data.before();
        Task after = data.after();
        LeadEntity leadEntity = this.leadsManagementService.getLeadByTask(before.getId());
        if (leadEntity != null && before != null && after != null) {
            if (this.isDiff(before.getAssignee(), after.getAssignee())) {
                leadEntity.setAssignee(after.getAssignee());
                LOG.info("Lead {} associated to the Task {} has been assigned to {}", new Object[]{leadEntity.getId(), after.getId(), after.getAssignee()});
            }
            if (this.isDiff(before.getStatus(), after.getStatus())) {
                leadEntity.setStatus(after.getStatus().getName());
                LOG.info("Status of the lead {} associated to the Task {} has been cahanged to {}", new Object[]{leadEntity.getId(), after.getId(), after.getStatus().getName()});
            }
        }
    }

    private boolean isDiff(Object before, Object after) {
        if (before == after) {
            return false;
        }
        if (before != null) {
            return !before.equals(after);
        }
        return !after.equals(before);
    }
}

