/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.test.service;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.leadcapture.dto.MailContentDTO;
import org.exoplatform.leadcapture.dto.MailTemplateDTO;
import org.exoplatform.leadcapture.entity.MailContentEntity;
import org.exoplatform.leadcapture.entity.MailTemplateEntity;
import org.exoplatform.leadcapture.services.MailTemplatesManagementService;
import org.exoplatform.leadcapture.test.BaseTemplatesManagementTest;
import org.junit.Assert;
import org.junit.Test;

public class MailTemplatesManagementServiceTest
extends BaseTemplatesManagementTest {
    @Test
    public void testServiceInstantiated() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        Assert.assertNotNull((Object)mailTemplatesManagementService);
    }

    @Test
    public void getTemplates() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        List templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)0L);
        this.newTemplate();
        templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)1L);
    }

    @Test
    public void addTemplate() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        List templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)0L);
        MailTemplateDTO mailTemplateDTO = this.newTemplateDTO();
        MailContentDTO contentDTO = this.newContentDTO(mailTemplateDTO);
        ArrayList<MailContentDTO> contents = new ArrayList<MailContentDTO>();
        contents.add(contentDTO);
        mailTemplateDTO.setContents(contents);
        mailTemplatesManagementService.addTemplate(mailTemplateDTO);
        templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)1L);
    }

    @Test
    public void getTemplatebyId() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        List templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)0L);
        MailTemplateEntity templateEntity = this.newTemplate();
        templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)1L);
        Assert.assertNotNull((Object)mailTemplatesManagementService.getTemplatebyId(templateEntity.getId()));
    }

    @Test
    public void getTemplatesbyEvent() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        List templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)0L);
        MailTemplateEntity templateEntity = this.newTemplate();
        templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)1L);
        Assert.assertNotNull((Object)mailTemplatesManagementService.getTemplatesbyEvent(templateEntity.getEvent()));
    }

    @Test
    public void deleteTemplate() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        List templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)0L);
        MailTemplateEntity templateEntity = this.newTemplate();
        templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)1L);
        Assert.assertNotNull((Object)mailTemplatesManagementService.getTemplatebyId(templateEntity.getId()));
        mailTemplatesManagementService.deleteTemplate(templateEntity);
        templates = mailTemplatesManagementService.getTemplates();
        Assert.assertEquals((long)templates.size(), (long)0L);
        Assert.assertEquals((Object)mailTemplatesManagementService.getTemplatebyId(templateEntity.getId()), null);
    }

    @Test
    public void updateTemplate() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        MailTemplateEntity templateEntity = this.newTemplate();
        Assert.assertEquals((Object)templateEntity.getEvent(), (Object)this.templateEvent);
        templateEntity.setEvent("newTemplateEvent");
        mailTemplatesManagementService.updateTemplate(mailTemplatesManagementService.toMailTemplateDTO(templateEntity));
        Assert.assertEquals((Object)templateEntity.getEvent(), (Object)"newTemplateEvent");
    }

    @Test
    public void toMailContentEntitiesList() {
    }

    @Test
    public void toMailTemplateDTO() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        MailTemplateEntity templateEntity = this.newTemplate();
        MailTemplateDTO mailTemplateDTO = mailTemplatesManagementService.toMailTemplateDTO(templateEntity);
        this.compareMailTemplateResult(templateEntity, mailTemplateDTO);
    }

    @Test
    public void toMailTemplateEntity() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        MailTemplateDTO mailTemplateDTO = this.newTemplateDTO();
        MailTemplateEntity templateEntity = mailTemplatesManagementService.toMailTemplateEntity(mailTemplateDTO);
        this.compareMailTemplateResult(templateEntity, mailTemplateDTO);
    }

    @Test
    public void toMailContentEntity() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        MailTemplateDTO mailTemplateDTO = this.newTemplateDTO();
        MailContentDTO mailContentDTO = this.newContentDTO(mailTemplateDTO);
        MailContentEntity mailContentEntity = mailTemplatesManagementService.toMailContentEntity(mailContentDTO);
        this.compareMailContentResult(mailContentEntity, mailContentDTO);
    }

    @Test
    public void toMailContentDTO() {
        MailTemplatesManagementService mailTemplatesManagementService = this.getService(MailTemplatesManagementService.class);
        MailTemplateEntity mailTemplateEntity = this.newTemplate();
        MailContentEntity mailContentEntity = this.newContent(mailTemplateEntity);
        MailContentDTO mailContentDTO = mailTemplatesManagementService.toMailContentDTO(mailContentEntity);
        this.compareMailContentResult(mailContentEntity, mailContentDTO);
    }
}

