/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.leadcapture.entity.MailContentEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MailContentDAO
extends GenericDAOJPAImpl<MailContentEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(MailContentDAO.class);

    public List<MailContentEntity> getContentByTemplate(long templateId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("MailContentEntity.getContentByTemplate", MailContentEntity.class).setParameter("templateId", (Object)templateId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<MailContentEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of mail content by formId {}", new Object[]{templateId, e});
            return new ArrayList<MailContentEntity>();
        }
    }
}

