/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.services;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.leadcapture.dao.ResourceDAO;
import org.exoplatform.leadcapture.dto.ResourceDTO;
import org.exoplatform.leadcapture.entity.ResourceEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ResourcesManagementService {
    private final Log LOG = ExoLogger.getLogger(ResourcesManagementService.class);
    private ResourceDAO resourceDAO;

    public ResourcesManagementService(ResourceDAO resourceDAO) {
        this.resourceDAO = resourceDAO;
    }

    public List<ResourceDTO> getResources() {
        ArrayList<ResourceDTO> resourceDTOList = new ArrayList<ResourceDTO>();
        List resourceEntities = this.resourceDAO.findAll();
        if (resourceEntities != null) {
            for (ResourceEntity resourceEntity : resourceEntities) {
                if (resourceEntity == null) continue;
                resourceDTOList.add(this.toResourceDTO(resourceEntity));
            }
        }
        return resourceDTOList;
    }

    public ResourceDTO addResource(ResourceDTO resourceDTO) {
        return this.toResourceDTO((ResourceEntity)this.resourceDAO.create(this.toResourceEntity(resourceDTO)));
    }

    public void deleteResource(ResourceEntity resourceEntityEntity) {
        this.resourceDAO.delete(resourceEntityEntity);
    }

    public ResourceDTO updateResource(ResourceDTO resourceDTO) {
        ResourceEntity newRessource = (ResourceEntity)this.resourceDAO.update(this.toResourceEntity(resourceDTO));
        return this.toResourceDTO(newRessource);
    }

    public ResourceEntity getResourceById(Long id) {
        return (ResourceEntity)this.resourceDAO.find(id);
    }

    public ResourceEntity getResourceUrlByPath(String path) {
        List resourceEntities = this.resourceDAO.findAll();
        for (ResourceEntity resourceEntity : resourceEntities) {
            if (!resourceEntity.getPath().contains(path) && !path.contains(resourceEntity.getPath())) continue;
            return resourceEntity;
        }
        return null;
    }

    public List<ResourceDTO> toResourceDtoList(List<ResourceEntity> resourceEntities) {
        ArrayList<ResourceDTO> resourceDTOS = new ArrayList<ResourceDTO>();
        for (ResourceEntity resourceEntity : resourceEntities) {
            resourceDTOS.add(this.toResourceDTO(resourceEntity));
        }
        return resourceDTOS;
    }

    public ResourceDTO toResourceDTO(ResourceEntity resourceEntity) {
        ResourceDTO resourceDTO = new ResourceDTO();
        resourceDTO.setId(resourceEntity.getId());
        resourceDTO.setName(resourceEntity.getName());
        resourceDTO.setType(resourceEntity.getType());
        resourceDTO.setPath(resourceEntity.getPath());
        resourceDTO.setUrl(resourceEntity.getUrl());
        return resourceDTO;
    }

    public ResourceEntity toResourceEntity(ResourceDTO resourceDTO) {
        ResourceEntity resourceEntity = new ResourceEntity();
        resourceEntity.setId(resourceDTO.getId());
        resourceEntity.setName(resourceDTO.getName());
        resourceEntity.setType(resourceDTO.getType());
        resourceEntity.setPath(resourceDTO.getPath());
        resourceEntity.setUrl(resourceDTO.getUrl());
        return resourceEntity;
    }
}

