/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.leadcapture.test;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.leadcapture.dao.MailContentDAO;
import org.exoplatform.leadcapture.dao.MailTemplateDAO;
import org.exoplatform.leadcapture.dto.MailContentDTO;
import org.exoplatform.leadcapture.dto.MailTemplateDTO;
import org.exoplatform.leadcapture.entity.MailContentEntity;
import org.exoplatform.leadcapture.entity.MailTemplateEntity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class BaseTemplatesManagementTest {
    protected static PortalContainer container;
    protected String templateName = "templateName";
    protected String templateDescription = "templateDescription";
    protected String templateEvent = "templateEvent";
    protected String templateForm = "templateForm";
    protected String templateField = "templateField";
    protected String mailSubject = "mailSubject";
    protected String mailLanguage = "en";
    protected String mailContent = "mailContent";

    @BeforeClass
    public static void beforeTest() {
        container = PortalContainer.getInstance();
        Assert.assertNotNull((Object)container);
    }

    @Before
    public void beforeMethodTest() {
        RequestLifeCycle.begin((ExoContainer)container);
    }

    @After
    public void afterMethodTest() {
        MailTemplateDAO mailTemplateDAO = this.getService(MailTemplateDAO.class);
        MailContentDAO mailContentDAO = this.getService(MailContentDAO.class);
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)container);
        mailContentDAO.deleteAll();
        mailTemplateDAO.deleteAll();
        RequestLifeCycle.end();
    }

    protected <T> T getService(Class<T> componentType) {
        return (T)container.getComponentInstanceOfType(componentType);
    }

    protected MailTemplateEntity newTemplate() {
        MailTemplateDAO mailTemplateDAO = this.getService(MailTemplateDAO.class);
        MailTemplateEntity mailTemplateEntity = new MailTemplateEntity();
        mailTemplateEntity.setName(this.templateName);
        mailTemplateEntity.setDescription(this.templateDescription);
        mailTemplateEntity.setEvent(this.templateEvent);
        mailTemplateEntity.setForm(this.templateForm);
        mailTemplateEntity.setField(this.templateField);
        mailTemplateEntity = (MailTemplateEntity)mailTemplateDAO.create((Object)mailTemplateEntity);
        return mailTemplateEntity;
    }

    protected MailTemplateDTO newTemplateDTO() {
        MailTemplateDTO mailTemplateDTO = new MailTemplateDTO();
        mailTemplateDTO.setName(this.templateName);
        mailTemplateDTO.setDescription(this.templateDescription);
        mailTemplateDTO.setEvent(this.templateEvent);
        mailTemplateDTO.setForm(this.templateForm);
        mailTemplateDTO.setField(this.templateField);
        return mailTemplateDTO;
    }

    protected MailContentEntity newContent(MailTemplateEntity mailTemplateEntity) {
        MailContentDAO mailContentDAO = this.getService(MailContentDAO.class);
        MailContentEntity mailContentEntity = new MailContentEntity();
        mailContentEntity.setSubject(this.mailSubject);
        mailContentEntity.setLanguage(this.mailLanguage);
        mailContentEntity.setContent(this.mailContent);
        mailContentEntity.setMailTemplateEntity(mailTemplateEntity);
        mailContentEntity = (MailContentEntity)mailContentDAO.create((Object)mailContentEntity);
        return mailContentEntity;
    }

    protected MailContentDTO newContentDTO(MailTemplateDTO mailTemplateDTO) {
        MailContentDTO mailContentDTO = new MailContentDTO();
        mailContentDTO.setSubject(this.mailSubject);
        mailContentDTO.setLanguage(this.mailLanguage);
        mailContentDTO.setContent(this.mailContent);
        mailContentDTO.setMailTemplateDTO(mailTemplateDTO);
        return mailContentDTO;
    }

    protected void compareMailTemplateResult(MailTemplateEntity mailTemplateEntity, MailTemplateDTO mailTemplateDTO) {
        Assert.assertEquals((Object)mailTemplateEntity.getId(), (Object)mailTemplateDTO.getId());
        Assert.assertEquals((Object)mailTemplateEntity.getDescription(), (Object)mailTemplateDTO.getDescription());
        Assert.assertEquals((Object)mailTemplateEntity.getEvent(), (Object)mailTemplateDTO.getEvent());
        Assert.assertEquals((Object)mailTemplateEntity.getField(), (Object)mailTemplateDTO.getField());
        Assert.assertEquals((Object)mailTemplateEntity.getForm(), (Object)mailTemplateDTO.getForm());
    }

    protected void compareMailContentResult(MailContentEntity mailContentEntity, MailContentDTO mailContentDTO) {
        Assert.assertEquals((Object)mailContentEntity.getId(), (Object)mailContentDTO.getId());
        Assert.assertEquals((Object)mailContentEntity.getContent(), (Object)mailContentDTO.getContent());
        Assert.assertEquals((Object)mailContentEntity.getLanguage(), (Object)mailContentDTO.getLanguage());
        Assert.assertEquals((Object)mailContentEntity.getSubject(), (Object)mailContentDTO.getSubject());
        this.compareMailTemplateResult(mailContentEntity.getMailTemplateEntity(), mailContentDTO.getMailTemplateDTO());
    }
}

