/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko.listeners;

import org.exoplatform.addons.lecko.UserEventService;
import org.exoplatform.addons.lecko.dao.UserEvent;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;

public class LeckoActivityListener
extends ActivityListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)LeckoActivityListener.class.getName());
    private ActivityManager activityManager;
    private UserEventService userEventService;

    public LeckoActivityListener(ActivityManager activityManager, UserEventService userEventService) {
        this.activityManager = activityManager;
        this.userEventService = userEventService;
    }

    public void saveActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        LOG.debug((Object)"Save Activity Event.");
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(activity.getId());
        if (!excludedTypes.contains(activity.getType())) {
            LOG.debug("Activity is type {}, which is not an excluded type", new Object[]{activity.getType()});
            this.userEventService.storeEvent(activity.getPosterId(), UserEvent.eventType.CREATE.name(), activity.getUpdated(), activity.getId());
        } else {
            LOG.debug("Activity is type {}, which is an excluded type", new Object[]{activity.getType()});
        }
    }

    public void updateActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
    }

    public void saveComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
        LOG.debug((Object)"Save Comment Event");
        ExoSocialActivity comment = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        ExoSocialActivity activity = this.activityManager.getParentActivity(comment);
        while (activity.isComment()) {
            activity = this.activityManager.getParentActivity(activity);
        }
        if (!excludedTypes.contains(activity.getType())) {
            LOG.debug("Parent activity is type {}, which is not an excluded type", new Object[]{activity.getType()});
            this.userEventService.storeEvent(comment.getPosterId(), UserEvent.eventType.CREATE.name(), comment.getUpdated(), comment.getId());
        } else {
            LOG.debug("Parent activity is type {}, which is an excluded type", new Object[]{activity.getType()});
        }
    }

    public void likeActivity(ActivityLifeCycleEvent activityLifeCycleEvent) {
        LOG.debug((Object)"Save Activity Like Event.");
        ExoSocialActivity activity = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(activity.getId());
        if (!excludedTypes.contains(activity.getType())) {
            LOG.debug("Activity is type {}, which is not an excluded type", new Object[]{activity.getType()});
            this.userEventService.storeEvent(activity.getPosterId(), UserEvent.eventType.LIKE.name(), activity.getUpdated(), activity.getId());
        } else {
            LOG.debug("Activity is type {}, which is an excluded type", new Object[]{activity.getType()});
        }
    }

    public void likeComment(ActivityLifeCycleEvent activityLifeCycleEvent) {
        LOG.debug((Object)"Save Comment Like Event.");
        ExoSocialActivity comment = (ExoSocialActivity)activityLifeCycleEvent.getSource();
        comment = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(comment.getId());
        ExoSocialActivity activity = this.activityManager.getParentActivity(comment);
        while (activity.isComment()) {
            activity = this.activityManager.getParentActivity(activity);
        }
        if (!excludedTypes.contains(activity.getType())) {
            LOG.debug("Activity is type {}, which is not an excluded type", new Object[]{activity.getType()});
            this.userEventService.storeEvent(comment.getPosterId(), UserEvent.eventType.LIKE.name(), comment.getUpdated(), comment.getId());
        } else {
            LOG.debug("Activity is type {}, which is an excluded type", new Object[]{activity.getType()});
        }
    }

    public static enum excludedTypes {
        SPACE_ACTIVITY,
        USER_ACTIVITIES_FOR_RELATIONSHIP,
        USER_COMMENTS_ACTIVITY_FOR_RELATIONSHIP;


        public static boolean contains(String s) {
            for (excludedTypes type : excludedTypes.values()) {
                if (!type.name().equals(s)) continue;
                return true;
            }
            return false;
        }
    }
}

