/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.addons.lecko.ExportException;
import org.exoplatform.addons.lecko.SimpleDataBuilder;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

abstract class SocialActivity {
    protected static Log LOG = ExoLogger.getLogger(SimpleDataBuilder.class);
    protected static Map<String, String> user_map = new ConcurrentHashMap<String, String>();
    protected int DEFAULT_OFFSET = 0;
    protected int DEFAULT_LIMIT = 20;

    SocialActivity() {
    }

    public abstract void loadActivityStream(PrintWriter var1, IdentityManager var2, ActivityManager var3) throws Exception;

    protected void getExoComments(ExoSocialActivity activity, String placeName, String displayName, ActivityManager activityManager, IdentityManager identityManager, PrintWriter out) throws Exception {
        LOG.debug("Getting Comments : {} ", new Object[]{placeName});
        String idEvent = "";
        String date = "";
        String idactor = "";
        int offsetComments = this.DEFAULT_OFFSET;
        boolean hasNextComments = true;
        RealtimeListAccess commentsWithListAccess = activityManager.getCommentsWithListAccess(activity, true);
        int commentCountToTreat = commentsWithListAccess.getSize();
        int commentTreated = 0;
        while (hasNextComments) {
            List comments = commentsWithListAccess.loadAsList(offsetComments, this.DEFAULT_LIMIT);
            if (comments.size() != 0) {
                for (ExoSocialActivity comment : comments) {
                    idactor = comment.getPosterId();
                    if (!user_map.containsKey(idactor)) {
                        user_map.put(idactor, Integer.toString(user_map.size() + 1));
                        idactor = user_map.get(idactor);
                    } else {
                        idactor = user_map.get(idactor);
                    }
                    out.print(idactor + ";");
                    idEvent = "comment";
                    out.print(idEvent + ";");
                    Calendar createdDate = Calendar.getInstance();
                    createdDate.setTime(new Date(comment.getPostedTime()));
                    date = ISO8601.format((Calendar)createdDate);
                    out.print(date + ";");
                    out.print(placeName + ";" + displayName + ";");
                    out.println();
                    this.getLikes(comment, date, placeName, "", identityManager, out);
                    this.getSubComments(comment, placeName, displayName, activityManager, identityManager, out);
                    ++commentTreated;
                }
                offsetComments += this.DEFAULT_LIMIT;
                out.flush();
                continue;
            }
            hasNextComments = false;
        }
        if (commentCountToTreat > commentTreated) {
            throw new ExportException("Exported comments for activity " + activity.getId() + " doesn't correspond to the number of comments. An error occured during the export.");
        }
        LOG.debug("End Getting Comments : {} ", new Object[]{placeName});
    }

    protected void getSubComments(ExoSocialActivity activity, String placeName, String displayName, ActivityManager activityManager, IdentityManager identityManager, PrintWriter out) throws Exception {
        LOG.debug("Getting Sub Comments : {} ", new Object[]{placeName});
        String idEvent = "";
        String date = "";
        String idactor = "";
        int offsetComments = this.DEFAULT_OFFSET;
        boolean hasNextComments = true;
        List comments = activityManager.getSubComments(activity);
        int commentCountToTreat = comments.size();
        int commentTreated = 0;
        if (comments.size() != 0) {
            for (ExoSocialActivity comment : comments) {
                idactor = comment.getPosterId();
                if (!user_map.containsKey(idactor)) {
                    user_map.put(idactor, Integer.toString(user_map.size() + 1));
                    idactor = user_map.get(idactor);
                } else {
                    idactor = user_map.get(idactor);
                }
                out.print(idactor + ";");
                idEvent = "comment";
                out.print(idEvent + ";");
                Calendar createdDate = Calendar.getInstance();
                createdDate.setTime(new Date(comment.getPostedTime()));
                date = ISO8601.format((Calendar)createdDate);
                out.print(date + ";");
                out.print(placeName + ";" + displayName + ";");
                out.println();
                this.getLikes(comment, date, placeName, "", identityManager, out);
                ++commentTreated;
            }
            out.flush();
        }
        if (commentCountToTreat != commentTreated) {
            throw new ExportException("Exported Sub comments for activity " + activity.getId() + " doesn't correspond to the number of comments. An error occured during the export.");
        }
        LOG.debug("End Getting Sub Comments : {} ", new Object[]{placeName});
    }

    protected void getLikes(ExoSocialActivity activity, String date, String placeName, String displayName, IdentityManager identityManager, PrintWriter out) throws Exception {
        LOG.debug("Getting Likes : {}", new Object[]{placeName});
        String idEvent = "";
        String idactor = "";
        List<String> likerIds = Arrays.asList(activity.getLikeIdentityIds());
        int likeCountToTreat = likerIds.size();
        int likeTreated = 0;
        for (String likerId : likerIds) {
            idactor = identityManager.getIdentity(likerId, false).getRemoteId();
            if (!user_map.containsKey(idactor)) {
                user_map.put(idactor, Integer.toString(user_map.size() + 1));
                idactor = user_map.get(idactor);
            } else {
                idactor = user_map.get(idactor);
            }
            out.print(idactor + ";");
            idEvent = "like";
            out.print(idEvent + ";");
            out.print(date + ";");
            out.print(placeName + ";" + displayName + ";");
            out.println();
            out.flush();
            ++likeTreated;
        }
        if (likeCountToTreat != likeTreated) {
            throw new ExportException("Exported like for activity " + activity.getId() + " doesn't correspond to the number of likes. An error occured during the export.");
        }
        LOG.debug("End Getting Likes : {} ", new Object[]{placeName});
    }
}

