/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.lecko;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.exoplatform.addons.lecko.DataBuilder;
import org.exoplatform.addons.lecko.ExportException;
import org.exoplatform.addons.lecko.JobStatusService;
import org.exoplatform.addons.lecko.LeckoServiceController;
import org.exoplatform.addons.lecko.SocialActivity;
import org.exoplatform.addons.lecko.SpaceActivity;
import org.exoplatform.addons.lecko.UserActivity;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SimpleDataBuilder
implements DataBuilder {
    private static Log LOG = ExoLogger.getLogger(SimpleDataBuilder.class);
    private SpaceService spaceService;
    private final String leckoTempDirectory;
    private final String leckoOutputName;
    private JobStatusService jobStatusService;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private int initialNbSpaces;
    private int initialNbUsers;
    private static boolean runBuild = false;
    private final int spaceLimit;
    private final int userLimit;

    public SimpleDataBuilder(SpaceService spaceService, IdentityManager identityManager, ActivityManager activityManager, JobStatusService jobStatusService) {
        this.spaceService = spaceService;
        this.jobStatusService = jobStatusService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.leckoTempDirectory = LeckoServiceController.getRootPath();
        this.initialNbSpaces = -1;
        this.initialNbUsers = -1;
        File directory = new File(this.leckoTempDirectory);
        this.leckoOutputName = LeckoServiceController.getFileName();
        this.spaceLimit = PropertyManager.getProperty((String)"exo.addon.lecko.spaceLimit") != null ? Integer.parseInt(PropertyManager.getProperty((String)"exo.addon.lecko.spaceLimit")) : -1;
        this.userLimit = PropertyManager.getProperty((String)"exo.addon.lecko.userLimit") != null ? Integer.parseInt(PropertyManager.getProperty((String)"exo.addon.lecko.userLimit")) : -1;
    }

    @Override
    public void stopBuild() {
        runBuild = false;
    }

    @Override
    public boolean getBuildStatus() {
        return runBuild;
    }

    @Override
    public int getPercent() {
        if (this.initialNbSpaces != -1 && this.initialNbUsers != -1) {
            LOG.info("Initial count status : {}, nbSpaces : {}, nb users : {}", new Object[]{this.jobStatusService.countStatus(), this.initialNbSpaces, this.initialNbUsers});
            int result = (int)((double)this.jobStatusService.countStatus().longValue() / (double)(this.initialNbUsers + this.initialNbSpaces) * 100.0);
            if (result > 100) {
                result = 100;
            }
            return result;
        }
        ListAccess spaceListAccess = this.spaceService.getAllSpacesWithListAccess();
        ListAccess userListAccess = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentitiesByProfileFilter("organization", new ProfileFilter(), false);
        try {
            LOG.info("count status : {}, nbSpaces : {}, nb users : {}", new Object[]{this.jobStatusService.countStatus(), spaceListAccess.getSize(), userListAccess.getSize()});
            return (int)((double)this.jobStatusService.countStatus().longValue() / (double)(spaceListAccess.getSize() + userListAccess.getSize()) * 100.0);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when counting status", (Throwable)e);
            return 0;
        }
    }

    @Override
    public void resetCounter() {
        this.initialNbSpaces = -1;
        this.initialNbUsers = -1;
    }

    public void resumeBuild() {
        runBuild = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean build() {
        PrintWriter out = null;
        Object file = null;
        boolean state = true;
        runBuild = true;
        try {
            Identity[] identities;
            Space[] spaces;
            String extractOutputPath = this.leckoTempDirectory + "/" + this.leckoOutputName;
            out = new PrintWriter(new FileWriter(extractOutputPath, true));
            ListAccess spaceListAccess = this.spaceService.getAllSpacesWithListAccess();
            ListAccess userListAccess = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentitiesByProfileFilter("organization", new ProfileFilter(), false);
            this.initialNbUsers = userListAccess.getSize();
            this.initialNbSpaces = spaceListAccess.getSize();
            LOG.debug("Space to extract : {}, users to extract : {}", new Object[]{this.initialNbSpaces, this.initialNbUsers});
            if (this.getPercent() == 100) {
                LOG.info((Object)"Extraction already finished.");
                boolean bl = true;
                return bl;
            }
            LOG.info((Object)"Lecko-Addons : Begin Extraction...");
            int offset = 0;
            int size = 20;
            boolean hasNextSpace = true;
            int countSpace = 1;
            int lastSpaceLog = 0;
            LOG.info((Object)"Lecko-Addons : Begin Space Extraction...");
            while (this.spaceLimit != 0 && hasNextSpace && (spaces = (Space[])spaceListAccess.load(offset, size)).length != 0) {
                if (spaces.length < size) {
                    hasNextSpace = false;
                }
                for (Space space : spaces) {
                    if (runBuild) {
                        String spaceId = space.getId();
                        String spaceDisplayName = space.getDisplayName();
                        double spacePercent = (double)countSpace / (double)spaceListAccess.getSize() * 100.0;
                        if ((int)spacePercent % 5 == 0 && lastSpaceLog != (int)spacePercent) {
                            LOG.info("Extract Data from spaces {}%", new Object[]{(int)spacePercent});
                            lastSpaceLog = (int)spacePercent;
                        }
                        if (this.jobStatusService.findByIdentityIdAndProvider(spaceId, "space") == null) {
                            LOG.debug("Export datas for spaceId={} ", new Object[]{spaceId});
                            SpaceActivity sa = new SpaceActivity(space);
                            ((SocialActivity)sa).loadActivityStream(out, this.identityManager, this.activityManager);
                            this.jobStatusService.storeStatus(spaceId, "space");
                        } else {
                            LOG.debug("Data already extracted for this space: {} in this iteration.", new Object[]{spaceId});
                        }
                        if (this.spaceLimit == -1 || ++countSpace <= this.spaceLimit) continue;
                        break;
                    }
                    LOG.info((Object)"Export was stopped");
                    boolean bl = true;
                    return bl;
                }
                offset += size;
                out.flush();
                if (this.spaceLimit == -1 || countSpace <= this.spaceLimit) continue;
                break;
            }
            offset = 0;
            size = 500;
            boolean hasNextUser = true;
            int countUser = 1;
            int lastUserLog = 0;
            LOG.info((Object)"Lecko-Addons : Begin User Extraction...");
            while (this.userLimit != 0 && hasNextUser && (identities = (Identity[])userListAccess.load(offset, size)).length != 0) {
                if (identities.length < size) {
                    hasNextUser = false;
                }
                LOG.debug("Identities array size : {}", new Object[]{identities.length});
                for (Identity identity : identities) {
                    if (runBuild) {
                        String userId = identity.getRemoteId();
                        double userPercent = (double)countUser / (double)userListAccess.getSize() * 100.0;
                        if ((int)userPercent % 5 == 0 && lastUserLog != (int)userPercent) {
                            LOG.info("Extract Data from users {}%", new Object[]{(int)userPercent});
                            lastUserLog = (int)userPercent;
                        }
                        if (this.jobStatusService.findByIdentityIdAndProvider(userId, "organization") == null) {
                            LOG.debug("Extract Data from user:{}", new Object[]{userId});
                            UserActivity ua = new UserActivity(identity);
                            ((SocialActivity)ua).loadActivityStream(out, this.identityManager, this.activityManager);
                            this.jobStatusService.storeStatus(userId, "organization");
                        } else {
                            LOG.debug("Data already extracted for this user : {} in this iteration.", new Object[]{userId});
                        }
                        LOG.debug("Users treaten : {}/{}", new Object[]{++countUser, this.initialNbUsers});
                        if (this.userLimit == -1 || countUser <= this.userLimit) continue;
                        break;
                    }
                    LOG.info((Object)"Export was stopped");
                    boolean bl = true;
                    return bl;
                }
                offset += size;
                out.flush();
                if (this.userLimit == -1 || countUser <= this.userLimit) continue;
                break;
            }
            LOG.info((Object)"Lecko-Addons : End Extraction");
        }
        catch (ExportException ex) {
            LOG.error((Object)"Lecko-Addons : Extraction stopped by ExportException. Stop the extract by security", (Throwable)ex);
            state = false;
        }
        catch (Exception ex) {
            LOG.error((Object)"Lecko-Addons : Extraction stopped by exception", (Throwable)ex);
            state = false;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            runBuild = false;
        }
        return state;
    }

    @Override
    public void deleteDumpFile() {
        String extractOutputPath = this.leckoTempDirectory + "/" + this.leckoOutputName;
        File file = new File(extractOutputPath);
        file.delete();
    }

    @Override
    public void run() {
        EntityManagerService service = (EntityManagerService)PortalContainer.getInstance().getComponentInstanceOfType(EntityManagerService.class);
        RequestLifeCycle.begin((ComponentRequestLifecycle)service);
        this.build();
        LeckoServiceController.getService(LeckoServiceController.class).UploadLeckoData();
        RequestLifeCycle.end();
    }
}

