/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest.services.CalendarPortlet;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.ws.bean.CalendarResource;
import org.exoplatform.calendar.ws.bean.ErrorResource;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.json.JSONObject;

@Path(value="portlet/HomePageCalendarPortlet")
@Produces(value={"application/json"})
public class CalendarPortletRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(CalendarPortletRestService.class);
    private static final String HOME_PAGE_CALENDAR_SETTINGS = "IntranetHomePageCalendarSettings";
    private CalendarService calendarService;
    private SettingService settingService;
    private OrganizationService organizationService;
    private SpaceService spaceService;

    public CalendarPortletRestService(CalendarService calendarService, SettingService settingService, OrganizationService organizationService, SpaceService spaceService) {
        this.calendarService = calendarService;
        this.settingService = settingService;
        this.organizationService = organizationService;
        this.spaceService = spaceService;
    }

    @GET
    @Path(value="settings")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets calendar portlet settings", httpMethod="GET", response=Response.class, notes="This returns calendar portlet settings")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getSettings(@Context UriInfo uriInfo, @ApiParam(value="space id", required=false) @QueryParam(value="spaceId") String spaceId) throws Exception {
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        List<Object> calendarDisplayedList = new ArrayList<CalendarResource>();
        ArrayList<CalendarResource> calendarNonDisplayedList = new ArrayList<CalendarResource>();
        if (StringUtils.isNotBlank((CharSequence)spaceId)) {
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                return EntityBuilder.getResponse((Object)new ErrorResource("space " + spaceId + " not found", "space not found"), (UriInfo)uriInfo, (MediaType)RestUtils.getJsonMediaType(), (Response.Status)Response.Status.NOT_FOUND);
            }
            String groupId = space.getGroupId();
            ArrayList list = new ArrayList();
            List groupCalendars = this.calendarService.getGroupCalendars(new String[]{groupId}, true, username);
            for (GroupCalendarData group : groupCalendars) {
                Optional.ofNullable(group.getCalendars()).ifPresent(list::addAll);
            }
            calendarDisplayedList = list.stream().map(cal -> new CalendarResource(cal, this.getBasePath(uriInfo))).collect(Collectors.toList());
        } else {
            String defaultCalendarLabel = "Default";
            Iterator itr1 = this.getAllCal(username).iterator();
            String[] nonDisplayedCalendarList = this.getNonDisplayedCalendarIds();
            while (itr1.hasNext()) {
                Calendar c = (Calendar)itr1.next();
                if (c.getGroups() == null && c.getId().equals(Utils.getDefaultCalendarId((String)username)) && c.getName().equals(this.calendarService.getDefaultCalendarName())) {
                    c.setName(defaultCalendarLabel);
                }
                if (this.containsCalendarId(nonDisplayedCalendarList, c.getId())) {
                    calendarNonDisplayedList.add(new CalendarResource(c, this.getBasePath(uriInfo)));
                    continue;
                }
                calendarDisplayedList.add(new CalendarResource(c, this.getBasePath(uriInfo)));
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allDisplayedCals", calendarDisplayedList);
        jsonObject.put("nonDisplayedCals", calendarNonDisplayedList);
        return EntityBuilder.getResponse((Object)jsonObject.toString(), (UriInfo)uriInfo, (MediaType)RestUtils.getJsonMediaType(), (Response.Status)Response.Status.OK);
    }

    private boolean containsCalendarId(String[] calendarIds, String id) {
        if (calendarIds != null) {
            return Arrays.asList(calendarIds).contains(id);
        }
        return false;
    }

    @POST
    @Path(value="settings")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="sets calendar portlet settings", httpMethod="POST", response=Response.class, notes="This sets calendar portlet settings")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response saveSettings(@Context UriInfo uriInfo, String calIds) throws Exception {
        this.settingService.remove(org.exoplatform.commons.api.settings.data.Context.USER, Scope.APPLICATION, HOME_PAGE_CALENDAR_SETTINGS);
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.USER, Scope.APPLICATION, HOME_PAGE_CALENDAR_SETTINGS, SettingValue.create((String)("NonDisplayedCalendar:" + calIds)));
        return EntityBuilder.getResponse((Object)"", (UriInfo)uriInfo, (MediaType)RestUtils.getJsonMediaType(), (Response.Status)Response.Status.OK);
    }

    private List getAllCal(String username) throws Exception {
        List calList = this.calendarService.getUserCalendars(username, true);
        List lgcd = this.calendarService.getGroupCalendars(this.getUserGroups(username), true, username);
        ArrayList<String> calIds = new ArrayList<String>();
        for (GroupCalendarData g : lgcd) {
            for (Calendar c : g.getCalendars()) {
                if (calIds.contains(c.getId())) continue;
                calIds.add(c.getId());
                calList.add(c);
            }
        }
        return calList;
    }

    private String[] getNonDisplayedCalendarIds() {
        SettingValue settingNode = this.settingService.get(org.exoplatform.commons.api.settings.data.Context.USER, Scope.APPLICATION, HOME_PAGE_CALENDAR_SETTINGS);
        if (settingNode != null && settingNode.getValue().toString().split(":").length == 2) {
            return settingNode.getValue().toString().split(":")[1].split(",");
        }
        return new String[0];
    }

    private String getBasePath(UriInfo uriInfo) {
        StringBuilder path = new StringBuilder(uriInfo.getBaseUri().toString());
        path.append("/v1/calendar");
        return path.toString();
    }

    private String[] getUserGroups(String username) throws Exception {
        Object[] objs = this.organizationService.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groupsList = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groupsList[i] = ((Group)objs[i]).getId();
        }
        return groupsList;
    }
}

