/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.portlet.juzu.gettingstarted;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.Tools;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.platform.portlet.juzu.gettingstarted.models.GettingStartedService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.web.application.RequestContext;

public class GettingStarted {
    private static final Log LOG = ExoLogger.getLogger(GettingStarted.class);
    HashMap parameters = new HashMap();
    HashMap<String, String> status = new HashMap();
    int progress = 0;
    String remoteUser;
    @Inject
    NodeHierarchyCreator nodeHierarchyCreator_;
    @Inject
    @Path(value="gettingStarted.gtmpl")
    Template gettingStarted;
    @Inject
    @Path(value="gettingStartedList.gtmpl")
    Template gettingStartedList;
    @Inject
    private GettingStartedService startService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        String remoteUser = null;
        Node userPrivateNode = null;
        try (SessionProvider sProvider = null;){
            remoteUser = ConversationState.getCurrent().getIdentity().getUserId();
            sProvider = SessionProvider.createSystemProvider();
            userPrivateNode = this.nodeHierarchyCreator_.getUserNode(sProvider, remoteUser).getNode("ApplicationData");
            if (!userPrivateNode.hasNode("GsGadget")) {
                Node gettingStartedNode = userPrivateNode.addNode("GsGadget");
                gettingStartedNode.setProperty("exo:gs_deleteGadget", false);
                gettingStartedNode.setProperty("exo:gs_profile", false);
                gettingStartedNode.setProperty("exo:gs_connect", false);
                gettingStartedNode.setProperty("exo:gs_space", false);
                gettingStartedNode.setProperty("exo:gs_activities", false);
                gettingStartedNode.setProperty("exo:gs_document", false);
                gettingStartedNode.getSession().save();
            }
        }
    }

    @View
    public Response.Content index() throws Exception {
        return this.gettingStarted.ok().withCharset(Tools.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ajax
    @Resource
    public Response.Content delete() throws Exception {
        String userId = null;
        try (SessionProvider sProvider = null;){
            Node gettingStartedNode;
            userId = RequestContext.getCurrentInstance().getRemoteUser();
            sProvider = SessionProvider.createSystemProvider();
            Node userPrivateNode = this.nodeHierarchyCreator_.getUserNode(sProvider, userId).getNode("ApplicationData");
            if (userPrivateNode.hasNode("GsGadget") && (gettingStartedNode = userPrivateNode.getNode("GsGadget")).hasProperty("exo:gs_deleteGadget")) {
                gettingStartedNode.setProperty("exo:gs_deleteGadget", true);
                gettingStartedNode.save();
            }
        }
        return this.gettingStarted.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ajax
    @Resource
    public Response getGsList(String reload) throws Exception {
        HashMap<String, String> bundle = new HashMap<String, String>();
        Boolean Isshow = true;
        boolean isChange = false;
        PropertyIterator propertiesIt = null;
        this.remoteUser = RequestContext.getCurrentInstance().getRemoteUser();
        try (SessionProvider sProvider = null;){
            block27: {
                Node gettingStartedNode;
                sProvider = SessionProvider.createSystemProvider();
                Node userPrivateNode = this.nodeHierarchyCreator_.getUserNode(sProvider, this.remoteUser).getNode("ApplicationData");
                if (userPrivateNode.hasNode("GsGadget")) {
                    gettingStartedNode = userPrivateNode.getNode("GsGadget");
                    propertiesIt = userPrivateNode.getNode("GsGadget").getProperties("exo:gs_*");
                    while (propertiesIt.hasNext()) {
                        Property tempProp = (Property)propertiesIt.next();
                        if (tempProp.getName().equals("exo:gs_profile")) {
                            if (!isChange) {
                                isChange = this.updateAction(tempProp, gettingStartedNode);
                                continue;
                            }
                            this.updateAction(tempProp, gettingStartedNode);
                            continue;
                        }
                        if (tempProp.getName().equals("exo:gs_connect")) {
                            if (!isChange) {
                                isChange = this.updateAction(tempProp, gettingStartedNode);
                                continue;
                            }
                            this.updateAction(tempProp, gettingStartedNode);
                            continue;
                        }
                        if (tempProp.getName().equals("exo:gs_activities")) {
                            if (!isChange) {
                                isChange = this.updateAction(tempProp, gettingStartedNode);
                                continue;
                            }
                            this.updateAction(tempProp, gettingStartedNode);
                            continue;
                        }
                        if (tempProp.getName().equals("exo:gs_space")) {
                            if (!isChange) {
                                isChange = this.updateAction(tempProp, gettingStartedNode);
                                continue;
                            }
                            this.updateAction(tempProp, gettingStartedNode);
                            continue;
                        }
                        if (!tempProp.getName().equals("exo:gs_document")) continue;
                        if (!isChange) {
                            isChange = this.updateAction(tempProp, gettingStartedNode);
                            continue;
                        }
                        this.updateAction(tempProp, gettingStartedNode);
                    }
                    if (this.progress > 100) {
                        this.progress = 100;
                    }
                    if (this.progress == 100) {
                        Isshow = false;
                    }
                } else {
                    try {
                        gettingStartedNode = userPrivateNode.addNode("GsGadget");
                        userPrivateNode.save();
                        gettingStartedNode.setProperty("exo:gs_deleteGadget", false);
                        gettingStartedNode.setProperty("exo:gs_profile", false);
                        gettingStartedNode.setProperty("exo:gs_connect", false);
                        gettingStartedNode.setProperty("exo:gs_space", false);
                        gettingStartedNode.setProperty("exo:gs_activities", false);
                        gettingStartedNode.setProperty("exo:gs_document", false);
                        gettingStartedNode.save();
                    }
                    catch (ItemExistsException e) {
                        if (!LOG.isInfoEnabled()) break block27;
                        LOG.info((Object)"GsGadget already exists!");
                        try {
                            userPrivateNode.refresh(false);
                        }
                        catch (RepositoryException ex) {
                            if (!LOG.isErrorEnabled()) break block27;
                            LOG.error((Object)"Can not refresh userPrivateNode", (Throwable)ex);
                        }
                    }
                }
            }
            try {
                bundle.put("profile", LinkProvider.getUserProfileUri((String)this.remoteUser));
                bundle.put("connect", LinkProvider.getUserConnectionsUri((String)this.remoteUser));
                bundle.put("space", "/portal/intranet/all-spaces");
                bundle.put("activity", "#");
                bundle.put("upload", "/portal/intranet/documents");
            }
            catch (MissingResourceException ex) {
                LOG.warn((Object)"##Missing Labels of GettingStarted Portlet");
            }
            this.parameters.putAll(bundle);
            this.parameters.put("progress", new Integer(this.progress));
            this.parameters.put("width", new Integer(Math.round(200 * this.progress / 100)).toString());
            this.parameters.put("status", this.status);
            this.parameters.put("show", Isshow.toString());
            if (isChange || "true".equals(reload)) {
                Response.Content content = this.gettingStartedList.ok((Map)this.parameters).withCharset(Tools.UTF_8);
                return content;
            }
        }
        return Response.ok();
    }

    private boolean updateAction(Property tempProp, Node gettingStartedNode) throws RepositoryException {
        boolean has = false;
        String gsPropertyName = tempProp.getName();
        has = this.checkStatus(gsPropertyName);
        if (has) {
            this.status.put(gsPropertyName.substring(4), "done");
            this.progress += 20;
        } else {
            this.status.put(gsPropertyName.substring(4), "");
        }
        if (has != tempProp.getBoolean()) {
            gettingStartedNode.setProperty(gsPropertyName, has);
            gettingStartedNode.save();
            return true;
        }
        return false;
    }

    private boolean checkStatus(String gsPropertyName) {
        if (gsPropertyName.equals("exo:gs_connect")) {
            return this.startService.hasContacts(this.remoteUser);
        }
        if (gsPropertyName.equals("exo:gs_activities")) {
            return this.startService.hasActivities(this.remoteUser);
        }
        if (gsPropertyName.equals("exo:gs_document")) {
            return this.startService.hasDocuments(null, this.remoteUser);
        }
        if (gsPropertyName.equals("exo:gs_space")) {
            return this.startService.hasSpaces(this.remoteUser);
        }
        return this.startService.hasAvatar(this.remoteUser);
    }
}

