/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.platform.component.UINotificationPopoverToolbarPortlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.json.JSONObject;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/platformNavigation/portlet/UINotificationPopoverToolbarPortlet/UINotificationPopoverToolbarPortlet.gtmpl", events={@EventConfig(listeners={MarkReadActionListener.class}), @EventConfig(listeners={RemovePopoverActionListener.class}), @EventConfig(listeners={ResetNumberOnBadgeActionListener.class})})
public class UINotificationPopoverToolbarPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UINotificationPopoverToolbarPortlet.class);
    private static final String EXO_NOTIFICATION_MARK_ALL_READ = "exo.notification.all.markRead";
    private static final String EXO_NOTIFICATION_POPOVER_LIST = "exo.notification.popover.list";
    private static final String CLUSTER_NOTIFICATION_POPOVER_LIST = "cluster.notification.popover.list";
    private final WebNotificationService webNftService = (WebNotificationService)this.getApplicationComponent(WebNotificationService.class);
    private final UserSettingService userSettingService = (UserSettingService)this.getApplicationComponent(UserSettingService.class);
    private final ContinuationService continuation = (ContinuationService)this.getApplicationComponent(ContinuationService.class);
    private final EXoContinuationBayeux bayeux = (EXoContinuationBayeux)this.getApplicationComponent(EXoContinuationBayeux.class);
    private int maxItemsInPopover;
    private String currentUser = "";

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        this.currentUser = context.getRemoteUser();
        String currentUserId = this.getCurrentUserId();
        if (this.currentUser != null && currentUserId != null) {
            this.maxItemsInPopover = NotificationMessageUtils.getMaxItemsInPopover();
            StringBuilder scripts = new StringBuilder("NotificationPopoverToolbarPortlet.initCometd('");
            scripts.append(this.currentUser).append("', '").append(this.getUserToken()).append("', '").append(this.getCometdContextName()).append("');");
            context.getJavascriptManager().getRequireJS().require("SHARED/jquery_cometd", "cometd").require("PORTLET/platformNavigation/NotificationPopoverToolbarPortlet", "NotificationPopoverToolbarPortlet").addScripts(scripts.toString());
            super.processRender(app, context);
        } else {
            this.currentUser = "";
            log.warn((Object)"Warning when execute the processRender() method for UINotificationPopoverToolbarPortlet class. The currentUserId or the currentUser is null");
        }
    }

    public void serveResource(WebuiRequestContext context) throws Exception {
        super.serveResource(context);
        this.currentUser = context.getRemoteUser();
        String currentUserId = this.getCurrentUserId();
        if (this.currentUser != null && currentUserId != null) {
            ResourceRequest req = (ResourceRequest)context.getRequest();
            String resourceId = req.getResourceID();
            if (EXO_NOTIFICATION_POPOVER_LIST.equals(resourceId)) {
                List notifications = this.getNotifications();
                StringBuffer sb = new StringBuffer();
                for (String notif : notifications) {
                    sb.append(notif);
                }
                MimeResponse res = (MimeResponse)context.getResponse();
                res.setContentType("application/json");
                JSONObject object = new JSONObject();
                object.put("notifications", (Object)sb.toString());
                object.put("showViewAll", this.hasNotifications());
                object.put("inlineImageLabel", (Object)context.getApplicationResourceBundle().getString("UINotificationPopoverToolbarPortlet.label.InlineImage"));
                res.getWriter().write(object.toString());
                return;
            }
            if (CLUSTER_NOTIFICATION_POPOVER_LIST.equals(resourceId)) {
                int badge = this.webNftService.getNumberOnBadge(this.currentUser);
                if (badge > 0) {
                    MimeResponse res = (MimeResponse)context.getResponse();
                    res.setContentType("application/json");
                    JSONObject object = new JSONObject();
                    object.put("badge", (Object)String.valueOf(badge));
                    res.getWriter().write(object.toString());
                }
            } else if (EXO_NOTIFICATION_MARK_ALL_READ.equals(resourceId)) {
                this.webNftService.markAllRead(this.currentUser);
                this.webNftService.resetNumberOnBadge(this.currentUser);
            }
        } else {
            this.currentUser = "";
            log.warn((Object)"Warning when execute the serveResource() method for UINotificationPopoverToolbarPortlet class. The currentUserId or the currentUser is null");
        }
    }

    private String getCurrentUserId() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }

    protected String buildResourceURL(String key) {
        try {
            WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            MimeResponse res = (MimeResponse)ctx.getResponse();
            ResourceURL rsURL = res.createResourceURL();
            rsURL.setResourceID(key);
            return rsURL.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    protected List<String> getNotifications() throws Exception {
        return this.webNftService == null ? new ArrayList<String>() : this.webNftService.get(new WebNotificationFilter(this.currentUser, true), 0, this.maxItemsInPopover);
    }

    protected List<String> getActions() {
        return Arrays.asList("MarkRead", "RemovePopover", "ResetNumberOnBadge");
    }

    protected String getActionUrl(String actionName) throws Exception {
        return this.event(actionName).replace("javascript:ajaxGet('", "").replace("')", "&objectId=");
    }

    protected boolean isWebActive() {
        return this.userSettingService == null ? false : this.userSettingService.get(this.currentUser).isChannelActive("WEB_CHANNEL");
    }

    protected String getCometdContextName() {
        return this.bayeux == null ? "cometd" : this.bayeux.getCometdContextName();
    }

    protected int getNumberOfMessage() {
        return this.webNftService == null ? 0 : this.webNftService.getNumberOnBadge(this.currentUser);
    }

    protected boolean hasNotifications() throws Exception {
        if (this.getNotifications().size() > 0) {
            return true;
        }
        return this.webNftService == null ? false : this.webNftService.get(new WebNotificationFilter(this.currentUser), 0, 1).size() > 0;
    }

    public String getUserToken() {
        try {
            return this.continuation.getUserToken(this.currentUser);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not retrieve continuation token for user " + this.currentUser), (Throwable)e);
            return "";
        }
    }

    static /* synthetic */ WebNotificationService access$000(UINotificationPopoverToolbarPortlet x0) {
        return x0.webNftService;
    }

    static /* synthetic */ String access$100(UINotificationPopoverToolbarPortlet x0) {
        return x0.currentUser;
    }
}

