/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component;

import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.NavigationUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static Log LOG = ExoLogger.getLogger(Utils.class);
    public static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";

    private Utils() {
    }

    public static UserNavigation getSelectedNavigation() throws Exception {
        SiteKey siteKey = Util.getUIPortal().getSiteKey();
        return NavigationUtils.getUserNavigation((UserPortal)Util.getPortalRequestContext().getUserPortalConfig().getUserPortal(), (SiteKey)siteKey);
    }

    public static void createPopupWindow(UIContainer container, UIComponent component, String popupWindowId, int width) throws Exception {
        UIPopupContainer popupContainer = Utils.initPopup((UIContainer)container, (UIComponent)component, (String)popupWindowId, (int)width);
        WebuiRequestContext requestContext = (WebuiRequestContext)RequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    private static UIPopupContainer initPopup(UIContainer container, UIComponent component, String popupWindowId, int width) throws Exception {
        UIPopupContainer popupContainer = Utils.getPopupContainer((UIContainer)container);
        popupContainer.removeChildById(popupWindowId);
        popupContainer.removeChildById("UIPopupWindow");
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.addChild(UIPopupWindow.class, null, popupWindowId);
        popupWindow.setUIComponent(component);
        popupWindow.setWindowSize(width, 0);
        popupWindow.setShow(true);
        popupWindow.setRendered(true);
        popupWindow.setResizable(true);
        popupWindow.setShowMask(true);
        return popupContainer;
    }

    private static UIPopupContainer getPopupContainer(UIContainer container) {
        if (container instanceof UIPortletApplication) {
            return (UIPopupContainer)container.getChild(UIPopupContainer.class);
        }
        UIPortletApplication portletApplication = (UIPortletApplication)container.getAncestorOfType(UIPortletApplication.class);
        return (UIPopupContainer)portletApplication.getChild(UIPopupContainer.class);
    }

    public static boolean hasEditPermissionOnNavigation() throws Exception {
        UserNavigation selectedNavigation = Utils.getSelectedNavigation();
        if (selectedNavigation == null) {
            return false;
        }
        return selectedNavigation.isModifiable();
    }

    public static boolean hasEditPermissionOnPortal() throws Exception {
        UIPortal currentUIPortal = Util.getUIPortal();
        UserACL userACL = (UserACL)currentUIPortal.getApplicationComponent(UserACL.class);
        return userACL.hasEditPermissionOnPortal(currentUIPortal.getSiteKey().getTypeName(), currentUIPortal.getSiteKey().getName(), currentUIPortal.getEditPermission());
    }

    public static boolean hasEditPermissionOnPage() throws Exception {
        try {
            UIPortalApplication portalApp = Util.getUIPortalApplication();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApp.getChildById("UIWorkingWorkspace");
            UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
            if (pageBody == null) {
                return false;
            }
            UIPage uiPage = (UIPage)pageBody.getUIComponent();
            UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
            if (uiPage != null) {
                return userACL.hasEditPermissionOnPage(uiPage.getOwnerType(), uiPage.getOwnerId(), uiPage.getEditPermission());
            }
            UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
            UserNode currentNode = currentUIPortal.getSelectedUserNode();
            PageKey pageReference = currentNode.getPageRef();
            if (pageReference == null) {
                return false;
            }
            UserPortalConfigService portalConfigService = (UserPortalConfigService)portalApp.getApplicationComponent(UserPortalConfigService.class);
            PageContext page = portalConfigService.getPage(pageReference);
            if (page == null) {
                return false;
            }
            return userACL.hasEditPermission(page);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while retrieving permission of used on current page", (Throwable)e);
            return false;
        }
    }
}

