/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory.jpa.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity
@ExoEntity
@Table(name="LOGIN_HISTORY")
@NamedQueries(value={@NamedQuery(name="loginHistory.getLastLoginHistory", query="SELECT l FROM LoginHistoryEntity l ORDER BY l.loginDate DESC"), @NamedQuery(name="loginHistory.getAllLoggedUsers", query="SELECT l.userId FROM LoginHistoryEntity l ORDER BY l.loginDate DESC"), @NamedQuery(name="loginHistory.getLastLoginsOfUser", query="SELECT l FROM LoginHistoryEntity l WHERE l.userId = :userId ORDER BY l.loginDate DESC"), @NamedQuery(name="loginHistory.getBeforeLastLoginID", query="SELECT MAX(l.id) FROM LoginHistoryEntity l WHERE l.userId = :userId AND l.loginDate < :lastLoginDate"), @NamedQuery(name="loginHistory.getLastLoginsInDateRange", query="SELECT l FROM LoginHistoryEntity l WHERE l.loginDate BETWEEN :from AND :to"), @NamedQuery(name="loginHistory.getLastLoginsOfUserInDateRange", query="SELECT l FROM LoginHistoryEntity l WHERE l.userId = :userId AND l.loginDate BETWEEN :from AND :to"), @NamedQuery(name="loginHistory.getLoginsCountInDateRange", query="SELECT COUNT (l) FROM LoginHistoryEntity l WHERE l.loginDate BETWEEN :from AND :to"), @NamedQuery(name="loginHistory.getLoginsCountOfUserInDateRange", query="SELECT COUNT (l) FROM LoginHistoryEntity l WHERE l.userId = :userId AND l.loginDate BETWEEN :from AND :to"), @NamedQuery(name="loginHistory.getLastLoginsAfterDate", query="SELECT l.userId FROM LoginHistoryEntity l WHERE l.loginDate >= :from ORDER BY l.loginDate DESC"), @NamedQuery(name="loginHistory.getActiveUsersId", query="SELECT DISTINCT l.userId FROM LoginHistoryEntity l WHERE l.loginDate >= :from")})
public class LoginHistoryEntity {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private long id;
    @Column(name="USER_ID")
    private String userId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LOGIN_DATE")
    private Date loginDate;

    public LoginHistoryEntity() {
    }

    public LoginHistoryEntity(String userID) {
        this.userId = userID;
    }

    public LoginHistoryEntity(String userId, Date loginDate) {
        this.userId = userId;
        this.loginDate = loginDate;
    }

    public long getID() {
        return this.id;
    }

    public String getUserID() {
        return this.userId;
    }

    public void setUserID(String userID) {
        this.userId = userID;
    }

    public Date getLoginDate() {
        return this.loginDate;
    }

    public void setLoginDate(Date loginDate) {
        this.loginDate = loginDate;
    }
}

