/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest.services.GettingStarted;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="homepage/intranet/getting-started/")
@Produces(value={"application/json"})
public class GettingStartedRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(GettingStartedRestService.class);
    private static final CacheControl cacheControl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="get")
    public Response get(@Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try (SessionProvider sProvider = null;){
            Node gettingStartedNode;
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            if (userId == null) {
                Response response = Response.status((int)500).cacheControl(cacheControl).build();
                return response;
            }
            NodeHierarchyCreator nodeCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            Node userPrivateNode = nodeCreator.getUserNode(sProvider = SessionProvider.createSystemProvider(), userId).getNode("ApplicationData");
            if (!userPrivateNode.hasNode("GsGadget")) {
                gettingStartedNode = userPrivateNode.addNode("GsGadget");
                userPrivateNode.save();
                gettingStartedNode.setProperty("exo:gs_deleteGadget", false);
                gettingStartedNode.setProperty("exo:gs_profile", false);
                gettingStartedNode.setProperty("exo:gs_connect", false);
                gettingStartedNode.setProperty("exo:gs_space", false);
                gettingStartedNode.setProperty("exo:gs_activities", false);
                gettingStartedNode.setProperty("exo:gs_document", false);
                gettingStartedNode.save();
            }
            gettingStartedNode = userPrivateNode.getNode("GsGadget");
            gettingStartedNode.setProperty("exo:gs_profile", this.hasAvatar(userId));
            gettingStartedNode.setProperty("exo:gs_connect", this.hasContacts(userId));
            gettingStartedNode.setProperty("exo:gs_space", this.hasSpaces(userId));
            gettingStartedNode.setProperty("exo:gs_activities", this.hasActivities(userId));
            gettingStartedNode.setProperty("exo:gs_document", this.hasDocuments(userId).booleanValue());
            PropertyIterator propertiesIt = userPrivateNode.getNode("GsGadget").getProperties("exo:gs_*");
            JSONArray jsonArray = new JSONArray();
            while (propertiesIt.hasNext()) {
                Property prop = (Property)propertiesIt.next();
                JSONObject json = new JSONObject();
                json.put("name", (Object)prop.getName());
                json.put("value", (Object)prop.getString());
                jsonArray.put((Object)json);
            }
            Response response = Response.ok((Object)jsonArray.toString(), (String)"application/json").cacheControl(cacheControl).build();
            return response;
        }
    }

    private Boolean hasDocuments(String userId) {
        return true;
    }

    private boolean hasAvatar(String userId) {
        try {
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", userId);
            Profile profile = identity.getProfile();
            return profile.getAvatarUrl() != null;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in gettingStarted REST service: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean hasSpaces(String userId) {
        try {
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            Space[] spaces = (Space[])spaceService.getAccessibleSpacesWithListAccess(userId).load(0, 1);
            return spaces != null && spaces.length > 0;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in gettingStarted REST service: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean hasActivities(String userId) {
        try {
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", userId);
            ActivityManager activityService = (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
            RealtimeListAccess activities = activityService.getActivitiesWithListAccess(identity);
            if (activities.getSize() != 0) {
                if (this.hasAvatar(userId) && this.hasContacts(userId) && this.hasSpaces(userId) && activities.getSize() >= 5) {
                    return true;
                }
                if (this.hasAvatar(userId) && this.hasContacts(userId) && !this.hasSpaces(userId) && activities.getSize() >= 4) {
                    return true;
                }
                if (this.hasAvatar(userId) && !this.hasContacts(userId) && this.hasSpaces(userId) && activities.getSize() >= 3) {
                    return true;
                }
                if (!this.hasAvatar(userId) && this.hasContacts(userId) && this.hasSpaces(userId) && activities.getSize() >= 4) {
                    return true;
                }
                if (!this.hasAvatar(userId) && !this.hasContacts(userId) && this.hasSpaces(userId) && activities.getSize() >= 2) {
                    return true;
                }
                return !this.hasAvatar(userId) && !this.hasContacts(userId) && !this.hasSpaces(userId) && activities.getSize() >= 1;
            }
            return false;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in gettingStarted REST service: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private boolean hasContacts(String userId) {
        try {
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            RelationshipManager relationshipManager = (RelationshipManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationshipManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", userId);
            ListAccess confirmedContacts = relationshipManager.getConnections(identity);
            return confirmedContacts.getSize() > 0;
        }
        catch (Exception e) {
            LOG.debug((Object)("Error in gettingStarted REST service: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }
}

