/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.mailintegration.model.MailIntegrationSetting;
import org.exoplatform.mailintegration.rest.model.MailIntegrationSettingRestEntity;
import org.exoplatform.mailintegration.rest.model.MessageRestEntity;
import org.exoplatform.mailintegration.service.MailIntegrationService;
import org.exoplatform.mailintegration.utils.MailIntegrationUtils;
import org.exoplatform.mailintegration.utils.RestEntityBuilder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/v1/mailIntegration")
@Api(value="/v1/mailIntegration", description="Managing mail Integration")
public class MailIntegrationRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(MailIntegrationRest.class);
    MailIntegrationService mailIntegrationService;
    private IdentityManager identityManager;

    public MailIntegrationRest(MailIntegrationService mailIntegrationService, IdentityManager identityManager) {
        this.mailIntegrationService = mailIntegrationService;
        this.identityManager = identityManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a mail integration setting", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response createMailIntegrationSetting(@ApiParam(value="Mail integration setting object to create", required=true) MailIntegrationSettingRestEntity mailIntegrationSettingEntity) {
        if (mailIntegrationSettingEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        long userIdentityId = MailIntegrationUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            MailIntegrationSetting mailIntegrationSetting = RestEntityBuilder.toMailIntegrationSetting(mailIntegrationSettingEntity, userIdentityId);
            MailIntegrationSetting createdMailIntegrationSetting = this.mailIntegrationService.createMailIntegrationSetting(mailIntegrationSetting);
            return Response.ok((Object)createdMailIntegrationSetting).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating mail integration setting ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="mailIntegrationSettings")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get mail integration settings", httpMethod="GET", response=Response.class, notes="This gets the mail integration settings of the authenticated user")
    @ApiResponses(value={@ApiResponse(code=500, message="Internal server error")})
    public Response getMailIntegrationSettings() {
        long userIdentityId = MailIntegrationUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            List mailIntegrationSettings = this.mailIntegrationService.getMailIntegrationSettingsByUserId(userIdentityId);
            List mailIntegrationSettigRestEntities = mailIntegrationSettings.stream().map(RestEntityBuilder::fromMailIntegrationSetting).collect(Collectors.toList());
            return Response.ok(mailIntegrationSettigRestEntities).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting mail integration settings ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete mail integration setting", httpMethod="DELETE", response=Response.class, notes="This deletes the mail integration setting of the authenticated user by its id")
    @ApiResponses(value={@ApiResponse(code=404, message="Mail Integration Setting not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteMailIntegrationSetting(@ApiParam(value="Mail Integration Setting id", required=true) @PathParam(value="id") String mailIntegrationSettingId) {
        String currentUser = MailIntegrationUtils.getCurrentUser();
        try {
            MailIntegrationSetting mailIntegrationSetting = this.mailIntegrationService.getMailIntegrationSetting(Long.parseLong(mailIntegrationSettingId));
            if (mailIntegrationSetting == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            long currentUserIdentityId = MailIntegrationUtils.getCurrentUserIdentityId(this.identityManager);
            this.mailIntegrationService.deleteMailIntegrationSetting(Long.parseLong(mailIntegrationSettingId), currentUserIdentityId);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to delete mail integration setting", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the mail integration setting with id " + mailIntegrationSettingId), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="connect")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Check mail integration connection", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response connect(@ApiParam(value="Connection information object to create", required=true) MailIntegrationSettingRestEntity mailIntegrationSettingRestEntity) {
        if (mailIntegrationSettingRestEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        long userIdentityId = MailIntegrationUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            MailIntegrationSetting mailIntegrationSetting = RestEntityBuilder.toMailIntegrationSetting(mailIntegrationSettingRestEntity, userIdentityId);
            Store store = this.mailIntegrationService.connect(mailIntegrationSetting);
            store.close();
            return Response.ok().build();
        }
        catch (MessagingException messagingException) {
            LOG.error((Object)"Error when checking mail connection ", (Throwable)messagingException);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/{mailntegrationSettingId}/message/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a message", httpMethod="GET", response=Response.class, notes="This gets the message with the given id")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Message not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getMessageById(@ApiParam(value="Message id", required=true) @PathParam(value="id") String messageId, @ApiParam(value="Message integration setting id", required=true) @PathParam(value="mailntegrationSettingId") long mailIntegrationSettingId) {
        String currentUser = MailIntegrationUtils.getCurrentUser();
        try {
            if (StringUtils.isBlank((String)messageId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            long currentUserIdentityId = MailIntegrationUtils.getCurrentUserIdentityId(this.identityManager);
            MessageRestEntity message = this.mailIntegrationService.getMessageById(mailIntegrationSettingId, messageId, currentUserIdentityId);
            if (message == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)message).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to get a non authorized message", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when getting message ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update an existing mail integration setting", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateMailIntegrationSetting(@ApiParam(value="Mail integration setting object to update", required=true) MailIntegrationSettingRestEntity mailIntegrationSettingEntity) {
        String currentUser = MailIntegrationUtils.getCurrentUser();
        if (mailIntegrationSettingEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        long userIdentityId = MailIntegrationUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            MailIntegrationSetting mailIntegrationSetting = RestEntityBuilder.toMailIntegrationSetting(mailIntegrationSettingEntity, userIdentityId);
            MailIntegrationSetting updatedMailIntegrationSetting = this.mailIntegrationService.updateMailIntegrationSetting(mailIntegrationSetting, userIdentityId);
            return Response.ok((Object)updatedMailIntegrationSetting).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not authorized to update mail integration setting", new Object[]{currentUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating mail integration setting ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

