/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.storage;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.mailintegration.dao.MailIntegrationDAO;
import org.exoplatform.mailintegration.entity.MailIntegrationSettingEntity;
import org.exoplatform.mailintegration.model.MailIntegrationSetting;
import org.exoplatform.mailintegration.storage.MailIntegrationStorage;
import org.exoplatform.mailintegration.utils.EntityMapper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MailIntegrationStorageTest {
    private static final MockedStatic<EntityMapper> ENTITY_MAPPER = Mockito.mockStatic(EntityMapper.class);
    private MailIntegrationStorage mailIntegrationStorage;
    private MailIntegrationDAO mailIntegrationDAO;

    @Before
    public void setUp() throws Exception {
        this.mailIntegrationDAO = (MailIntegrationDAO)Mockito.mock(MailIntegrationDAO.class);
        this.mailIntegrationStorage = new MailIntegrationStorage(this.mailIntegrationDAO);
    }

    @AfterClass
    public static void afterRunBare() throws Exception {
        ENTITY_MAPPER.close();
    }

    @Test
    public void testCreateMailIntegrationSetting() throws Exception {
        MailIntegrationSetting mailIntegrationSetting = this.createMailIntegrationSetting();
        MailIntegrationSettingEntity mailIntegrationSettingEntity = this.createMailIntegrationSettingEntity();
        Mockito.when((Object)((MailIntegrationSettingEntity)this.mailIntegrationDAO.create((Object)((MailIntegrationSettingEntity)Mockito.any())))).thenReturn((Object)mailIntegrationSettingEntity);
        ENTITY_MAPPER.when(() -> EntityMapper.toMailIntegrationSettingEntity((MailIntegrationSetting)mailIntegrationSetting)).thenAnswer(invocation -> mailIntegrationSettingEntity);
        ENTITY_MAPPER.when(() -> EntityMapper.fromMailIntegrationSettingEntity((MailIntegrationSettingEntity)mailIntegrationSettingEntity)).thenAnswer(invocation -> mailIntegrationSetting);
        MailIntegrationSetting createdMailIntegrationSetting = this.mailIntegrationStorage.createMailIntegrationSetting(mailIntegrationSetting);
        Assert.assertNotNull((Object)createdMailIntegrationSetting);
        Assert.assertEquals((long)1L, (long)createdMailIntegrationSetting.getId());
    }

    @Test
    public void testGetMailIntegrationSettingsByUserId() throws Exception {
        MailIntegrationSettingEntity mailIntegrationSettingEntity = this.createMailIntegrationSettingEntity();
        ArrayList<MailIntegrationSettingEntity> mailIntegrationSettingEntities = new ArrayList<MailIntegrationSettingEntity>();
        mailIntegrationSettingEntities.add(mailIntegrationSettingEntity);
        Mockito.when((Object)this.mailIntegrationDAO.findMailIntegrationSettingsByUserId(1L)).thenReturn(mailIntegrationSettingEntities);
        List retrievedMailIntegrationSettings = this.mailIntegrationStorage.getMailIntegrationSettingsByUserId(1L);
        Assert.assertNotNull((Object)retrievedMailIntegrationSettings);
        Assert.assertEquals((long)mailIntegrationSettingEntities.size(), (long)retrievedMailIntegrationSettings.size());
    }

    @Test
    public void testGetMailIntegrationSettings() throws Exception {
        MailIntegrationSettingEntity mailIntegrationSettingEntity = this.createMailIntegrationSettingEntity();
        ArrayList<MailIntegrationSettingEntity> mailIntegrationSettingEntities = new ArrayList<MailIntegrationSettingEntity>();
        mailIntegrationSettingEntities.add(mailIntegrationSettingEntity);
        Mockito.when((Object)this.mailIntegrationDAO.findAll()).thenReturn(mailIntegrationSettingEntities);
        List retrievedMailIntegrationSettings = this.mailIntegrationStorage.getMailIntegrationSettings();
        Assert.assertNotNull((Object)retrievedMailIntegrationSettings);
        Assert.assertEquals((long)mailIntegrationSettingEntities.size(), (long)retrievedMailIntegrationSettings.size());
    }

    @Test
    public void testUpdateMailIntegrationSetting() throws Exception {
        MailIntegrationSetting mailIntegrationSetting = this.createMailIntegrationSetting();
        MailIntegrationSettingEntity mailIntegrationSettingEntity = this.createMailIntegrationSettingEntity();
        Mockito.when((Object)((MailIntegrationSettingEntity)this.mailIntegrationDAO.create((Object)((MailIntegrationSettingEntity)Mockito.any())))).thenReturn((Object)mailIntegrationSettingEntity);
        ENTITY_MAPPER.when(() -> EntityMapper.toMailIntegrationSettingEntity((MailIntegrationSetting)mailIntegrationSetting)).thenAnswer(invocation -> mailIntegrationSettingEntity);
        ENTITY_MAPPER.when(() -> EntityMapper.fromMailIntegrationSettingEntity((MailIntegrationSettingEntity)mailIntegrationSettingEntity)).thenAnswer(invocation -> mailIntegrationSetting);
        MailIntegrationSetting createdMailIntegrationSetting = this.mailIntegrationStorage.createMailIntegrationSetting(mailIntegrationSetting);
        createdMailIntegrationSetting.setAccount("updatedAccount");
        createdMailIntegrationSetting.setEmailName("useraUpdatedMail@exo.tn");
        MailIntegrationSetting updatedMailIntegrationSetting = this.mailIntegrationStorage.updateMailIntegrationSetting(mailIntegrationSetting);
        Assert.assertNotNull((Object)updatedMailIntegrationSetting);
        Assert.assertEquals((long)1L, (long)updatedMailIntegrationSetting.getId());
        Assert.assertEquals((Object)"updatedAccount", (Object)updatedMailIntegrationSetting.getAccount());
        Assert.assertEquals((Object)"useraUpdatedMail@exo.tn", (Object)updatedMailIntegrationSetting.getEmailName());
    }

    protected MailIntegrationSetting createMailIntegrationSetting() {
        MailIntegrationSetting mailIntegrationSetting = new MailIntegrationSetting();
        mailIntegrationSetting.setId(1L);
        mailIntegrationSetting.setEmailName("emailName");
        mailIntegrationSetting.setImapUrl("imapUrl");
        mailIntegrationSetting.setPort(123L);
        mailIntegrationSetting.setEncryption("encryption");
        mailIntegrationSetting.setAccount("account");
        mailIntegrationSetting.setPassword("password");
        mailIntegrationSetting.setUserId(1L);
        return mailIntegrationSetting;
    }

    protected MailIntegrationSettingEntity createMailIntegrationSettingEntity() {
        MailIntegrationSettingEntity mailIntegrationSettingEntity = new MailIntegrationSettingEntity();
        mailIntegrationSettingEntity.setId(Long.valueOf(1L));
        mailIntegrationSettingEntity.setEmailName("emailName");
        mailIntegrationSettingEntity.setImapUrl("imapUrl");
        mailIntegrationSettingEntity.setPort(123L);
        mailIntegrationSettingEntity.setEncryption("encryption");
        mailIntegrationSettingEntity.setAccount("account");
        mailIntegrationSettingEntity.setPassword("password");
        mailIntegrationSettingEntity.setUserId(1L);
        return (MailIntegrationSettingEntity)this.mailIntegrationDAO.create((Object)mailIntegrationSettingEntity);
    }
}

