/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixUserListener
extends UserEventListener {
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private SpaceService spaceService;

    @PostConstruct
    public void init() {
        this.organizationService.getUserHandler().addUserEventListener((UserEventListener)this);
    }

    public void postSave(User user, boolean isNew) throws Exception {
        String matrixRestrictedGroup = PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId");
        if (StringUtils.isNotBlank((CharSequence)matrixRestrictedGroup) && !this.matrixService.isUserMemberOfGroup(user.getUserName(), matrixRestrictedGroup)) {
            return;
        }
        this.matrixService.saveUserAccount(user, isNew, false);
    }

    public void postSetEnabled(User user) throws Exception {
        Profile userProfile;
        String matrixUserId;
        if (this.identityManager != null && StringUtils.isNotBlank((CharSequence)(matrixUserId = (String)(userProfile = this.identityManager.getProfile(this.identityManager.getOrCreateUserIdentity(user.getUserName()))).getProperty("matrixId")))) {
            if (!user.isEnabled()) {
                String matrixUsername = "@" + user.getUserName() + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
                this.matrixService.disableAccount(matrixUsername);
            } else {
                Space[] spacesArray;
                this.matrixService.saveUserAccount(user, false, true);
                ListAccess spaces = this.spaceService.getMemberSpaces(user.getUserName());
                for (Space space : spacesArray = (Space[])spaces.load(0, spaces.getSize())) {
                    String roomId = this.matrixService.getRoomBySpace(space);
                    if (!StringUtils.isNotBlank((CharSequence)roomId)) continue;
                    this.matrixService.joinUserToRoom(roomId, matrixUserId);
                }
            }
        }
    }
}

