/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.storage;

import io.meeds.chat.dao.MatrixRoomDAO;
import io.meeds.chat.entity.RoomEntity;
import io.meeds.chat.model.DirectMessagingRoom;
import io.meeds.chat.model.Room;
import io.meeds.chat.model.SpaceRoom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixRoomStorage {
    private static final Log LOG = ExoLogger.getLogger(MatrixRoomStorage.class);
    @Autowired
    private MatrixRoomDAO matrixRoomDAO;
    @Autowired
    private SpaceService spaceService;

    public String getMatrixRoomBySpaceId(String spaceId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findBySpaceId(spaceId);
        if (roomEntity != null) {
            return roomEntity.getRoomId();
        }
        LOG.warn("Can not find an associated matrix room for the space with ID {}", new Object[]{spaceId});
        return null;
    }

    public Space getSpaceIdByMatrixRoomId(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomId(roomId);
        if (roomEntity != null && StringUtils.isNotBlank((CharSequence)roomEntity.getSpaceId())) {
            return this.spaceService.getSpaceById(String.valueOf(roomEntity.getSpaceId()));
        }
        LOG.warn("Can not find an associated space for the matrix room with ID {}", new Object[]{roomId});
        return null;
    }

    public DirectMessagingRoom getDMRoomByRoomId(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomId(roomId);
        if (roomEntity != null && StringUtils.isNotBlank((CharSequence)roomEntity.getFirstParticipant()) && StringUtils.isNotBlank((CharSequence)roomEntity.getSecondParticipant())) {
            return this.toDirectMessagingRoomModel(roomEntity);
        }
        LOG.warn("Can not find an associated space for the matrix room with ID {}", new Object[]{roomId});
        return null;
    }

    public SpaceRoom saveRoomForSpace(String spaceId, String roomId) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setSpaceId(spaceId);
        roomEntity.setRoomId(roomId);
        return MatrixRoomStorage.toSpaceRoomModel((RoomEntity)this.matrixRoomDAO.save(roomEntity));
    }

    public DirectMessagingRoom saveDirectMessagingRoom(String firstParticipantId, String secondParticipantId, String roomId) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setRoomId(roomId);
        roomEntity.setFirstParticipant(firstParticipantId);
        roomEntity.setSecondParticipant(secondParticipantId);
        return this.toDirectMessagingRoomModel((RoomEntity)this.matrixRoomDAO.save(roomEntity));
    }

    private DirectMessagingRoom toDirectMessagingRoomModel(RoomEntity room) {
        DirectMessagingRoom directMessagingRoom = new DirectMessagingRoom();
        directMessagingRoom.setRoomId(room.getRoomId());
        directMessagingRoom.setFirstParticipant(room.getFirstParticipant());
        directMessagingRoom.setSecondParticipant(room.getSecondParticipant());
        return directMessagingRoom;
    }

    private static SpaceRoom toSpaceRoomModel(RoomEntity roomEntity) {
        SpaceRoom spaceRoomModel = new SpaceRoom();
        spaceRoomModel.setSpaceId(roomEntity.getSpaceId());
        spaceRoomModel.setRoomId(roomEntity.getRoomId());
        return spaceRoomModel;
    }

    private static List<SpaceRoom> toSpaceRoomList(List<RoomEntity> roomEntities) {
        ArrayList<SpaceRoom> spaceRooms = new ArrayList<SpaceRoom>();
        for (RoomEntity roomEntity : roomEntities) {
            spaceRooms.add(MatrixRoomStorage.toSpaceRoomModel(roomEntity));
        }
        return spaceRooms;
    }

    public long getSpaceRoomCount() {
        return this.matrixRoomDAO.count();
    }

    public DirectMessagingRoom getDirectMessagingRoom(String firstParticipantId, String secondParticipantId) {
        RoomEntity directMessagingRoom = this.matrixRoomDAO.findByFirstParticipantAndSecondParticipant(firstParticipantId, secondParticipantId);
        if (directMessagingRoom != null) {
            return this.toDirectMessagingRoomModel(directMessagingRoom);
        }
        return null;
    }

    public List<DirectMessagingRoom> getMatrixDMRoomsOfUser(String user) {
        return this.toDirectMessagingRoomModelList(this.matrixRoomDAO.findByFirstParticipantOrSecondParticipant(user, user));
    }

    private List<DirectMessagingRoom> toDirectMessagingRoomModelList(List<RoomEntity> roomEntities) {
        return roomEntities.stream().map(roomEntity -> this.toDirectMessagingRoomModel((RoomEntity)roomEntity)).toList();
    }

    public void removeMatrixRoom(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomId(roomId);
        this.matrixRoomDAO.delete(roomEntity);
    }

    public Room getById(String roomId) {
        RoomEntity roomEntity = this.matrixRoomDAO.findByRoomIdStartsWith(roomId);
        if (roomEntity != null) {
            return this.toRoomModel(roomEntity);
        }
        return null;
    }

    private Room toRoomModel(RoomEntity roomEntity) {
        Room room = new Room();
        room.setId(roomEntity.getId());
        room.setRoomId(roomEntity.getRoomId());
        room.setSpaceId(roomEntity.getSpaceId());
        room.setFirstParticipant(roomEntity.getFirstParticipant());
        room.setSecondParticipant(roomEntity.getSecondParticipant());
        return room;
    }

    public List<SpaceRoom> getSpaceRooms() {
        return MatrixRoomStorage.toSpaceRoomList(this.matrixRoomDAO.findBySpaceIdIsNotNull());
    }
}

