/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.chat.rest.MatrixRest;
import io.meeds.chat.rest.model.Member;
import io.meeds.chat.rest.model.Message;
import io.meeds.chat.rest.model.Presence;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.MatrixService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={MatrixRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
class MatrixRestTest {
    private static final String SIMPLE_USER = "user";
    private static final String TEST_PASSWORD = "testPassword";
    private static final String REST_PATH = "/matrix";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private SpaceService spaceService;
    @MockBean
    private MatrixService matrixService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private NotificationService notificationService;
    private MockMvc mockMvc;

    MatrixRestTest() {
    }

    @BeforeEach
    public void setUp() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void testProcessRooms() throws Exception {
        RoomList roomsList = this.createRoomsList(3);
        Mockito.when((Object)this.matrixService.processRooms((RoomList)ArgumentMatchers.any(RoomList.class), ArgumentMatchers.anyString())).thenReturn((Object)roomsList);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/processRooms", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(roomsList)));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private RoomList createRoomsList(int numberOfRooms) {
        ArrayList<RoomEntity> rooms = new ArrayList<RoomEntity>();
        for (int i = 0; i < numberOfRooms; ++i) {
            rooms.add(this.createRoomEntity(i));
        }
        RoomList roomList = new RoomList();
        roomList.setTotalUnreadMessages(20L);
        roomList.setRooms(rooms);
        return roomList;
    }

    private RoomEntity createRoomEntity(int index) {
        RoomEntity room = new RoomEntity();
        room.setId(String.valueOf(index));
        room.setAvatarUrl("/avatar/" + index);
        room.setName("Chat number " + index);
        Member root = new Member("1", "root", "/user/avatar1", System.currentTimeMillis());
        Member user = new Member("2", "root", "/user/avatar2", System.currentTimeMillis());
        room.setMembers(Arrays.asList(user, root));
        room.setUnreadMessages((long)index);
        room.setPresence("online");
        room.setTopic("No topic");
        room.setUpdated(System.currentTimeMillis());
        Message message = new Message("This is a new message", "@user:server.matrix.com");
        room.setLastMessage(message);
        return room;
    }

    private RequestPostProcessor simpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    @Test
    void updatePresenceStatus() throws Exception {
        Presence presence = new Presence();
        presence.setPresence("online");
        presence.setStatusMessage("I am available");
        presence.setUserIdOnMatrix("@user:server.matrix.com");
        Mockito.when((Object)this.matrixService.updateUserPresence(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)presence.getPresence());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/matrix/setStatus", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(presence)));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("online"));
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

