/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.upgrade;

import io.meeds.chat.service.MatrixService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class MatrixRoomAndAccountsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(MatrixRoomAndAccountsUpgradePlugin.class);
    private SpaceService spaceService;
    private MatrixService matrixService;
    private IdentityManager identityManager;
    private OrganizationService organizationService;
    private int SPACES_THRESHOLD = 20;
    private int LOADED_USERS_COUNT = 50;

    public MatrixRoomAndAccountsUpgradePlugin(InitParams initParams, SpaceService spaceService, MatrixService matrixService, OrganizationService organizationService, IdentityManager identityManager) {
        super(initParams);
        this.spaceService = spaceService;
        this.matrixService = matrixService;
        this.identityManager = identityManager;
        this.organizationService = organizationService;
    }

    public void processUpgrade(String s, String s1) {
        this.synchronizeUsers();
        this.synchronizeSpaces();
    }

    private void synchronizeSpaces() {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start:: create Matrix rooms for spaces");
        int failedToMigrateSpaces = 0;
        int successfullyMigratedSpaces = 0;
        int spacesCount = 0;
        int ignoredSpaces = 0;
        ListAccess spaces = this.spaceService.getAllSpacesByFilter(new SpaceFilter());
        try {
            Space[] spacesToMigrate;
            spacesCount = spaces.getSize();
            for (int loadedSpaces = 0; loadedSpaces < spacesCount; loadedSpaces += spacesToMigrate.length) {
                int actualSpacesToLoadCount = loadedSpaces + this.SPACES_THRESHOLD < spacesCount ? this.SPACES_THRESHOLD : spacesCount - loadedSpaces;
                for (Space space : spacesToMigrate = (Space[])spaces.load(loadedSpaces, actualSpacesToLoadCount)) {
                    String roomId = this.matrixService.getRoomBySpace(space);
                    if (StringUtils.isBlank((CharSequence)roomId)) {
                        try {
                            roomId = this.matrixService.createRoom(space);
                            for (String member : space.getMembers()) {
                                Identity memberIdentity = this.identityManager.getOrCreateUserIdentity(member);
                                if (memberIdentity == null || !StringUtils.isNotBlank((CharSequence)((String)memberIdentity.getProfile().getProperty("matrixId")))) continue;
                                String matrixIdOfUser = (String)memberIdentity.getProfile().getProperty("matrixId");
                                this.matrixService.joinUserToRoom(roomId, matrixIdOfUser);
                            }
                            ++successfullyMigratedSpaces;
                        }
                        catch (Exception e) {
                            LOG.error("Could not create a room for space {}", new Object[]{space.getDisplayName(), e});
                            ++failedToMigrateSpaces;
                        }
                    } else {
                        ++ignoredSpaces;
                        LOG.debug("The space {} has already a room with Id {}", new Object[]{space.getDisplayName(), roomId});
                    }
                    if (!StringUtils.isNotBlank((CharSequence)roomId)) continue;
                    this.matrixService.updateRoomAvatar(space, roomId);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving spaces", e);
        }
        LOG.info("Summary :: create Matrix rooms for spaces, {} created rooms for {} spaces, {} ignored spaces, {} rooms failed to be created !", new Object[]{successfullyMigratedSpaces, spacesCount, ignoredSpaces, failedToMigrateSpaces});
        if (failedToMigrateSpaces > 0) {
            throw new RuntimeException("Some spaces were not upgraded!");
        }
        LOG.info("End:: create Matrix rooms for spaces in {}", new Object[]{System.currentTimeMillis() - startupTime});
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return this.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeUsers() {
        LOG.info((Object)"Start:: create Matrix accounts for users");
        long startupTime = System.currentTimeMillis();
        int checkedUsers = 0;
        int usersCount = 0;
        ListAccess users = null;
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            users = StringUtils.isNotBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId")) ? this.organizationService.getUserHandler().findUsersByGroupId(PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId")) : this.organizationService.getUserHandler().findAllUsers();
            usersCount = users.getSize();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking users", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
        if (usersCount == 0) {
            throw new IllegalStateException("No users to migrate, please check the value of the property matrix.restricted.users.groupId or remove it to select all users.");
        }
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            while (checkedUsers < usersCount) {
                User[] usersArray;
                int usersToCheck = usersCount > checkedUsers + this.LOADED_USERS_COUNT ? this.LOADED_USERS_COUNT : usersCount - checkedUsers;
                for (User user : usersArray = (User[])users.load(checkedUsers, usersToCheck)) {
                    Space[] spaceArray;
                    Identity userIdentity = this.identityManager.getOrCreateUserIdentity(user.getUserName());
                    Profile userProfile = userIdentity.getProfile();
                    String userMatrixId = (String)userProfile.getProperty("matrixId");
                    if (StringUtils.isBlank((CharSequence)userMatrixId)) {
                        userMatrixId = this.matrixService.saveUserAccount(user, true, false);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)userMatrixId)) continue;
                    this.matrixService.updateUserAvatar(userProfile, userMatrixId);
                    ListAccess userSpaces = this.spaceService.getMemberSpaces(user.getUserName());
                    for (Space space : spaceArray = (Space[])userSpaces.load(0, userSpaces.getSize())) {
                        String spaceRoomId = this.matrixService.getRoomBySpace(space);
                        if (!StringUtils.isNotBlank((CharSequence)spaceRoomId)) continue;
                        this.matrixService.joinUserToRoom(spaceRoomId, userMatrixId);
                    }
                }
                LOG.info("Checked Matrix account for {} of {} users", new Object[]{checkedUsers += usersArray.length, usersCount});
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating accounts for users on Matrix", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        LOG.info("Summary :: create Matrix accounts for {} users, {} users were checked with their Matrix accounts, {} accounts failed to be created !", new Object[]{checkedUsers, usersCount, usersCount - checkedUsers});
        if (usersCount - checkedUsers > 0) {
            throw new RuntimeException("Some user accounts were not synchronized with Matrix!");
        }
        LOG.info("End:: create Matrix accounts for users took {}", new Object[]{System.currentTimeMillis() - startupTime});
    }
}

