import MattermostChatButton from './components/chatButton.vue';
import MattermostChatPopoverButton from './components/chatPopover.vue';

const components = {
  'mattermost-chat-button': MattermostChatButton,
  'mattermost-chat-popover-button': MattermostChatPopoverButton,
};

for (const key in components) {
  Vue.component(key, components[key]);
}

const appId = 'mattermostChatButton';
const lang = window?.eXo?.env?.portal?.language || 'fr';
const i18NUrl = `${eXo.env.portal.context}/${eXo.env.portal.rest}/i18n/bundle/locale.portlet.mattermostChatButton-${lang}.json`;
exoi18n.loadLanguageAsync(lang, i18NUrl).then(i18n => {
  extensionRegistry.registerComponent('SpacePopover', 'space-popover-action', {
    id: 'mattermostChat',
    vueComponent: Vue.options.components['mattermost-chat-popover-button'],
    rank: 40,
  });
});

export function init(url) {
  exoi18n.loadLanguageAsync(lang, i18NUrl).then(i18n => {
    Vue.createApp({
      data: {
        url: url
      },
      template: `<mattermost-chat-button id="${appId}" />`,
      vuetify: Vue.prototype.vuetifyOptions,
      i18n
    },
    `#${appId}`, 'Mattermost chat button');
  });
}
