# eXo Mattermost addon
This addon integrates eXo platform with Mattermost to : 
 - replace eXo chat app with Mattermost teams
 - when a space is created on eXo , a new team is created on Mattermost and linked to that space
 - when a space is renamed, the mattermost display name is changed too


## Configuration
To connect eXo platform to Mattermost, some parameters are needed :

 - **exo.addon.mattermost.url** : the url of the mattermost server
 - **exo.addon.mattermost.userName** and **exo.addon.mattermost.password** : the credentials of a user able to create and edit a team and invite users to it
 - **exo.addon.mattermost.access.token** : if you want to use a [personal access token](https://docs.mattermost.com/configure/integrations-configuration-settings.html#enable-personal-access-tokens) instead of username/password. More information are provided in https://developers.mattermost.com/integrate/reference/personal-access-token/ 


## Link an existing space to an existing team
To link an existing space to an existing space, use this URL :
'''
http://EXO_SERVER/portal/rest/mattermost/linkSpaceToTeam?spaceName=SPACE_PRETTY_NAME&teamId=TEAM_ID&teamName=TEAM_NAME
'''
where :

 - SPACE_PRETTY_NAME : the pretty name of the space, we can get it from the space URL. When you are in a space, It is the string part after **:spaces:** and the next '/' character. Example : space URL is http://SERVER_DOMAIN/portal/g/:spaces:my_space_one/ then the space pretty name is **my_space_one**
 - TEAM_ID: the ID of the team on Mattermost, use this Call to get the full list of teams and get this parameter http://mattermost_server/api/v4/teams. For each team, you need to get the **id** attribute
 - TEAM_NAME: the name of the team on Mattermost, use this Call to get the full list of teams and get this parameter http://mattermost_server/api/v4/teams. For each team, you need to get the **name** attribute

## User invitation by email
Whenever a user creates or joins a space that is linked to a Mattermost team, an email invitation will be sent to him based on the email provided in his eXo user profile.
To benefit from this functionality, the adinistrators should enable inviting users by email on Mattermost following those steps :
 
 1. Go to Mattermost console
 2. On section **Authentication**, click on Signup
 3. Set **Enable Email Invitations** to **true** 
 4. Save
    
![image](https://github.com/exo-addons/mattermost-addon/assets/677135/234753af-2885-4b22-a11f-ff6e4c3acfe7)
