import org.exoplatform.addons.mattermost.model.Team;
import org.exoplatform.addons.mattermost.services.MattermostUtils;
import org.junit.Before;

import java.util.Arrays;

import static org.junit.Assert.*;

/**
 * This test class requires an available mattermost server
 * You can configure the connection inside the setUp function
 * with the server using the System properties : - exo.addon.mattermost.userName
 *                                               - exo.addon.mattermost.password
 *                                               - exo.addon.mattermost.url
 */

public class MattermostUtilsTest {

  @Before
  public void setUp() {
    System.setProperty("exo.addon.mattermost.userName", "admin");
    System.setProperty("exo.addon.mattermost.password", "Pass@123456");
    System.setProperty("exo.addon.mattermost.url", "http://localhost:8065");
  }

  public void connectToMattermost() {
    try {
      String token = MattermostUtils.getMattermostToken();
      assertNotNull(token);
    } catch (Exception e) {
      fail();
    }
  }

  public void createTeam() {
    try {
      Team team = MattermostUtils.createTeam("tnuminTestTeamByAli", "TNUMIN - Test team by Ali", "I");
    } catch (Exception e) {
      fail();
    }
  }
  public void updateTeam() {
    try {
      String teamRandomPrefix = String.valueOf(Math.random() * 1000).substring(0, 3);
      Team team = MattermostUtils.createTeam("team" + teamRandomPrefix, "Test Team " + teamRandomPrefix, "I");
      team.setDisplayName(team.getDisplayName() + " updated");
      Team updatedTeam = MattermostUtils.updateTeam(team);
    } catch (Exception e) {
      fail();
    }
  }

  public void updateTeamVisibility() {
    try {
      String teamRandomPrefix = String.valueOf(Math.random() * 1000).substring(0, 3);
      Team team = MattermostUtils.createTeam("team" + teamRandomPrefix, "Test Team " + teamRandomPrefix, "I");
      Team updatedTeam = MattermostUtils.updateTeamPrivacy(team, "O");
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

  }

  public void deleteTeam() {
    try {
      Team team = MattermostUtils.getTeamById("s1mrzg8fppgc5ku47znz9ay1uw");
      MattermostUtils.deleteTeam(team);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

  }

  public void inviteMembers() {
    try {
      assertTrue(MattermostUtils.inviteMemberToTeam(Arrays.asList("test@exo.com","ali@exo.com"), "m7xuo1iwwtnumd5w7ndey4zcey"));
    } catch (Exception e) {
      fail(e.getMessage());
    }
  }
}
