/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import org.exoplatform.addons.mattermost.model.Team;
import org.exoplatform.addons.mattermost.services.MattermostUtils;
import org.junit.Assert;
import org.junit.Before;

public class MattermostUtilsTest {
    @Before
    public void setUp() {
        System.setProperty("exo.addon.mattermost.userName", "admin");
        System.setProperty("exo.addon.mattermost.password", "Pass@123456");
        System.setProperty("exo.addon.mattermost.url", "http://localhost:8065");
    }

    public void connectToMattermost() {
        try {
            String token = MattermostUtils.getMattermostToken();
            Assert.assertNotNull((Object)token);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    public void createTeam() {
        try {
            Team team = MattermostUtils.createTeam((String)"tnuminTestTeamByAli", (String)"TNUMIN - Test team by Ali", (String)"I");
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    public void updateTeam() {
        try {
            String teamRandomPrefix = String.valueOf(Math.random() * 1000.0).substring(0, 3);
            Team team = MattermostUtils.createTeam((String)("team" + teamRandomPrefix), (String)("Test Team " + teamRandomPrefix), (String)"I");
            team.setDisplayName(team.getDisplayName() + " updated");
            Team team2 = MattermostUtils.updateTeam((Team)team);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    public void updateTeamVisibility() {
        try {
            String teamRandomPrefix = String.valueOf(Math.random() * 1000.0).substring(0, 3);
            Team team = MattermostUtils.createTeam((String)("team" + teamRandomPrefix), (String)("Test Team " + teamRandomPrefix), (String)"I");
            Team team2 = MattermostUtils.updateTeamPrivacy((Team)team, (String)"O");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteTeam() {
        try {
            Team team = MattermostUtils.getTeamById((String)"s1mrzg8fppgc5ku47znz9ay1uw");
            MattermostUtils.deleteTeam((Team)team);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void inviteMembers() {
        try {
            Assert.assertTrue((boolean)MattermostUtils.inviteMemberToTeam(Arrays.asList("test@exo.com", "ali@exo.com"), (String)"m7xuo1iwwtnumd5w7ndey4zcey"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

