/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.mattermost.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.mattermost.model.Team;
import org.exoplatform.addons.mattermost.services.MattermostUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;

public class MattermostSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)MattermostSpaceListener.class.toString());
    public static final String SPACE = "Space";
    private MetadataService metadataService;
    private IdentityManager identityManager;
    public static final String MATTERMOST_TEAM_ID = "MattermostTeamID";
    public static final String MATTERMOST_TEAM_NAME = "MattermostTeamName";
    public static final String MATTERMOST_METADATA_TYPE = "matterMostSpaceIntegration";
    public static final String MATTERMOST_METADATA_NAME = "MattermostTeamMetadata";
    public static final String EXO_ADDON_MATTERMOST_TEAM_NAME_PREFIX = "exo.addon.mattermost.team.name.prefix";
    private final String teamNamePrefix;

    public MattermostSpaceListener(MetadataService metadataService, IdentityManager identityManager) {
        this.metadataService = metadataService;
        this.identityManager = identityManager;
        this.teamNamePrefix = PropertyManager.getProperty((String)EXO_ADDON_MATTERMOST_TEAM_NAME_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String type = "open".equalsIgnoreCase(space.getRegistration()) && "private".equalsIgnoreCase(space.getVisibility()) ? "O" : "I";
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            Team mattermostTeam;
            Object cleanName = space.getPrettyName().toLowerCase().replaceAll("[^a-z0-9]+", "");
            Object teamDisplayName = space.getDisplayName();
            if (StringUtils.isNotBlank((CharSequence)this.teamNamePrefix)) {
                cleanName = (String)cleanName + this.teamNamePrefix.toLowerCase();
                teamDisplayName = (String)teamDisplayName + " - " + this.teamNamePrefix;
            }
            if ((mattermostTeam = MattermostUtils.createTeam((String)cleanName, (String)teamDisplayName, type)) != null) {
                MetadataKey metadataKey = new MetadataKey(MATTERMOST_METADATA_TYPE, MATTERMOST_METADATA_NAME, 0L);
                MetadataObject metadataObject = new MetadataObject(SPACE, space.getId(), null, 0L);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(MATTERMOST_TEAM_ID, mattermostTeam.getId());
                properties.put(MATTERMOST_TEAM_NAME, mattermostTeam.getName());
                this.metadataService.createMetadataItem(metadataObject, metadataKey, properties);
                LOG.info("Mattermost integration: successfully created a team for the space {}", new Object[]{space.getDisplayName()});
                LinkedHashSet<String> allMembers = new LinkedHashSet<String>();
                allMembers.addAll(Arrays.asList(space.getManagers()));
                allMembers.addAll(Arrays.asList(space.getMembers()));
                this.sendInvitationToMembers(new ArrayList<String>(allMembers), mattermostTeam.getId());
            }
        }
        catch (Exception e) {
            LOG.error("Mattermost integration: Could not create a team for space {}", new Object[]{space.getDisplayName(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spaceRemoved(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        LOG.info("Mattermost integration: Deleting team bound to the space '{}'", new Object[]{space.getDisplayName()});
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            MetadataKey metadataKey = new MetadataKey(MATTERMOST_METADATA_TYPE, MATTERMOST_METADATA_NAME, 0L);
            MetadataObject metadataObject = new MetadataObject(SPACE, space.getId(), null, 0L);
            List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataKey.getType(), metadataObject);
            for (MetadataItem item : metadataItems) {
                String teamId = (String)item.getProperties().get(MATTERMOST_TEAM_ID);
                if (!StringUtils.isNotBlank((CharSequence)teamId)) continue;
                try {
                    Team team = MattermostUtils.getTeamById(teamId);
                    MattermostUtils.deleteTeam(team);
                }
                catch (Exception e) {
                    LOG.error("Mattermost integration: Could not delete the team '{}' bound with space '{}'", new Object[]{teamId, space.getDisplayName(), e});
                }
                LOG.info("Mattermost integration: successfully deleted the team with id {} bound to the space {}", new Object[]{teamId, space.getDisplayName()});
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spaceRenamed(SpaceLifeCycleEvent event) {
        block10: {
            Space space = event.getSpace();
            LOG.info("Mattermost integration: Updating team bound to the space '{}'", new Object[]{space.getDisplayName()});
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            try {
                MetadataKey metadataKey = new MetadataKey(MATTERMOST_METADATA_TYPE, MATTERMOST_METADATA_NAME, 0L);
                MetadataObject metadataObject = new MetadataObject(SPACE, space.getId(), null, 0L);
                List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataKey.getType(), metadataObject);
                if (metadataItems.size() != 1) {
                    String message = metadataItems.isEmpty() ? "No team" : "too many teams (" + metadataItems.size() + ")";
                    LOG.warn((Object)(message + " are bound to the space"));
                    return;
                }
                String teamId = (String)((MetadataItem)metadataItems.get(0)).getProperties().get(MATTERMOST_TEAM_ID);
                if (!StringUtils.isNotBlank((CharSequence)teamId)) break block10;
                try {
                    Team team = MattermostUtils.getTeamById(teamId);
                    Object updatedDisplayName = space.getDisplayName();
                    if (team != null) {
                        if (StringUtils.isNotBlank((CharSequence)this.teamNamePrefix)) {
                            updatedDisplayName = (String)updatedDisplayName + " - " + this.teamNamePrefix;
                        }
                        team.setDisplayName((String)updatedDisplayName);
                        MattermostUtils.updateTeam(team);
                    } else {
                        LOG.warn("Could not find a team with Id {} in Mattermost", new Object[]{teamId});
                    }
                }
                catch (Exception e) {
                    LOG.error("Mattermost integration: Could not update the display name of team '{}' for space '{}'", new Object[]{teamId, space.getDisplayName(), e});
                }
                LOG.info("Mattermost integration: successfully updated the display name of the team with id {} bound to the space {}", new Object[]{teamId, space.getDisplayName()});
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        this.updateTeamPrivacy(event);
    }

    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
        this.updateTeamPrivacy(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTeamPrivacy(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        LOG.info("Mattermost integration: Updating team bound to the space '{}'", new Object[]{space.getDisplayName()});
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        String teamId = "";
        try {
            Team team;
            MetadataKey metadataKey = new MetadataKey(MATTERMOST_METADATA_TYPE, MATTERMOST_METADATA_NAME, 0L);
            MetadataObject metadataObject = new MetadataObject(SPACE, space.getId(), null, 0L);
            List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataKey.getType(), metadataObject);
            if (metadataItems.size() != 1) {
                String message = metadataItems.isEmpty() ? "No team" : "too many teams (" + metadataItems.size() + ")";
                LOG.warn((Object)(message + " are bound to the space"));
                return;
            }
            teamId = (String)((MetadataItem)metadataItems.get(0)).getProperties().get(MATTERMOST_TEAM_ID);
            if (StringUtils.isNotBlank((CharSequence)teamId) && (team = MattermostUtils.getTeamById(teamId)) != null) {
                String type = "open".equals(space.getRegistration()) && "private".equals(space.getVisibility()) ? "O" : "I";
                MattermostUtils.updateTeamPrivacy(team, type);
            }
            LOG.info("Mattermost integration: successfully updated the team with id {} bound to the space {}", new Object[]{teamId, space.getDisplayName()});
        }
        catch (Exception e) {
            LOG.error("Mattermost integration: Could not update the team '{}' for space '{}'", new Object[]{teamId, space.getDisplayName(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joined(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String userId = event.getTarget();
        LOG.info("Mattermost integration: Inviting member to join the team bound to the space '{}'", new Object[]{space.getDisplayName()});
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            MetadataKey metadataKey = new MetadataKey(MATTERMOST_METADATA_TYPE, MATTERMOST_METADATA_NAME, 0L);
            MetadataObject metadataObject = new MetadataObject(SPACE, space.getId(), null, 0L);
            List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject(metadataKey.getType(), metadataObject);
            if (metadataItems.size() != 1) {
                String message = metadataItems.isEmpty() ? "No team" : "too many teams (" + metadataItems.size() + ")";
                LOG.warn((Object)(message + " are bound to the space"));
                return;
            }
            String teamId = (String)((MetadataItem)metadataItems.get(0)).getProperties().get(MATTERMOST_TEAM_ID);
            if (StringUtils.isNotBlank((CharSequence)teamId)) {
                Team team = MattermostUtils.getTeamById(teamId);
                if (team != null) {
                    this.sendInvitationToMembers(Collections.singletonList(userId), teamId);
                } else {
                    LOG.warn("Could not find a team with ID {}", new Object[]{teamId});
                }
            }
            LOG.info("Mattermost integration: successfully Invited member {} to join the team bound to the space {}", new Object[]{userId, space.getDisplayName()});
        }
        catch (Exception e) {
            LOG.error("Mattermost integration: Could not Invite member {} to join the team bound to the space {}", new Object[]{userId, space.getDisplayName(), e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void sendInvitationToMembers(List<String> userIds, String teamId) {
        ArrayList<String> emailsList = new ArrayList<String>();
        for (String userId : userIds) {
            Identity invitedUser = this.identityManager.getOrCreateUserIdentity(userId);
            if (invitedUser.getProfile() == null || !StringUtils.isNotBlank((CharSequence)invitedUser.getProfile().getEmail())) continue;
            emailsList.add(invitedUser.getProfile().getEmail());
        }
        try {
            MattermostUtils.inviteMemberToTeam(emailsList, teamId);
        }
        catch (Exception e) {
            LOG.error("Mattermost integration: Could not Invite member {} to join the team bound to the team {}", new Object[]{String.join((CharSequence)",", userIds), teamId, e});
        }
    }
}

