/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.fido.services.impl;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.exoplatform.addons.fido.services.api.FidoConnector;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GluuFido2Connector
extends FidoConnector {
    private static final String SERVER_URL = "serverUrl";
    private static final Log LOG = ExoLogger.getLogger(GluuFido2Connector.class);
    private String serverUrl;
    private static final String GLUU_SERVICE = "gluu-service";

    public GluuFido2Connector(InitParams initParams) {
        if (initParams.getValueParam(SERVER_URL) != null) {
            this.serverUrl = initParams.getValueParam(SERVER_URL).getValue();
        }
    }

    @Override
    public JSONObject startRegistration(String userId, String rpHostName) {
        User user;
        LOG.info("Start FIDO Registration for user {}", new Object[]{userId});
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        long startTime = System.currentTimeMillis();
        try {
            user = organizationService.getUserHandler().findUserByName(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Unable to find user {}", new Object[]{userId, e});
            return null;
        }
        if (user == null) {
            LOG.warn("User {} not exists", new Object[]{userId});
            return null;
        }
        String serviceUrl = this.serverUrl + "/fido2/restv1/fido2/attestation/options";
        JSONObject data = new JSONObject();
        try {
            data.put("username", (Object)userId);
            data.put("displayName", (Object)user.getDisplayName());
            data.put("attestation", (Object)"direct");
            data.put("documentDomain", (Object)rpHostName);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOG.error((Object)"Error when building FIDO Step 1 data", (Throwable)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fido Registration Step 1 request : " + data.toString()));
        }
        try {
            URL url = new URL(serviceUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(data.toString().getBytes(StandardCharsets.UTF_8)));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(data.toString().getBytes(StandardCharsets.UTF_8));
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                String response = IOUtils.toString((InputStream)in, (String)"UTF-8");
                JSONObject jsonResponse = new JSONObject(response);
                JSONArray excludedCredentials = jsonResponse.getJSONArray("excludeCredentials");
                for (int i = 0; i < excludedCredentials.length(); ++i) {
                    JSONObject excludedCredential = (JSONObject)excludedCredentials.get(i);
                    excludedCredential.put("id", (Object)this.transformB64UrlToB64(excludedCredential.getString("id")));
                }
                jsonResponse.put("challenge", (Object)this.transformB64UrlToB64(jsonResponse.getString("challenge")));
                JSONObject userJson = jsonResponse.getJSONObject("user");
                userJson.put("id", (Object)this.transformB64UrlToB64(userJson.getString("id")));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Fido Registration Step 1 response : " + jsonResponse));
                }
                LOG.info("remote_service={} operation={} parameters=\"user:{},request:{},response:{}\" status=ok duration_ms={}", new Object[]{GLUU_SERVICE, "fido-registration-step-1", userId, data.toString(), response, System.currentTimeMillis() - startTime});
                return jsonResponse;
            }
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={} error_msg=\"Error sending start registration request status : {}\"", new Object[]{GLUU_SERVICE, "fido-registration-step-1", userId, System.currentTimeMillis() - startTime, responseCode});
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={}", new Object[]{GLUU_SERVICE, "fido-registration-step-1", userId, System.currentTimeMillis() - startTime, e});
            return null;
        }
    }

    @Override
    public JSONObject finishRegistration(String userId, JSONObject data) {
        LOG.info("Finish FIDO Registration for user {}", new Object[]{userId});
        long startTime = System.currentTimeMillis();
        String serviceUrl = this.serverUrl + "/fido2/restv1/fido2/attestation/result";
        JSONObject dataToSend = new JSONObject();
        try {
            dataToSend.put("type", (Object)data.getString("type"));
            dataToSend.put("id", (Object)data.getString("id"));
            JSONObject response = new JSONObject();
            String encodedClientData = Base64.getUrlEncoder().encodeToString(data.getJSONObject("response").getString("clientDataJSON").getBytes());
            response.put("clientDataJSON", (Object)encodedClientData);
            response.put("attestationObject", (Object)this.transformB64ToB64Url(data.getJSONObject("response").getString("attestationObject")));
            dataToSend.put("response", (Object)response);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOG.error((Object)"Error when building FIDO Step 2 data", (Throwable)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fido Registration Step 2 request : " + dataToSend.toString()));
        }
        try {
            URL url = new URL(serviceUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(dataToSend.toString().getBytes(StandardCharsets.UTF_8)));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(dataToSend.toString().getBytes(StandardCharsets.UTF_8));
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                String response = IOUtils.toString((InputStream)in, (String)"UTF-8");
                JSONObject jsonResponse = new JSONObject(response);
                LOG.info("FIDORegistrationStep2 Response : {}", new Object[]{jsonResponse});
                LOG.info("remote_service={} operation={} parameters=\"user:{},request:{},response:{}\" status=ok duration_ms={}", new Object[]{GLUU_SERVICE, "fido-registration-step-2", userId, dataToSend.toString(), response, System.currentTimeMillis() - startTime});
                return jsonResponse;
            }
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={} error_msg=\"Error sending finish registration request status : {}\"", new Object[]{GLUU_SERVICE, "fido-registration-step-2", userId, System.currentTimeMillis() - startTime, responseCode});
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={}", new Object[]{GLUU_SERVICE, "fido-registration-step-2", userId, System.currentTimeMillis() - startTime, e});
            return null;
        }
    }

    @Override
    public JSONObject startAuthentication(String userId, String rpHostName) {
        User user;
        LOG.info("Start FIDO Authentication for user {}", new Object[]{userId});
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        long startTime = System.currentTimeMillis();
        try {
            user = organizationService.getUserHandler().findUserByName(userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Unable to find user {}", new Object[]{userId, e});
            return null;
        }
        if (user == null) {
            LOG.warn("User {} not exists", new Object[]{userId});
        }
        String serviceUrl = this.serverUrl + "/fido2/restv1/fido2/assertion/options";
        JSONObject data = new JSONObject();
        try {
            data.put("username", (Object)userId);
            data.put("documentDomain", (Object)rpHostName);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOG.error((Object)"Error when building FIDO Authentication Step 1 data", (Throwable)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fido Authentication Step 1 request : " + data.toString()));
        }
        try {
            URL url = new URL(serviceUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(data.toString().getBytes(StandardCharsets.UTF_8)));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(data.toString().getBytes(StandardCharsets.UTF_8));
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                String response = IOUtils.toString((InputStream)in, (String)"UTF-8");
                JSONObject jsonResponse = new JSONObject(response);
                JSONArray allowedCredentials = jsonResponse.getJSONArray("allowCredentials");
                for (int i = 0; i < allowedCredentials.length(); ++i) {
                    JSONObject allowedCredential = (JSONObject)allowedCredentials.get(i);
                    allowedCredential.put("id", (Object)this.transformB64UrlToB64(allowedCredential.getString("id")));
                }
                jsonResponse.put("challenge", (Object)this.transformB64UrlToB64(jsonResponse.getString("challenge")));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Fido Authentication Step 1 response : " + jsonResponse));
                }
                LOG.info("remote_service={} operation={} parameters=\"user:{},request:{},response:{}\" status=ok duration_ms={}", new Object[]{GLUU_SERVICE, "fido-authentication-step-1", userId, data.toString(), response, System.currentTimeMillis() - startTime});
                return jsonResponse;
            }
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={} error_msg=\"Error sending start authentication request status : {}\"", new Object[]{GLUU_SERVICE, "fido-authentication-step-1", userId, System.currentTimeMillis() - startTime, responseCode});
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={}", new Object[]{GLUU_SERVICE, "fido-authentication-step-1", userId, System.currentTimeMillis() - startTime, e});
            return null;
        }
    }

    @Override
    public JSONObject finishAuthentication(String userId, JSONObject data) {
        LOG.info("Finish FIDO Authentication for user {}", new Object[]{userId});
        long startTime = System.currentTimeMillis();
        String serviceUrl = this.serverUrl + "/fido2/restv1/fido2/assertion/result";
        JSONObject dataToSend = new JSONObject();
        try {
            dataToSend.put("type", (Object)data.getString("type"));
            dataToSend.put("id", (Object)data.getString("id"));
            dataToSend.put("rawId", (Object)data.getString("rawId"));
            JSONObject response = new JSONObject();
            String encodedClientData = Base64.getUrlEncoder().encodeToString(data.getJSONObject("response").getString("clientDataJSON").getBytes());
            response.put("clientDataJSON", (Object)encodedClientData);
            response.put("authenticatorData", (Object)this.transformB64ToB64Url(data.getJSONObject("response").getString("authenticatorData")));
            response.put("signature", (Object)this.transformB64ToB64Url(data.getJSONObject("response").getString("signature")));
            dataToSend.put("response", (Object)response);
        }
        catch (JSONException e) {
            e.printStackTrace();
            LOG.error((Object)"Error when building FIDO Authentication Step 2 data", (Throwable)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fido Authentication Step 2 request : " + dataToSend.toString()));
        }
        try {
            URL url = new URL(serviceUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(dataToSend.toString().getBytes(StandardCharsets.UTF_8)));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(dataToSend.toString().getBytes(StandardCharsets.UTF_8));
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                String response = IOUtils.toString((InputStream)in, (String)"UTF-8");
                JSONObject jsonResponse = new JSONObject(response);
                LOG.info("FIDOAuthenticationStep2 Response : {}", new Object[]{jsonResponse});
                LOG.info("remote_service={} operation={} parameters=\"user:{},request:{},response:{}\" status=ok duration_ms={}", new Object[]{GLUU_SERVICE, "fido-authentication-step-2", userId, dataToSend.toString(), response, System.currentTimeMillis() - startTime});
                return jsonResponse;
            }
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={} error_msg=\"Error sending finish authentication request status : {}\"", new Object[]{GLUU_SERVICE, "fido-authentication-step-2", userId, System.currentTimeMillis() - startTime, responseCode});
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("remote_service={} operation={} parameters=\"user:{}\" status=ko duration_ms={}", new Object[]{GLUU_SERVICE, "fido-authentication-step-2", userId, System.currentTimeMillis() - startTime, e});
            return null;
        }
    }

    private String transformB64UrlToB64(String input) {
        byte[] bytesString = Base64.getUrlDecoder().decode(input);
        return Base64.getEncoder().encodeToString(bytesString);
    }

    private String transformB64ToB64Url(String input) {
        byte[] bytesString = Base64.getDecoder().decode(input.getBytes());
        return Base64.getUrlEncoder().encodeToString(bytesString);
    }
}

