package org.exoplatform.addons.fido.services.api;

import org.exoplatform.mfa.api.MfaSystemService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Locale;

public class FidoService implements MfaSystemService {
  private HashMap<String, FidoConnector> fidoConnectors;
  private String activeConnector;
  
  public static String TYPE="Fido2";
  
  private static final Log LOG = ExoLogger.getLogger(FidoService.class);

  private ResourceBundleService resourceBundleService;
  
  public FidoService(InitParams initParams, ResourceBundleService resourceBundleService) {
    fidoConnectors =new HashMap<>();
    ValueParam activeConnectorParam = initParams.getValueParam("activeConnector");
    if (activeConnectorParam!=null) {
      activeConnector=activeConnectorParam.getValue();
    }
    this.resourceBundleService=resourceBundleService;
  }
  
  public void addConnector (FidoConnector fidoConnector) {
    fidoConnectors.put(fidoConnector.getName(),fidoConnector);
  }
  
  public JSONObject startRegistration(String userId, String rpHostName) {
    if (getActiveConnector()!=null) {
      return getActiveConnector().startRegistration(userId, rpHostName);
    }
    LOG.warn("No Fido active connector registred");
    return null;
    
  }
  
  public JSONObject finishRegistration(String userId, JSONObject data) {
    if (getActiveConnector()!=null) {
      return getActiveConnector().finishRegistration(userId, data);
    }
    LOG.warn("No Fido active connector registred");
    return null;
    
  }
  
  public JSONObject startAuthentication(String userId, String rpHostName) {
    if (getActiveConnector()!=null) {
      return getActiveConnector().startAuthentication(userId,rpHostName);
    }
    LOG.warn("No Fido active connector registred");
    return null;
  
  }
  
  public JSONObject finishAuthentication(String userId, JSONObject data) {
    if (getActiveConnector()!=null) {
      return getActiveConnector().finishAuthentication(userId, data);
    }
    LOG.warn("No Fido active connector registred");
    return null;
    
  }
  
  private FidoConnector getActiveConnector() {
    return fidoConnectors.get(activeConnector);
  }

  @Override
  public String getType() {
    return TYPE;
  }

  @Override
  public String getHelpTitle(Locale locale) {
    return resourceBundleService.getResourceBundle("locale.mfafido.mfafido",locale)
                                .getString("mfa.fido.help.title");
  }

  @Override
  public String getHelpContent(Locale locale) {
    return resourceBundleService.getResourceBundle("locale.mfafido.mfafido",locale)
                                .getString("mfa.fido.help.content");
  }
}
