/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.provider;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="PostNewsNotificationPlugin", template="war:/notification/templates/web/postNewsNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="ShareNewsNotificationPlugin", template="war:/notification/templates/web/postNewsNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="ShareMyNewsNotificationPlugin", template="war:/notification/templates/web/postNewsNotificationPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    protected static Log log = ExoLogger.getLogger(WebTemplateProvider.class);

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"PostNewsNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"ShareNewsNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"ShareMyNewsNotificationPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String contentAuthor = notification.getValueOwnerParameter("CONTENT_AUTHOR");
            String currentUser = notification.getValueOwnerParameter("CURRENT_USER");
            String contentTitle = notification.getValueOwnerParameter("CONTENT_TITLE");
            String contentSpaceName = notification.getValueOwnerParameter("CONTENT_SPACE");
            String illustrationUrl = notification.getValueOwnerParameter("ILLUSTRATION_URL");
            String activityLink = notification.getValueOwnerParameter("ACTIVITY_LINK");
            String context = notification.getValueOwnerParameter("CONTEXT");
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            templateContext.put((Object)"CONTENT_TITLE", (Object)encoder.encode(contentTitle));
            templateContext.put((Object)"CONTENT_SPACE", (Object)encoder.encode(contentSpaceName));
            templateContext.put((Object)"CONTENT_AUTHOR", (Object)encoder.encode(contentAuthor));
            templateContext.put((Object)"CURRENT_USER", (Object)currentUser);
            templateContext.put((Object)"ILLUSTRATION_URL", (Object)encoder.encode(illustrationUrl));
            templateContext.put((Object)"ACTIVITY_LINK", (Object)encoder.encode(activityLink));
            templateContext.put((Object)"CONTEXT", (Object)encoder.encode(context));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

