/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.news.NewsAttachmentsService;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.NewsAttachment;
import org.exoplatform.news.model.SharedNews;
import org.exoplatform.news.rest.NewsEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="v1/news")
@Api(tags={"v1/news"}, value="v1/news", description="Managing news")
public class NewsRestResourcesV1
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(NewsRestResourcesV1.class);
    private static final String REDACTOR_MEMBERSHIP_NAME = "redactor";
    private static final String MANAGER_MEMBERSHIP_NAME = "manager";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private static final String PLATFORM_ADMINISTRATORS_GROUP = "/platform/administrators";
    private NewsService newsService;
    private NewsAttachmentsService newsAttachmentsService;
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public NewsRestResourcesV1(NewsService newsService, NewsAttachmentsService newsAttachmentsService, SpaceService spaceService, IdentityManager identityManager) {
        this.newsService = newsService;
        this.newsAttachmentsService = newsAttachmentsService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a news", httpMethod="POST", response=Response.class, notes="This creates the news if the authenticated user is a member of the space or a spaces super manager. The news is created in draft status, unless the publicationState property is set to 'published'.")
    @ApiResponses(value={@ApiResponse(code=200, message="News created"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to create the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response createNews(@Context HttpServletRequest request, @ApiParam(value="News", required=true) News news) {
        if (news == null || StringUtils.isEmpty((CharSequence)news.getSpaceId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String authenticatedUser = request.getRemoteUser();
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            News createdNews = "published".equals(news.getPublicationState()) ? this.newsService.createNews(news) : this.newsService.createNewsDraft(news);
            return Response.ok((Object)createdNews).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating the news " + news.getTitle()), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get news list", httpMethod="GET", response=Response.class, notes="This gets the list of news with the given search text, of the given author, in the given space or spaces, with the given publication state, with the given pinned state if the authenticated user is a member of the spaces or a super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News list returned"), @ApiResponse(code=401, message="User not authorized to get the news list"), @ApiResponse(code=404, message="News list not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNews(@Context HttpServletRequest request, @ApiParam(value="News author", required=true) @QueryParam(value="author") String author, @ApiParam(value="News spaces", required=true) @QueryParam(value="spaces") String spaces, @ApiParam(value="News publication state", required=true) @QueryParam(value="publicationState") String publicationState, @ApiParam(value="News filter", required=true) @QueryParam(value="filter") String filter, @ApiParam(value="search text", required=true) @QueryParam(value="text") String text, @ApiParam(value="News pagination offset", defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="News pagination limit", defaultValue="10") @QueryParam(value="limit") int limit, @ApiParam(value="News total size", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        try {
            String authenticatedUser = request.getRemoteUser();
            if (StringUtils.isBlank((CharSequence)author) || !authenticatedUser.equals(author)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            NewsEntity newsEntity = new NewsEntity();
            if ("draft".equals(publicationState)) {
                if (StringUtils.isNotEmpty((CharSequence)spaces)) {
                    Space space = this.spaceService.getSpaceById(spaces);
                    if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                    List<News> drafts = this.newsService.getNewsDrafts(spaces, author);
                    if (drafts != null) {
                        List<News> news = drafts;
                        newsEntity.setNews(news);
                    }
                }
                return Response.ok((Object)newsEntity).build();
            }
            if ("published".equals(publicationState)) {
                List<News> news;
                ArrayList<String> spacesList = new ArrayList<String>();
                if (StringUtils.isNotEmpty((CharSequence)spaces)) {
                    for (String space : spaces.split(",")) {
                        if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                        }
                        spacesList.add(space);
                    }
                }
                NewsFilter newsFilter = this.buildFilter(spacesList, filter, text, author, limit, offset);
                if (StringUtils.isNotEmpty((CharSequence)text)) {
                    String lang = request.getLocale().getLanguage();
                    news = this.newsService.searchNews(newsFilter, lang);
                } else {
                    news = this.newsService.getNews(newsFilter);
                }
                if (news != null && news.size() != 0) {
                    for (News newsItem : news) {
                        newsItem.setIllustration(null);
                    }
                }
                newsEntity.setNews(news);
                newsEntity.setOffset(offset);
                newsEntity.setLimit(limit);
                if (returnSize) {
                    newsEntity.setSize(this.newsService.getNewsCount(newsFilter));
                }
                return Response.ok((Object)newsEntity).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news with params author=" + author + ", spaces=" + spaces + ", publicationState=" + publicationState), (Throwable)e);
            return Response.serverError().build();
        }
    }

    private NewsFilter buildFilter(List<String> spaces, String filter, String text, String author, int limit, int offset) {
        NewsFilter newsFilter = new NewsFilter();
        newsFilter.setSpaces(spaces);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            FilterType filterType = FilterType.valueOf(filter.toUpperCase());
            switch (filterType) {
                case PINNED: {
                    newsFilter.setPinnedNews(true);
                    break;
                }
                case MYPOSTED: {
                    if (!StringUtils.isNotEmpty((CharSequence)author)) break;
                    newsFilter.setAuthor(author);
                    break;
                }
                case ARCHIVED: {
                    newsFilter.setArchivedNews(true);
                }
            }
        }
        if (text != null && StringUtils.isNotEmpty((CharSequence)text)) {
            newsFilter.setSearchText(text);
            newsFilter.setOrder("jcr:score");
        } else {
            newsFilter.setOrder("exo:dateModified");
        }
        newsFilter.setLimit(limit);
        newsFilter.setOffset(offset);
        return newsFilter;
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a news", httpMethod="GET", response=Response.class, notes="This gets the news with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsById(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="fields", required=true) @QueryParam(value="fields") String fields) {
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            News news = this.newsService.getNewsById(id);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!news.isPinned()) {
                String authenticatedUser = request.getRemoteUser();
                Space space = this.spaceService.getSpaceById(news.getSpaceId());
                if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            news.setIllustration(null);
            if (StringUtils.isNotEmpty((CharSequence)fields) && fields.equals("spaces")) {
                News filteredNews = new News();
                HashSet<Space> spacesList = new HashSet<Space>();
                String newsActivities = news.getActivities();
                for (String act : newsActivities.split(";")) {
                    String spaceId = act.split(":")[0];
                    Space space = this.spaceService.getSpaceById(spaceId);
                    spacesList.add(space);
                }
                filteredNews.setSharedInSpacesList(spacesList);
                return Response.ok((Object)filteredNews).build();
            }
            return Response.ok((Object)news).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="attachments/{attachmentId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a news attachment", httpMethod="GET", response=Response.class, notes="This gets the news attachment with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsAttachmentById(@Context HttpServletRequest request, @ApiParam(value="News attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        try {
            NewsAttachment attachment = this.newsAttachmentsService.getNewsAttachment(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)attachment).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news attachment " + attachmentId), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="attachments/{attachmentId}/file")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Download a news attachment", httpMethod="GET", response=Response.class, notes="This downloads the news attachment with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsAttachmentBinaryById(@Context HttpServletRequest request, @ApiParam(value="News attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        try {
            NewsAttachment attachment = this.newsAttachmentsService.getNewsAttachment(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            InputStream stream = this.newsAttachmentsService.getNewsAttachmentStream(attachmentId);
            Response.ResponseBuilder responseBuilder = Response.ok((Object)stream, (String)attachment.getMimetype());
            responseBuilder.header("Content-Disposition", (Object)("attachment; filename=\"" + attachment.getName() + "\""));
            return responseBuilder.build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news attachment " + attachmentId), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="attachments/{attachmentId}/open")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Opens a news attachment", httpMethod="GET", response=Response.class, notes="This opens the news attachment with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response openNewsAttachmentById(@Context HttpServletRequest request, @ApiParam(value="News attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        try {
            NewsAttachment attachment = this.newsAttachmentsService.getNewsAttachment(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String openUrl = this.newsAttachmentsService.getNewsAttachmentOpenUrl(attachmentId);
            return Response.temporaryRedirect((URI)URI.create(openUrl)).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news attachment " + attachmentId), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a news", httpMethod="PUT", response=Response.class, notes="This updates the news if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News updated"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to update the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateNews(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="News", required=true) News updatedNews) {
        if (updatedNews == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            News news = this.newsService.getNewsById(id);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = request.getRemoteUser();
            Space space = this.spaceService.getSpaceById(news.getSpaceId());
            if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            news.setTitle(updatedNews.getTitle());
            news.setSummary(updatedNews.getSummary());
            news.setBody(updatedNews.getBody());
            news.setUploadId(updatedNews.getUploadId());
            news.setAttachments(updatedNews.getAttachments());
            news.setPublicationState(updatedNews.getPublicationState());
            if (updatedNews.isPinned() != news.isPinned()) {
                boolean canPinOrUnpinNews;
                Identity currentIdentity = ConversationState.getCurrent().getIdentity();
                boolean bl = canPinOrUnpinNews = currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.isMemberOf(PLATFORM_ADMINISTRATORS_GROUP, "*");
                if (!canPinOrUnpinNews) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                news.setPinned(updatedNews.isPinned());
                if (news.isPinned()) {
                    this.newsService.pinNews(id);
                } else {
                    this.newsService.unpinNews(id);
                }
            }
            news = this.newsService.updateNews(news);
            return Response.ok((Object)news).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="{id}/share")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="share a news", httpMethod="POST", response=Response.class, notes="This shares a news to a list of spaces if the authenticated user is a member of these spaces or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News shared"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to share the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response shareNews(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="Shared News", required=true) SharedNews sharedNews) {
        try {
            News news = this.newsService.getNewsById(id);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            sharedNews.setNewsId(id);
            if (sharedNews == null || sharedNews.getSpacesNames() == null || sharedNews.getSpacesNames().isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String authenticatedUser = request.getRemoteUser();
            ArrayList<Space> spaces = new ArrayList<Space>();
            boolean superManager = this.spaceService.isSuperManager(authenticatedUser);
            for (String spaceName : sharedNews.getSpacesNames()) {
                Space space = this.spaceService.getSpaceByPrettyName(spaceName);
                if (space == null) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                if (!superManager && !this.spaceService.isMember(space, authenticatedUser)) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                spaces.add(space);
            }
            sharedNews.setPoster(authenticatedUser);
            this.newsService.shareNews(sharedNews, spaces);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when sharing the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{id}/illustration")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get a news illustration", httpMethod="GET", response=Response.class, notes="This gets the news illustration with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsIllustration(@Context Request request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id) {
        try {
            Response.ResponseBuilder builder;
            Space space;
            News news = this.newsService.getNewsById(id);
            if (news == null || news.getIllustration() == null || news.getIllustration().length == 0) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!news.isPinned() && (space = this.spaceService.getSpaceById(news.getSpaceId())) == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            EntityTag eTag = new EntityTag(String.valueOf(news.getIllustrationUpdateDate().getTime()));
            Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = Response.ok((Object)news.getIllustration(), (String)"image/png");
                builder.tag(eTag);
            }
            return builder.build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="{id}/click")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Log a click action on a news", httpMethod="POST", response=Response.class, notes="This logs a message when the user performs a click on a news")
    @ApiResponses(value={@ApiResponse(code=200, message="Click logged"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response clickOnNews(@Context UriInfo uriInfo, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="The clicked element", required=true) String clickedElement) {
        News news;
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser, false);
        try {
            news = this.newsService.getNewsById(id);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting news with id " + id), (Throwable)e);
            return Response.serverError().build();
        }
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        LOG.info("service=news operation=click_on_{} parameters=\"news_id:{},space_name:{},space_id:{},user_id:{}\"", new Object[]{clickedElement, news.getId(), space != null ? space.getPrettyName() : "", space != null ? space.getId() : "", currentUser.getId()});
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update a news", httpMethod="PATCH", response=Response.class, notes="This updates the sent fields of a news")
    @ApiResponses(value={@ApiResponse(code=200, message="News updated"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to update the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response patchNews(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="News", required=true) News updatedNews) {
        if (updatedNews == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            boolean isUpdatedIllustration;
            News news = this.newsService.getNewsById(id);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = request.getRemoteUser();
            Space space = this.spaceService.getSpaceById(news.getSpaceId());
            if (space == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            if (updatedNews.isPinned() != news.isPinned()) {
                boolean canPinOrUnpinNews;
                boolean bl = canPinOrUnpinNews = currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.isMemberOf(PLATFORM_ADMINISTRATORS_GROUP, "*");
                if (!canPinOrUnpinNews) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                news.setPinned(updatedNews.isPinned());
                if (news.isPinned()) {
                    this.newsService.pinNews(id);
                } else {
                    this.newsService.unpinNews(id);
                }
            }
            if (updatedNews.isArchived() != news.isArchived()) {
                boolean canArchiveOrUnarchiveNews;
                boolean bl = canArchiveOrUnarchiveNews = currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.getUserId().equals(news.getAuthor());
                if (!canArchiveOrUnarchiveNews) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                news.setArchived(updatedNews.isArchived());
                if (news.isArchived()) {
                    this.newsService.archiveNews(id);
                } else {
                    this.newsService.unarchiveNews(id);
                }
            }
            boolean isUpdatedTitle = updatedNews.getTitle() != null && !updatedNews.getTitle().equals(news.getTitle());
            boolean isUpdatedSummary = updatedNews.getSummary() != null && !updatedNews.getSummary().equals(news.getSummary());
            boolean isUpdatedBody = updatedNews.getBody() != null && !updatedNews.getBody().equals(news.getBody());
            boolean bl = isUpdatedIllustration = updatedNews.getUploadId() != null && !updatedNews.getUploadId().equals(news.getUploadId());
            if (isUpdatedTitle || isUpdatedSummary || isUpdatedBody || isUpdatedIllustration) {
                if (!this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                if (isUpdatedTitle) {
                    news.setTitle(updatedNews.getTitle());
                }
                if (isUpdatedSummary) {
                    news.setSummary(updatedNews.getSummary());
                }
                if (isUpdatedBody) {
                    news.setBody(updatedNews.getBody());
                }
                if (isUpdatedIllustration) {
                    news.setUploadId(updatedNews.getUploadId());
                }
                this.newsService.updateNews(news);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when trying to update the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="{id}/view")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update a news", httpMethod="PUT", response=Response.class, notes="This increments the views number of a news")
    @ApiResponses(value={@ApiResponse(code=200, message="News updated"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to update the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response viewNews(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id) {
        try {
            Space space;
            News news = this.newsService.getNewsById(id);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
            if (!(news.isPinned() || (space = this.spaceService.getSpaceById(news.getSpaceId())) != null && (this.spaceService.isMember(space, authenticatedUser) || this.spaceService.isSuperManager(authenticatedUser)))) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            this.newsService.markAsRead(news, authenticatedUser);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when trying to update the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete news", httpMethod="DELETE", response=Response.class, notes="This deletes the news", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="News deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to delete the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteNews(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id) {
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            News news = this.newsService.getNewsById(id);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = request.getRemoteUser();
            if (StringUtils.isBlank((CharSequence)news.getAuthor()) || !authenticatedUser.equals(news.getAuthor())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            this.newsService.deleteNews(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news with id " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="canCreateNews/{spaceId}")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="check if the current user can create a news in the given space", httpMethod="GET", response=Response.class, notes="This checks if the current user can create a news in the given space", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="News deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to create a news"), @ApiResponse(code=404, message="Space not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response canCreateNews(@Context HttpServletRequest request, @ApiParam(value="space id", required=true) @PathParam(value="spaceId") String spaceId) {
        try {
            if (StringUtils.isBlank((CharSequence)spaceId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String authenticatedUser = request.getRemoteUser();
            if (StringUtils.isBlank((CharSequence)authenticatedUser) || !this.spaceService.isMember(space, authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok((Object)String.valueOf(SpaceUtils.isRedactor((String)authenticatedUser, (String)space.getGroupId()))).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can create a news", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private static enum FilterType {
        PINNED,
        MYPOSTED,
        ARCHIVED,
        ALL;

    }
}

