/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.news.notification.utils.NotificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MentionInNewsNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(MentionInNewsNotificationPlugin.class);
    public static final String ID = "MentionInNewsNotificationPlugin";
    public static final ArgumentLiteral<String> CONTENT_TITLE = new ArgumentLiteral(String.class, "CONTENT_TITLE");
    public static final Pattern MENTION_PATTERN = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    public static final ArgumentLiteral<String> ILLUSTRATION_URL = new ArgumentLiteral(String.class, "ILLUSTRATION_URL");
    public static final ArgumentLiteral<String> ACTIVITY_LINK = new ArgumentLiteral(String.class, "ACTIVITY_LINK");
    public static final ArgumentLiteral<Set> MENTIONED_IDS = new ArgumentLiteral(Set.class, "MENTIONED_IDS");
    public static final ArgumentLiteral<String> CURRENT_USER = new ArgumentLiteral(String.class, "CURRENT_USER");
    public static final ArgumentLiteral<String> CONTENT_SPACE = new ArgumentLiteral(String.class, "CONTENT_SPACE");
    public static final ArgumentLiteral<String> CONTENT_AUTHOR = new ArgumentLiteral(String.class, "CONTENT_AUTHOR");
    public static final ArgumentLiteral<String> CONTENT_SPACE_ID = new ArgumentLiteral(String.class, "CONTENT_SPACE_ID");
    public static final ArgumentLiteral<NotificationConstants.NOTIFICATION_CONTEXT> CONTEXT = new ArgumentLiteral(NotificationConstants.NOTIFICATION_CONTEXT.class, "CONTEXT");

    public MentionInNewsNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String currentUserName;
        NotificationConstants.NOTIFICATION_CONTEXT context = (NotificationConstants.NOTIFICATION_CONTEXT)((Object)ctx.value(CONTEXT));
        String currentUserFullName = currentUserName = (String)ctx.value(CURRENT_USER);
        try {
            currentUserFullName = NotificationUtils.getUserFullName(currentUserName);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured when trying to retreive a user with username " + currentUserName + " " + e.getMessage()), (Throwable)e);
        }
        String contentAuthor = (String)ctx.value(CONTENT_AUTHOR);
        String contentSpaceName = (String)ctx.value(CONTENT_SPACE);
        ArrayList mentionedIds = new ArrayList((Collection)ctx.value(MENTIONED_IDS));
        String newsTitle = (String)ctx.value(CONTENT_TITLE);
        String illustrationUrl = (String)ctx.value(ILLUSTRATION_URL);
        String activityLink = (String)ctx.value(ACTIVITY_LINK);
        return NotificationInfo.instance().setFrom(currentUserName).to(mentionedIds).key(this.getKey()).with("CONTENT_TITLE", newsTitle).with("CONTENT_AUTHOR", contentAuthor).with("CURRENT_USER", currentUserFullName).with("CONTENT_SPACE", contentSpaceName).with("ILLUSTRATION_URL", illustrationUrl).with("ACTIVITY_LINK", activityLink).with("CONTEXT", context.getContext()).end();
    }
}

