/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.model.News;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NewsPublicationListener
extends Listener<CmsService, Node> {
    private NewsService newsService = (NewsService)WCMCoreUtils.getService(NewsService.class);
    private SessionProviderService sessionProviderService = (SessionProviderService)WCMCoreUtils.getService(SessionProviderService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<CmsService, Node> event) throws Exception {
        if ("PublicationService.event.postChangeState".equals(event.getEventName())) {
            News news;
            PortalContainer container = PortalContainer.getInstance();
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            SessionProvider systemProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = systemProvider.getSession(repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), repositoryService.getCurrentRepository());
            Node targetNode = (Node)event.getData();
            if (targetNode.isNodeType("exo:news") && targetNode.getProperty("publication:currentState").getString().equals("published") && StringUtils.isEmpty((CharSequence)(news = this.newsService.convertNodeToNews(targetNode, false)).getActivities())) {
                try {
                    this.newsService.createNews(news, session);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
        }
    }
}

