/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.jcr.ItemNotFoundException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.notification.plugin.MentionInNewsNotificationPlugin;
import org.exoplatform.news.notification.plugin.PostNewsNotificationPlugin;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.news.notification.utils.NotificationUtils;
import org.exoplatform.news.search.NewsESSearchConnector;
import org.exoplatform.news.search.NewsESSearchResult;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.news.storage.NewsStorage;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.upload.UploadService;

public class NewsServiceImpl
implements NewsService {
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private static final String NEWS_ID = "newsId";
    public SpaceService spaceService;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private NewsESSearchConnector newsESSearchConnector;
    private IndexingService indexingService;
    private NewsStorage newsStorage;
    private UserACL userACL;
    private NewsTargetingService newsTargetingService;
    private static final Log LOG = ExoLogger.getLogger(NewsServiceImpl.class);

    public NewsServiceImpl(SpaceService spaceService, ActivityManager activityManager, IdentityManager identityManager, UploadService uploadService, NewsESSearchConnector newsESSearchConnector, IndexingService indexingService, NewsStorage newsStorage, UserACL userACL, NewsTargetingService newsTargetingService) {
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.newsESSearchConnector = newsESSearchConnector;
        this.indexingService = indexingService;
        this.newsStorage = newsStorage;
        this.userACL = userACL;
        this.newsTargetingService = newsTargetingService;
    }

    @Override
    public News createNews(News news, Identity currentIdentity) throws Exception {
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        try {
            if (!this.canCreateNews(space, currentIdentity)) {
                throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " not authorized to create news");
            }
            News createdNews = "published".equals(news.getPublicationState()) && this.recreateIfDraftDeleted(news) != null ? this.postNews(news, currentIdentity.getUserId()) : (news.getSchedulePostDate() != null ? this.unScheduleNews(news, currentIdentity) : this.newsStorage.createNews(news));
            return createdNews;
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating the news " + news.getTitle()), (Throwable)e);
            return null;
        }
    }

    private News recreateIfDraftDeleted(News news) throws Exception {
        News existNews;
        try {
            existNews = this.newsStorage.getNewsById(news.getId(), false);
        }
        catch (ItemNotFoundException e) {
            existNews = this.newsStorage.createNews(news);
        }
        return existNews;
    }

    @Override
    public boolean canCreateNews(Space space, Identity currentIdentity) throws Exception {
        return space != null && (this.spaceService.isSuperManager(currentIdentity.getUserId()) || this.spaceService.isManager(space, currentIdentity.getUserId()) || this.spaceService.isRedactor(space, currentIdentity.getUserId()) || this.spaceService.isMember(space, currentIdentity.getUserId()) && (ArrayUtils.isEmpty((Object[])space.getRedactors()) || currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME)));
    }

    @Override
    public News updateNews(News news, String updater, Boolean post, boolean publish) throws Exception {
        boolean displayed;
        if (!this.canEditNews(news, updater)) {
            throw new IllegalArgumentException("User " + updater + " is not authorized to update news");
        }
        News originalNews = this.newsStorage.getNewsById(news.getId(), false);
        Set<String> previousMentions = NewsUtils.processMentions(originalNews.getOriginalBody());
        if (publish != news.isPublished() && news.isCanPublish()) {
            news.setPublished(publish);
            if (news.isPublished()) {
                this.publishNews(news, updater);
            } else {
                this.unpublishNews(news.getId(), updater);
            }
        }
        List<String> oldTargets = this.newsTargetingService.getTargetsByNewsId(news.getId());
        boolean bl = displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !news.isArchived();
        if (publish == news.isPublished() && news.isPublished() && news.isCanPublish() && news.getTargets() != null && !oldTargets.equals(news.getTargets())) {
            this.newsTargetingService.deleteNewsTargets(news.getId(), updater);
            this.newsTargetingService.saveNewsTarget(news.getId(), displayed, news.getTargets(), updater);
        }
        this.newsStorage.updateNews(news, updater);
        if ("published".equals(news.getPublicationState())) {
            if (StringUtils.isNotEmpty((CharSequence)news.getId()) && news.getCreationDate() != null) {
                News newMentionedNews = news;
                if (!previousMentions.isEmpty()) {
                    previousMentions.forEach(username -> newMentionedNews.setBody(newMentionedNews.getBody().replaceAll("@" + username, "")));
                }
                this.sendNotification(updater, newMentionedNews, NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS);
            }
            this.indexingService.reindex("news", String.valueOf(news.getId()));
        }
        if (post != null && !"draft".equals(news.getPublicationState())) {
            this.updateNewsActivity(news, post);
        }
        NewsUtils.broadcastEvent("exo.news.updateArticle", updater, news);
        return news;
    }

    @Override
    public void deleteNews(String newsId, Identity currentIdentity, boolean isDraft) throws Exception {
        News news = this.getNewsById(newsId, currentIdentity, false);
        if (!news.isCanDelete()) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " is not authorized to delete news");
        }
        List<String> newsTargets = this.newsTargetingService.getTargetsByNewsId(newsId);
        if (newsTargets != null) {
            this.newsTargetingService.deleteNewsTargets(newsId);
        }
        this.newsStorage.deleteNews(newsId, isDraft);
        this.indexingService.unindex("news", String.valueOf(news.getId()));
        NewsUtils.broadcastEvent("exo.news.deleteArticle", currentIdentity.getUserId(), news);
    }

    @Override
    public News getNewsById(String newsId, Identity currentIdentity, boolean editMode) throws IllegalAccessException {
        News news = null;
        try {
            news = this.getNewsById(newsId, editMode);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurred while retrieving news with id " + newsId), (Throwable)e);
        }
        if (news != null) {
            if (editMode) {
                if (!this.canEditNews(news, currentIdentity.getUserId())) {
                    throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to edit News");
                }
            } else if (!this.canViewNews(news, currentIdentity.getUserId())) {
                throw new IllegalAccessException("User " + currentIdentity.getUserId() + " is not authorized to view News");
            }
            news.setCanEdit(this.canEditNews(news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(currentIdentity));
            news.setCanArchive(this.canArchiveNews(currentIdentity, news.getAuthor()));
            news.setTargets(this.newsTargetingService.getTargetsByNewsId(newsId));
            ExoSocialActivity activity = null;
            try {
                activity = this.activityManager.getActivity(news.getActivityId());
            }
            catch (Exception e) {
                LOG.debug("Error getting activity of News with id {}", new Object[]{news.getActivityId(), e});
            }
            if (activity != null) {
                RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess(activity, true);
                news.setCommentsCount(listAccess.getSize());
                news.setLikesCount(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
            }
        }
        return news;
    }

    @Override
    public News getNewsById(String newsId, boolean editMode) throws Exception {
        try {
            News news = this.newsStorage.getNewsById(newsId, editMode);
            return news;
        }
        catch (Exception e) {
            throw new Exception("An error occurred while retrieving news with id " + newsId, e);
        }
    }

    @Override
    public List<News> getNews(NewsFilter newsFilter, Identity currentIdentity) throws Exception {
        List<News> newsList = this.newsStorage.getNews(newsFilter);
        newsList.stream().forEach(news -> {
            news.setCanEdit(this.canEditNews((News)news, currentIdentity.getUserId()));
            news.setCanDelete(this.canDeleteNews(currentIdentity, news.getAuthor(), news.getSpaceId()));
            news.setCanPublish(NewsUtils.canPublishNews(currentIdentity));
            news.setCanArchive(this.canArchiveNews(currentIdentity, news.getAuthor()));
        });
        return newsList;
    }

    @Override
    public List<News> getNewsByTargetName(NewsFilter newsFilter, String targetName, Identity currentIdentity) throws Exception {
        List<MetadataItem> newsTargetItems = this.newsTargetingService.getNewsTargetItemsByTargetName(targetName, newsFilter.getOffset(), newsFilter.getLimit());
        return newsTargetItems.stream().map(target -> {
            try {
                News news = this.getNewsById(target.getObjectId(), currentIdentity, false);
                news.setPublishDate(new Date(target.getCreatedDate()));
                return news;
            }
            catch (Exception e) {
                return null;
            }
        }).collect(Collectors.toList());
    }

    @Override
    public int getNewsCount(NewsFilter newsFilter) throws Exception {
        return this.newsStorage.getNewsCount(newsFilter);
    }

    @Override
    public List<News> searchNews(NewsFilter filter, String lang) throws Exception {
        return this.newsStorage.searchNews(filter, lang);
    }

    @Override
    public News getNewsByActivityId(String activityId, Identity currentIdentity) throws IllegalAccessException, ObjectNotFoundException {
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " wasn't found");
        }
        Identity viewerIdentity = NewsUtils.getUserIdentity(currentIdentity.getUserId());
        if (!this.activityManager.isActivityViewable(activity, viewerIdentity)) {
            throw new IllegalAccessException("User " + currentIdentity.getUserId() + " isn't allowed to access activity with id " + activityId);
        }
        Map templateParams = activity.getTemplateParams();
        if (templateParams == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        String newsId = (String)templateParams.get(NEWS_ID);
        if (StringUtils.isBlank((CharSequence)newsId)) {
            String originalActivityId = (String)templateParams.get("originalActivityId");
            if (StringUtils.isNotBlank((CharSequence)originalActivityId)) {
                org.exoplatform.social.core.identity.model.Identity sharedActivityPosterIdentity = this.identityManager.getIdentity(activity.getPosterId());
                if (sharedActivityPosterIdentity == null) {
                    throw new IllegalAccessException("Shared Activity '" + activityId + "' Poster " + activity.getPosterId() + " isn't found");
                }
                return this.getNewsByActivityId(originalActivityId, NewsUtils.getUserIdentity(sharedActivityPosterIdentity.getRemoteId()));
            }
            throw new ObjectNotFoundException("Activity with id " + activityId + " isn't of type news nor a shared news");
        }
        return this.getNewsById(newsId, currentIdentity, false);
    }

    @Override
    public News scheduleNews(News news, Identity currentIdentity) throws Exception {
        boolean displayed;
        Space space;
        Space space2 = space = news.getSpaceId() == null ? null : this.spaceService.getSpaceById(news.getSpaceId());
        if (!this.canScheduleNews(space, currentIdentity)) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " is not authorized to schedule news");
        }
        boolean bl = displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !news.isArchived();
        if (NewsUtils.canPublishNews(currentIdentity) && news.isPublished() && news.getTargets() != null) {
            this.newsTargetingService.deleteNewsTargets(news.getId());
            this.newsTargetingService.saveNewsTarget(news.getId(), displayed, news.getTargets(), currentIdentity.getUserId());
        }
        news = this.newsStorage.scheduleNews(news);
        NewsUtils.broadcastEvent("exo.news.scheduleArticle", currentIdentity.getUserId(), news);
        return news;
    }

    @Override
    public News unScheduleNews(News news, Identity currentIdentity) throws Exception {
        Space space;
        Space space2 = space = news.getSpaceId() == null ? null : this.spaceService.getSpaceById(news.getSpaceId());
        if (!this.canScheduleNews(space, currentIdentity)) {
            throw new IllegalArgumentException("User " + currentIdentity.getUserId() + " is not authorized to unschedule news");
        }
        this.newsTargetingService.deleteNewsTargets(news.getId());
        news = this.newsStorage.unScheduleNews(news);
        NewsUtils.broadcastEvent("exo.news.unscheduleArticle", currentIdentity.getUserId(), news);
        return news;
    }

    @Override
    public List<NewsESSearchResult> search(org.exoplatform.social.core.identity.model.Identity currentIdentity, NewsFilter filter) {
        return this.newsESSearchConnector.search(currentIdentity, filter);
    }

    @Override
    public News postNews(News news, String poster) throws Exception {
        this.postNewsActivity(news);
        this.updateNews(news, poster, null, news.isPublished());
        this.sendNotification(poster, news, NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS);
        if (news.isPublished()) {
            this.publishNews(news, poster);
        }
        NewsUtils.broadcastEvent("exo.news.gamification.postArticle", news.getId(), news);
        NewsUtils.broadcastEvent("exo.news.postArticle", news.getAuthor(), news);
        return news;
    }

    @Override
    public void markAsRead(News news, String userId) throws Exception {
        if (!this.newsStorage.isCurrentUserInNewsViewers(news.getId(), userId)) {
            this.newsStorage.markAsRead(news, userId);
        }
        NewsUtils.broadcastEvent("exo.news.viewArticle", userId, news);
    }

    @Override
    public void publishNews(News publishedNews, String publisher) throws Exception {
        News news = this.getNewsById(publishedNews.getId(), false);
        boolean displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !news.isArchived();
        this.newsStorage.publishNews(news);
        if (publishedNews.getTargets() != null) {
            this.newsTargetingService.deleteNewsTargets(publishedNews.getId(), publisher);
            this.newsTargetingService.saveNewsTarget(publishedNews.getId(), displayed, publishedNews.getTargets(), publisher);
        }
        NewsUtils.broadcastEvent("exo.news.gamification.PublishArticle", news.getId(), news);
        this.sendNotification(publisher, news, NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_IN_NEWS);
    }

    @Override
    public void unpublishNews(String newsId, String publisher) throws Exception {
        this.newsStorage.unpublishNews(newsId);
        this.newsTargetingService.deleteNewsTargets(newsId, publisher);
    }

    @Override
    public void shareNews(News news, Space space, org.exoplatform.social.core.identity.model.Identity userIdentity, String sharedActivityId) throws Exception {
        if (!this.canViewNews(news, userIdentity.getRemoteId())) {
            throw new IllegalAccessException("User with id " + userIdentity.getRemoteId() + "doesn't have access to news");
        }
        this.newsStorage.shareNews(news, space, userIdentity, sharedActivityId);
        if (sharedActivityId != null) {
            NewsUtils.broadcastEvent("exo.news.shareArticle", userIdentity.getRemoteId(), news);
        }
    }

    public void postNewsActivity(News news) throws Exception {
        org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getOrCreateIdentity("organization", news.getAuthor());
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("");
        activity.setType("news");
        activity.setUserId(poster.getId());
        activity.isHidden(news.isActivityPosted());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(NEWS_ID, news.getId());
        activity.setTemplateParams(templateParams);
        activity.setMetadataObjectId(news.getId());
        activity.setMetadataObjectType("news");
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.newsStorage.updateNewsActivities(activity.getId(), news);
    }

    @Override
    public void archiveNews(String newsId, String currentUserName) throws Exception {
        this.newsStorage.archiveNews(newsId);
        News news = this.getNewsById(newsId, false);
        boolean displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !news.isArchived();
        List<String> newsTargets = this.newsTargetingService.getTargetsByNewsId(newsId);
        if (newsTargets != null && !newsTargets.isEmpty()) {
            this.newsTargetingService.deleteNewsTargets(news.getId(), currentUserName);
            this.newsTargetingService.saveNewsTarget(news.getId(), displayed, newsTargets, currentUserName);
        }
        NewsUtils.broadcastEvent("exo.news.archiveArticle", currentUserName, news);
    }

    @Override
    public boolean canViewNews(News news, String username) {
        try {
            Space space;
            String spaceId = news.getSpaceId();
            Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                LOG.warn("Can't find space with id {} when checking access on news with id {}", new Object[]{spaceId, news.getId()});
                return false;
            }
            if (!(news.isPublished() || !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"published") || this.spaceService.isSuperManager(username) || this.spaceService.isMember(space, username) || this.isMemberOfsharedInSpaces(news, username))) {
                return false;
            }
            if (StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !StringUtils.equals((CharSequence)news.getAuthor(), (CharSequence)username) && !this.spaceService.isManager(space, username) && !this.spaceService.isRedactor(space, username)) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving access permission for user {} on news with id {}", new Object[]{username, news.getId()});
            return false;
        }
        return true;
    }

    @Override
    public void unarchiveNews(String newsId, String currentUserName) throws Exception {
        this.newsStorage.unarchiveNews(newsId);
        News news = this.getNewsById(newsId, false);
        boolean displayed = !StringUtils.equals((CharSequence)news.getPublicationState(), (CharSequence)"staged") && !news.isArchived();
        List<String> newsTargets = this.newsTargetingService.getTargetsByNewsId(newsId);
        if (newsTargets != null && !newsTargets.isEmpty()) {
            this.newsTargetingService.deleteNewsTargets(news.getId(), currentUserName);
            this.newsTargetingService.saveNewsTarget(news.getId(), displayed, newsTargets, currentUserName);
        }
        NewsUtils.broadcastEvent("exo.news.unarchiveArticle", currentUserName, news);
    }

    @Override
    public boolean canScheduleNews(Space space, Identity currentIdentity) {
        return this.spaceService.isManager(space, currentIdentity.getUserId()) || this.spaceService.isRedactor(space, currentIdentity.getUserId()) || currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    @Override
    public boolean canArchiveNews(Identity currentIdentity, String newsAuthor) {
        return currentIdentity != null && (currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.getUserId().equals(newsAuthor));
    }

    public void sendNotification(String currentUserId, News news, NotificationConstants.NOTIFICATION_CONTEXT context) throws Exception {
        String newsId = news.getId();
        String contentAuthor = news.getAuthor();
        String currentUser = currentUserId != null ? currentUserId : contentAuthor;
        String activities = news.getActivities();
        String contentTitle = news.getTitle();
        String contentBody = news.getBody();
        String lastSpaceIdActivityId = activities.split(";")[activities.split(";").length - 1];
        String contentSpaceId = lastSpaceIdActivityId.split(":")[0];
        String contentActivityId = lastSpaceIdActivityId.split(":")[1];
        Space contentSpace = this.spaceService.getSpaceById(contentSpaceId);
        boolean isMember = this.spaceService.isMember(contentSpace, contentAuthor);
        if (contentSpace == null) {
            throw new NullPointerException("Cannot find a space with id " + contentSpaceId + ", it may not exist");
        }
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", contentAuthor);
        String authorAvatarUrl = LinkProviderUtils.getUserAvatarUrl((Profile)identity.getProfile());
        String illustrationURL = this.newsStorage.getNewsIllustration(news);
        String activityLink = NotificationUtils.getNotificationActivityLink(contentSpace, contentActivityId, isMember);
        String contentSpaceName = contentSpace.getDisplayName();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTEXT, (Object)context).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)illustrationURL).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(PostNewsNotificationPlugin.NEWS_ID, (Object)newsId);
        if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.POST_NEWS)) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PostNewsNotificationPlugin"))).execute(ctx);
            Matcher matcher = MentionInNewsNotificationPlugin.MENTION_PATTERN.matcher(contentBody);
            if (matcher.find()) {
                this.sendMentionInNewsNotification(contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, illustrationURL, authorAvatarUrl, activityLink, contentSpaceName);
            }
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS)) {
            this.sendMentionInNewsNotification(contentAuthor, currentUser, contentTitle, contentBody, contentSpaceId, illustrationURL, authorAvatarUrl, activityLink, contentSpaceName);
        } else if (context.equals((Object)NotificationConstants.NOTIFICATION_CONTEXT.PUBLISH_IN_NEWS)) {
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PublishNewsNotificationPlugin"))).execute(ctx);
        }
    }

    private void sendMentionInNewsNotification(String contentAuthor, String currentUser, String contentTitle, String contentBody, String contentSpaceId, String illustrationURL, String authorAvatarUrl, String activityLink, String contentSpaceName) {
        Set<String> mentionedIds = NewsUtils.processMentions(contentBody);
        NotificationContext mentionNotificationCtx = NotificationContextImpl.cloneInstance().append(MentionInNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS).append(PostNewsNotificationPlugin.CURRENT_USER, (Object)currentUser).append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)contentAuthor).append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)contentSpaceId).append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)contentTitle).append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)contentSpaceName).append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)illustrationURL).append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)authorAvatarUrl).append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)activityLink).append(MentionInNewsNotificationPlugin.MENTIONED_IDS, mentionedIds);
        mentionNotificationCtx.getNotificationExecutor().with(mentionNotificationCtx.makeCommand(PluginKey.key((String)"MentionInNewsNotificationPlugin"))).execute(mentionNotificationCtx);
    }

    private void updateNewsActivity(News news, boolean post) {
        ExoSocialActivity activity = this.activityManager.getActivity(news.getActivityId());
        if (activity != null) {
            if (post) {
                activity.setUpdated(Long.valueOf(System.currentTimeMillis()));
            }
            activity.isHidden(news.isActivityPosted());
            Map<String, String> templateParams = activity.getTemplateParams() == null ? new HashMap() : activity.getTemplateParams();
            templateParams.put(NEWS_ID, news.getId());
            activity.setTemplateParams(templateParams);
            activity.setMetadataObjectId(news.getId());
            activity.setMetadataObjectType("news");
            this.activityManager.updateActivity(activity, true);
        }
    }

    private boolean canEditNews(News news, String authenticatedUser) {
        Space space;
        String spaceId = news.getSpaceId();
        Space space2 = space = spaceId == null ? null : this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        Identity authenticatedUserIdentity = NewsUtils.getUserIdentity(authenticatedUser);
        if (authenticatedUserIdentity == null) {
            LOG.warn("Can't find user with id {} when checking access on news with id {}", new Object[]{authenticatedUser, news.getId()});
            return false;
        }
        String posterUsername = news.getAuthor();
        if (authenticatedUser.equals(posterUsername)) {
            return true;
        }
        Space currentSpace = this.spaceService.getSpaceById(spaceId);
        if ((this.spaceService.isManager(currentSpace, authenticatedUser) || this.spaceService.isSuperManager(authenticatedUser) || authenticatedUserIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME)) && news.getActivities() != null) {
            return true;
        }
        return (this.spaceService.isRedactor(currentSpace, authenticatedUser) || this.spaceService.isManager(currentSpace, authenticatedUser)) && news.isDraftVisible() && news.getActivities() == null;
    }

    private boolean canDeleteNews(Identity currentIdentity, String posterId, String spaceId) {
        if (currentIdentity == null) {
            return false;
        }
        String authenticatedUser = currentIdentity.getUserId();
        Space currentSpace = this.spaceService.getSpaceById(spaceId);
        return authenticatedUser.equals(posterId) || this.userACL.isSuperUser() || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(currentSpace, authenticatedUser);
    }

    private boolean isMemberOfsharedInSpaces(News news, String username) {
        for (String sharedInSpaceId : news.getSharedInSpacesList()) {
            Space sharedInSpace = this.spaceService.getSpaceById(sharedInSpaceId);
            if (sharedInSpace == null || !this.spaceService.isMember(sharedInSpace, username)) continue;
            return true;
        }
        return false;
    }
}

