/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.storage.jcr;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.news.connector.NewsSearchConnector;
import org.exoplatform.news.connector.NewsSearchResult;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.queryBuilder.NewsQueryBuilder;
import org.exoplatform.news.storage.NewsAttachmentsStorage;
import org.exoplatform.news.storage.NewsStorage;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class JcrNewsStorage
implements NewsStorage {
    public static final String APPLICATION_DATA_PATH = "/Application Data";
    private static final String HTML_AT_SYMBOL_PATTERN = "@";
    private static final String HTML_AT_SYMBOL_ESCAPED_PATTERN = "&#64;";
    private static final String LAST_PUBLISHER = "publication:lastUser";
    private static final Log LOG = ExoLogger.getLogger(JcrNewsStorage.class);
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([^\\s<]+)|@([^\\s<]+)$");
    public static final String MIX_NEWS_MODIFIERS = "mix:newsModifiers";
    public static final String MIX_NEWS_MODIFIERS_PROP = "exo:newsModifiersIds";
    public static final String NEWS_ACTIVITY_POSTING_MIXIN_TYPE = "mix:newsActivityPosting";
    public static final String NEWS_ACTIVITY_POSTED_MIXIN_PROP = "exo:newsActivityPosted";
    public static final String NEWS_DRAFT_VISIBILE_MIXIN_PROP = "exo:draftVisible";
    public static final String NEWS_DRAFT_VISIBILITY_MIXIN_TYPE = "mix:draftVisibility";
    public static final String NEWS_NODES_FOLDER = "News";
    public static final String PUBLISHED_NEWS_NODES_FOLDER = "Pinned";
    public static final String EXO_NEWS_LAST_MODIFIER = "exo:newsLastModifier";
    public static final String NEWS_MODIFICATION_MIXIN = "mix:newsModification";
    public static final String[] SHARE_NEWS_PERMISSIONS = new String[]{"read"};
    private ActivityManager activityManager;
    private DataDistributionType dataDistributionType;
    private IdentityManager identityManager;
    private LinkManager linkManager;
    private NewsAttachmentsStorage newsAttachmentsService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private PublicationManager publicationManager;
    private PublicationService publicationService;
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private SpaceService spaceService;
    private UploadService uploadService;
    private WCMPublicationService wCMPublicationService;
    private NewsSearchConnector newsSearchConnector;

    public JcrNewsStorage(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, DataDistributionManager dataDistributionManager, ActivityManager activityManager, SpaceService spaceService, UploadService uploadService, PublicationService publicationService, PublicationManager publicationManager, NewsAttachmentsStorage newsAttachmentsService, IdentityManager identityManager, LinkManager linkManager, NewsSearchConnector newsSearchConnector, WCMPublicationService wCMPublicationService) {
        this.activityManager = activityManager;
        this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.identityManager = identityManager;
        this.linkManager = linkManager;
        this.newsAttachmentsService = newsAttachmentsService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.publicationManager = publicationManager;
        this.publicationService = publicationService;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.spaceService = spaceService;
        this.uploadService = uploadService;
        this.wCMPublicationService = wCMPublicationService;
        this.newsSearchConnector = newsSearchConnector;
    }

    @Override
    public News createNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node spaceNewsRootNode = this.getSpaceNewsRootNode(news.getSpaceId(), session);
        Calendar creationCalendar = Calendar.getInstance();
        if (news.getCreationDate() != null) {
            creationCalendar.setTime(news.getCreationDate());
        } else {
            news.setCreationDate(creationCalendar.getTime());
        }
        String newsNodeName = !news.getTitle().equals("") ? news.getTitle() : "Untitled";
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(spaceNewsRootNode, this.getNodeRelativePath(creationCalendar));
        Node newsDraftNode = newsFolderNode.addNode(Utils.cleanName((String)newsNodeName).trim(), "exo:news");
        newsDraftNode.addMixin("exo:datetime");
        newsDraftNode.setProperty("exo:title", news.getTitle());
        newsDraftNode.setProperty("exo:summary", news.getSummary());
        newsDraftNode.setProperty("exo:body", news.getBody());
        newsDraftNode.setProperty("exo:author", news.getAuthor());
        newsDraftNode.setProperty("exo:dateCreated", creationCalendar);
        newsDraftNode.setProperty("exo:viewsCount", 0L);
        newsDraftNode.setProperty("exo:viewers", "");
        newsDraftNode.setProperty("exo:activities", "");
        Calendar updateCalendar = Calendar.getInstance();
        if (news.getUpdateDate() != null) {
            updateCalendar.setTime(news.getUpdateDate());
        } else {
            news.setUpdateDate(updateCalendar.getTime());
        }
        newsDraftNode.setProperty("exo:dateModified", updateCalendar);
        newsDraftNode.setProperty("exo:pinned", false);
        newsDraftNode.setProperty("exo:archived", false);
        newsDraftNode.setProperty("exo:spaceId", news.getSpaceId());
        if (newsDraftNode.canAddMixin(NEWS_DRAFT_VISIBILITY_MIXIN_TYPE) && !newsDraftNode.hasProperty(NEWS_DRAFT_VISIBILE_MIXIN_PROP)) {
            newsDraftNode.addMixin(NEWS_DRAFT_VISIBILITY_MIXIN_TYPE);
        }
        newsDraftNode.setProperty(NEWS_DRAFT_VISIBILE_MIXIN_PROP, String.valueOf(news.isDraftVisible()));
        if (newsDraftNode.canAddMixin(NEWS_ACTIVITY_POSTING_MIXIN_TYPE) && !newsDraftNode.hasProperty(NEWS_ACTIVITY_POSTED_MIXIN_PROP)) {
            newsDraftNode.addMixin(NEWS_ACTIVITY_POSTING_MIXIN_TYPE);
        }
        newsDraftNode.setProperty(NEWS_ACTIVITY_POSTED_MIXIN_PROP, String.valueOf(news.isActivityPosted()));
        LifecyclesConfig.Lifecycle lifecycle = this.publicationManager.getLifecycle("newsLifecycle");
        String lifecycleName = ((WebpagePublicationPlugin)this.wCMPublicationService.getWebpagePublicationPlugins().get(lifecycle.getPublicationPlugin())).getLifecycleName();
        if (newsDraftNode.canAddMixin("publication:authoring")) {
            newsDraftNode.addMixin("publication:authoring");
            newsDraftNode.setProperty(LAST_PUBLISHER, news.getAuthor());
            newsDraftNode.setProperty("publication:lifecycle", lifecycle.getName());
        }
        if (newsDraftNode.canAddMixin(NEWS_MODIFICATION_MIXIN)) {
            newsDraftNode.addMixin(NEWS_MODIFICATION_MIXIN);
        }
        this.publicationService.enrollNodeInLifecycle(newsDraftNode, lifecycleName);
        this.publicationService.changeState(newsDraftNode, "draft", new HashMap());
        newsDraftNode.setProperty("exo:body", news.getBody());
        spaceNewsRootNode.save();
        if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
            this.attachIllustration(newsDraftNode, news.getUploadId());
        }
        news.setId(newsDraftNode.getUUID());
        return news;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<News> getNews(NewsFilter newsFilter) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        ArrayList<News> listNews = new ArrayList<News>();
        NewsQueryBuilder queyBuilder = new NewsQueryBuilder();
        try {
            StringBuilder sqlQuery = queyBuilder.buildQuery(newsFilter);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            ((QueryImpl)query).setOffset((long)newsFilter.getOffset());
            ((QueryImpl)query).setLimit((long)newsFilter.getLimit());
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node iterNode = it.nextNode();
                News news = this.getNewsById(iterNode.getUUID(), newsFilter.isDraftNews());
                listNews.add(news);
            }
            ArrayList<News> arrayList = listNews;
            return arrayList;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNewsCount(NewsFilter newsFilter) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        try {
            StringBuilder sqlQuery = queryBuilder.buildQuery(newsFilter);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            int count = 0;
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                it.nextNode();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void publishNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(news.getId());
        Node publishedRootNode = this.getPublishedNewsFolder(session);
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(publishedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsNode.canAddMixin("exo:privilegeable")) {
            newsNode.addMixin("exo:privilegeable");
        }
        ((ExtendedNode)newsNode).setPermission("*:/platform/users", SHARE_NEWS_PERMISSIONS);
        this.newsAttachmentsService.makeAttachmentsPublic(newsNode);
        this.linkManager.createLink(newsFolderNode, "exo:symlink", newsNode, null);
        newsNode.setProperty("exo:pinned", true);
        newsNode.save();
    }

    @Override
    public News getNewsById(String newsId, boolean editMode) throws Exception {
        org.exoplatform.social.core.identity.model.Identity draftUpdaterIdentity;
        org.exoplatform.social.core.identity.model.Identity updaterIdentity;
        org.exoplatform.social.core.identity.model.Identity identity;
        Node originalNode;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node node = session.getNodeByUUID(newsId);
        if (node == null) {
            return null;
        }
        if (!editMode && node.getProperty("publication:currentState").getString().equals("draft") && node.hasProperty("publication:liveRevision")) {
            String versionNodeUUID = node.getProperty("publication:liveRevision").getString();
            Node versionNode = node.getVersionHistory().getSession().getNodeByUUID(versionNodeUUID);
            node = versionNode.getNode("jcr:frozenNode");
        }
        News news = new News();
        if (node.hasProperty("jcr:frozenUuid")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            originalNode = node.getSession().getNodeByUUID(uuid);
            news.setId(originalNode.getUUID());
        } else {
            originalNode = node;
            news.setId(node.getUUID());
        }
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        news.setTitle(this.getStringProperty(node, "exo:title"));
        news.setSummary(this.getStringProperty(node, "exo:summary"));
        String body = this.getStringProperty(node, "exo:body");
        String sanitizedBody = HTMLSanitizer.sanitize((String)body);
        sanitizedBody = sanitizedBody.replaceAll(HTML_AT_SYMBOL_ESCAPED_PATTERN, HTML_AT_SYMBOL_PATTERN);
        news.setBody(this.substituteUsernames(portalOwner, sanitizedBody));
        news.setOriginalBody(sanitizedBody);
        news.setAuthor(this.getStringProperty(node, "exo:author"));
        news.setCreationDate(this.getDateProperty(node, "exo:dateCreated"));
        news.setPublicationDate(this.getPublicationDate(originalNode));
        news.setUpdater(this.getLastUpdater(originalNode));
        news.setUpdateDate(this.getLastUpdatedDate(originalNode));
        news.setDraftUpdater(this.getStringProperty(originalNode, EXO_NEWS_LAST_MODIFIER));
        news.setDraftUpdateDate(this.getDateProperty(node, "exo:dateModified"));
        news.setPath(this.getPath(node));
        if (node.hasProperty("publication:currentState")) {
            news.setPublicationState(node.getProperty("publication:currentState").getString());
        }
        if (originalNode.hasProperty("exo:pinned")) {
            news.setPublished(originalNode.getProperty("exo:pinned").getBoolean());
        }
        if (originalNode.hasProperty("exo:archived")) {
            news.setArchived(originalNode.getProperty("exo:archived").getBoolean());
        }
        if (originalNode.hasProperty("exo:spaceId")) {
            news.setSpaceId(node.getProperty("exo:spaceId").getString());
        }
        if (originalNode.hasProperty(NEWS_DRAFT_VISIBILE_MIXIN_PROP)) {
            news.setDraftVisible(Boolean.valueOf(node.getProperty(NEWS_DRAFT_VISIBILE_MIXIN_PROP).getString()));
        } else {
            news.setDraftVisible(false);
        }
        if (originalNode.hasProperty(NEWS_ACTIVITY_POSTED_MIXIN_PROP)) {
            news.setActivityPosted(Boolean.valueOf(node.getProperty(NEWS_ACTIVITY_POSTED_MIXIN_PROP).getString()));
        } else {
            news.setActivityPosted(false);
        }
        StringBuilder newsUrl = new StringBuilder("");
        if (originalNode.hasProperty("exo:activities")) {
            String strActivities = originalNode.getProperty("exo:activities").getString();
            if (StringUtils.isNotEmpty((CharSequence)strActivities)) {
                String[] activities = strActivities.split(";");
                StringBuilder memberSpaceActivities = new StringBuilder();
                Identity currentIdentity = this.getCurrentIdentity();
                String currentUsername = currentIdentity == null ? null : currentIdentity.getUserId();
                String newsActivityId = activities[0].split(":")[1];
                news.setActivityId(newsActivityId);
                Space newsPostedInSpace = this.spaceService.getSpaceById(activities[0].split(":")[0]);
                if (currentUsername != null && this.spaceService.isMember(newsPostedInSpace, currentUsername)) {
                    newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/activity?id=").append(newsActivityId);
                    news.setUrl(newsUrl.toString());
                } else {
                    newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/news/detail?newsId=").append(news.getId());
                    news.setUrl(newsUrl.toString());
                }
                memberSpaceActivities.append(activities[0]).append(";");
                ArrayList<String> sharedInSpacesList = new ArrayList<String>();
                for (int i = 1; i < activities.length; ++i) {
                    String sharedInSpaceId = activities[i].split(":")[0];
                    sharedInSpacesList.add(sharedInSpaceId);
                    Space sharedInSpace = this.spaceService.getSpaceById(sharedInSpaceId);
                    String activityId = activities[i].split(":")[1];
                    if (sharedInSpace == null || currentUsername == null || !this.spaceService.isMember(sharedInSpace, currentUsername) || !this.activityManager.isActivityExists(activityId)) continue;
                    memberSpaceActivities.append(activities[i]).append(";");
                }
                news.setActivities(memberSpaceActivities.toString());
                news.setSharedInSpacesList(sharedInSpacesList);
            } else {
                newsUrl.append("/").append(portalName).append("/").append(portalOwner).append("/news/detail?newsId=").append(news.getId());
                news.setUrl(newsUrl.toString());
            }
        }
        if (node.hasProperty("publication:startPublishedDate")) {
            news.setSchedulePostDate(node.getProperty("publication:startPublishedDate").getString());
        }
        if (!originalNode.hasProperty("exo:viewsCount")) {
            news.setViewsCount(0L);
        } else {
            news.setViewsCount(originalNode.getProperty("exo:viewsCount").getLong());
        }
        if (node.hasNode("illustration")) {
            Node illustrationContentNode = node.getNode("illustration").getNode("jcr:content");
            byte[] bytes = IOUtils.toByteArray((InputStream)illustrationContentNode.getProperty("jcr:data").getStream());
            news.setIllustration(bytes);
            news.setIllustrationUpdateDate(illustrationContentNode.getProperty("exo:dateModified").getDate().getTime());
            long lastModified = news.getIllustrationUpdateDate().getTime();
            news.setIllustrationURL("/portal/rest/v1/news/" + news.getId() + "/illustration?v=" + lastModified);
        }
        news.setAttachments(this.newsAttachmentsService.getNewsAttachments(node));
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        if (space != null) {
            String spaceName = space.getDisplayName();
            String currentUser = this.getCurrentUserId();
            boolean hiddenSpace = space.getVisibility().equals("hidden") && !this.spaceService.isMember(space, currentUser) && !this.spaceService.isSuperManager(currentUser);
            news.setHiddenSpace(hiddenSpace);
            boolean isSpaceMember = this.spaceService.isSuperManager(this.getCurrentUserId()) || this.spaceService.isMember(space, this.getCurrentUserId());
            news.setSpaceMember(isSpaceMember);
            news.setSpaceDisplayName(spaceName);
            if (StringUtils.isNotEmpty((CharSequence)space.getGroupId())) {
                String spaceGroupId = space.getGroupId().split("/")[2];
                news.setSpaceAvatarUrl(space.getAvatarUrl());
                String spaceUrl = "/portal/g/:spaces:" + spaceGroupId + "/" + space.getPrettyName();
                news.setSpaceUrl(spaceUrl);
            }
        }
        if ((identity = this.identityManager.getOrCreateIdentity("organization", news.getAuthor())) != null && identity.getProfile() != null) {
            news.setAuthorDisplayName(identity.getProfile().getFullName());
            news.setAuthorAvatarUrl(identity.getProfile().getAvatarUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)news.getUpdater()) && (updaterIdentity = this.identityManager.getOrCreateIdentity("organization", news.getUpdater())) != null && updaterIdentity.getProfile() != null) {
            news.setUpdaterFullName(updaterIdentity.getProfile().getFullName());
        }
        if ((draftUpdaterIdentity = this.identityManager.getOrCreateIdentity("organization", news.getDraftUpdater())) != null && draftUpdaterIdentity.getProfile() != null) {
            news.setDraftUpdaterUserName(draftUpdaterIdentity.getRemoteId());
            news.setDraftUpdaterDisplayName(draftUpdaterIdentity.getProfile().getFullName());
        }
        return news;
    }

    @Override
    public String getNewsIllustration(News news) throws Exception {
        Node newsNode;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        StringBuffer illustrationURL = new StringBuffer();
        Object currentDomain = CommonsUtils.getCurrentDomain();
        if (!((String)currentDomain).endsWith("/")) {
            currentDomain = (String)currentDomain + "/";
        }
        if ((newsNode = session.getNodeByUUID(news.getId())) == null) {
            throw new ItemNotFoundException("Cannot find a node with UUID equals to " + news.getId() + ", it may not exist");
        }
        if (newsNode.hasNode("illustration")) {
            illustrationURL.append((String)currentDomain).append("portal/rest/v1/news/").append(news.getId()).append("/illustration");
        } else {
            illustrationURL.append((String)currentDomain).append("news/images/news.png");
        }
        return illustrationURL.toString();
    }

    private void updateModifiers(Node newsNode, String currentIdentityId) throws RepositoryException, IOException {
        boolean exist = false;
        Object[] newsModifiers = new Value[]{};
        if (newsNode.hasProperty(MIX_NEWS_MODIFIERS_PROP)) {
            newsModifiers = newsNode.getProperty(MIX_NEWS_MODIFIERS_PROP).getValues();
            exist = Arrays.stream(newsModifiers).map(value -> {
                try {
                    return value.getString();
                }
                catch (RepositoryException e) {
                    return null;
                }
            }).filter(Objects::nonNull).anyMatch(newsModifier -> newsModifier.equals(currentIdentityId));
        }
        if (!exist) {
            newsNode.setProperty(MIX_NEWS_MODIFIERS_PROP, (Value[])ArrayUtils.add((Object[])newsModifiers, (Object)new StringValue(currentIdentityId)));
            newsNode.save();
        }
    }

    private void updateNewsPublicationState(Node newsNode, News news) throws Exception {
        if ("published".equals(news.getPublicationState())) {
            this.publicationService.changeState(newsNode, "published", new HashMap());
            if (newsNode.isNodeType(MIX_NEWS_MODIFIERS)) {
                newsNode.removeMixin(MIX_NEWS_MODIFIERS);
                newsNode.save();
            }
        } else if ("draft".equals(news.getPublicationState())) {
            this.publicationService.changeState(newsNode, "draft", new HashMap());
            org.exoplatform.social.core.identity.model.Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", this.getCurrentUserId());
            String currentIdentityId = currentIdentity.getId();
            if (!newsNode.isNodeType(MIX_NEWS_MODIFIERS)) {
                newsNode.addMixin(MIX_NEWS_MODIFIERS);
            }
            this.updateModifiers(newsNode, currentIdentityId);
        }
    }

    private void updateNewsName(Session session, Node newsNode, News news) throws RepositoryException {
        if (StringUtils.isNotBlank((CharSequence)news.getTitle()) && !news.getTitle().equals(newsNode.getName())) {
            String srcPath = newsNode.getPath();
            String destPath = (newsNode.getParent().getPath().equals("/") ? "" : newsNode.getParent().getPath()) + "/" + Utils.cleanName((String)news.getTitle()).trim();
            session.getWorkspace().move(srcPath, destPath);
        }
    }

    @Override
    public News updateNews(News news, String updater) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(news.getId());
        if (newsNode != null) {
            newsNode.setProperty("exo:title", news.getTitle());
            newsNode.setProperty("exo:name", news.getTitle());
            newsNode.setProperty("exo:summary", news.getSummary());
            newsNode.setProperty("exo:body", news.getBody());
            newsNode.setProperty("exo:dateModified", Calendar.getInstance());
            newsNode.setProperty(EXO_NEWS_LAST_MODIFIER, updater);
            if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
                this.attachIllustration(newsNode, news.getUploadId());
            } else if ("".equals(news.getUploadId())) {
                this.removeIllustration(newsNode);
            }
            if (newsNode.hasProperty(NEWS_DRAFT_VISIBILE_MIXIN_PROP)) {
                newsNode.setProperty(NEWS_DRAFT_VISIBILE_MIXIN_PROP, String.valueOf(news.isDraftVisible()));
            }
            if (newsNode.hasProperty(NEWS_ACTIVITY_POSTED_MIXIN_PROP)) {
                newsNode.setProperty(NEWS_ACTIVITY_POSTED_MIXIN_PROP, String.valueOf(news.isActivityPosted()));
            }
            news.setAttachments(this.newsAttachmentsService.updateNewsAttachments(news, newsNode));
            newsNode.save();
            this.updateNewsName(session, newsNode, news);
            this.updateNewsPublicationState(newsNode, news);
        }
        return news;
    }

    @Override
    public void deleteNews(String newsId, boolean isDraft) throws Exception {
        String newActivities;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node node = session.getNodeByUUID(newsId);
        if (node.hasProperty("exo:activities") && StringUtils.isNotEmpty((CharSequence)(newActivities = node.getProperty("exo:activities").getString()))) {
            if (isDraft && node.hasProperty("publication:currentState") && node.getProperty("publication:currentState").getString().equals("draft")) {
                String versionNodeUUID = node.hasProperty("publication:liveRevision") ? node.getProperty("publication:liveRevision").getString() : null;
                String versionName = node.getVersionHistory().getSession().getNodeByUUID(versionNodeUUID).getName();
                if (!versionName.isEmpty()) {
                    node.restore(versionName, true);
                    if (!node.isCheckedOut()) {
                        node.checkout();
                    }
                    this.publicationService.changeState(node, "published", new HashMap());
                    return;
                }
            }
            Stream.of(newActivities.split(";")).map(activity -> activity.split(":")[1]).forEach(newsActivityId -> this.activityManager.deleteActivity(newsActivityId));
        }
        Utils.removeDeadSymlinks((Node)node, (boolean)false);
        node.remove();
        session.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News scheduleNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News scheduledNews = null;
        try {
            Node scheduledNewsNode = session.getNodeByUUID(news.getId());
            if (scheduledNewsNode == null) {
                throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + news.getId());
            }
            String schedulePostDate = news.getSchedulePostDate();
            if (schedulePostDate != null) {
                ZoneOffset userTimeZone = StringUtils.isBlank((CharSequence)news.getTimeZoneId()) ? ZoneOffset.UTC : ZoneId.of(news.getTimeZoneId());
                String offsetTimeZone = String.valueOf(OffsetTime.now(userTimeZone).getOffset()).replace(":", "");
                schedulePostDate = schedulePostDate.concat(" ").concat(offsetTimeZone);
                SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ssZ");
                Calendar startPublishedDate = Calendar.getInstance();
                startPublishedDate.setTime(format.parse(schedulePostDate));
                scheduledNewsNode.setProperty("publication:startPublishedDate", startPublishedDate);
                scheduledNewsNode.setProperty(LAST_PUBLISHER, this.getCurrentUserId());
                scheduledNewsNode.setProperty("exo:pinned", news.isPublished());
                scheduledNewsNode.setProperty(NEWS_ACTIVITY_POSTED_MIXIN_PROP, news.isActivityPosted());
                scheduledNewsNode.save();
                this.publicationService.changeState(scheduledNewsNode, "staged", new HashMap());
            }
            scheduledNews = this.getNewsById(news.getId(), false);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return scheduledNews;
    }

    @Override
    public void updateNewsActivities(String newsActivityId, News news) throws Exception {
        Node newsNode;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        if (newsActivityId != null && !StringUtils.isEmpty((CharSequence)news.getId()) && (newsNode = session.getNodeByUUID(news.getId())).hasProperty("exo:activities")) {
            String updatedNewsActivities = news.getSpaceId().concat(":").concat(newsActivityId);
            newsNode.setProperty("exo:activities", updatedNewsActivities);
            newsNode.save();
            news.setActivities(updatedNewsActivities);
        }
    }

    private void attachIllustration(Node newsNode, String uploadId) throws Exception {
        UploadResource uploadedResource = this.uploadService.getUploadResource(uploadId);
        if (uploadedResource == null) {
            throw new Exception("Cannot attach uploaded file " + uploadId + ", it may not exist");
        }
        boolean illustrationExists = newsNode.hasNode("illustration");
        Node illustrationNode = illustrationExists ? newsNode.getNode("illustration") : newsNode.addNode("illustration", "nt:file");
        illustrationNode.setProperty("exo:title", uploadedResource.getFileName());
        Node resourceNode = illustrationExists ? illustrationNode.getNode("jcr:content") : illustrationNode.addNode("jcr:content", "nt:resource");
        resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
        Calendar now = Calendar.getInstance();
        resourceNode.setProperty("jcr:lastModified", now);
        resourceNode.setProperty("exo:dateModified", now);
        String fileDiskLocation = uploadedResource.getStoreLocation();
        try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
            resourceNode.setProperty("jcr:data", (InputStream)inputStream);
            newsNode.save();
        }
    }

    private Node getPublishedNewsFolder(Session session) throws Exception {
        Node publishedRootNode;
        Node newsRootNode;
        Node applicationDataNode = (Node)session.getItem(APPLICATION_DATA_PATH);
        if (!applicationDataNode.hasNode(NEWS_NODES_FOLDER)) {
            newsRootNode = applicationDataNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            applicationDataNode.save();
        } else {
            newsRootNode = applicationDataNode.getNode(NEWS_NODES_FOLDER);
        }
        if (!newsRootNode.hasNode(PUBLISHED_NEWS_NODES_FOLDER)) {
            publishedRootNode = newsRootNode.addNode(PUBLISHED_NEWS_NODES_FOLDER, "nt:unstructured");
            newsRootNode.save();
        } else {
            publishedRootNode = newsRootNode.getNode(PUBLISHED_NEWS_NODES_FOLDER);
        }
        return publishedRootNode;
    }

    private Node getSpaceNewsRootNode(String spaceId, Session session) throws RepositoryException {
        Node spaceNewsRootNode;
        Space space = this.spaceService.getSpaceById(spaceId);
        String groupPath = this.nodeHierarchyCreator.getJcrPath("groupsPath");
        String spaceParentPath = groupPath + space.getGroupId();
        Node spaceRootNode = (Node)session.getItem(spaceParentPath);
        if (!spaceRootNode.hasNode(NEWS_NODES_FOLDER)) {
            spaceNewsRootNode = spaceRootNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            if (spaceNewsRootNode.canAddMixin("exo:privilegeable")) {
                spaceNewsRootNode.addMixin("exo:privilegeable");
            }
            HashMap<CallSite, String[]> permissions = new HashMap<CallSite, String[]>();
            permissions.put((CallSite)((Object)("*:" + space.getGroupId())), PermissionType.ALL);
            ((ExtendedNode)spaceNewsRootNode).setPermissions(permissions);
            spaceRootNode.save();
        } else {
            spaceNewsRootNode = spaceRootNode.getNode(NEWS_NODES_FOLDER);
        }
        return spaceNewsRootNode;
    }

    private String getNodeRelativePath(Calendar now) {
        return now.get(1) + "/" + (now.get(2) + 1) + "/" + now.get(5);
    }

    private String getStringProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return "";
    }

    private Date getDateProperty(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate().getTime();
        }
        return null;
    }

    public String substituteUsernames(String portalOwner, String message) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        Matcher matcher = MENTION_PATTERN.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            org.exoplatform.social.core.identity.model.Identity identity;
            String username = matcher.group().substring(1);
            if (username == null || username.isEmpty() || (identity = this.identityManager.getOrCreateIdentity("organization", username)) == null || identity.isDeleted() || !identity.isEnable()) continue;
            try {
                username = LinkProvider.getProfileLink((String)username, (String)portalOwner);
            }
            catch (Exception e) {
                LOG.warn("Error while retrieving link for profile of user {}", new Object[]{username, e});
                continue;
            }
            if (username == null) continue;
            matcher.appendReplacement(buf, username);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            return buf.toString();
        }
        return message;
    }

    private Date getPublicationDate(Node node) throws RepositoryException {
        VersionNode versionNode = new VersionNode(node, node.getSession());
        List versions = versionNode.getChildren();
        if (!versions.isEmpty()) {
            versions.sort(Comparator.comparingInt(v -> Integer.parseInt(v.getName())));
            return ((VersionNode)versions.get(0)).getCreatedTime().getTime();
        }
        return null;
    }

    private String getLastUpdater(Node node) throws RepositoryException {
        VersionNode lastUpdatedVersion = this.getLastUpdatedVersion(node);
        if (lastUpdatedVersion != null) {
            return lastUpdatedVersion.getAuthor();
        }
        return this.getStringProperty(node, EXO_NEWS_LAST_MODIFIER);
    }

    private Date getLastUpdatedDate(Node node) throws RepositoryException {
        VersionNode lastUpdatedVersion = this.getLastUpdatedVersion(node);
        if (lastUpdatedVersion != null) {
            return lastUpdatedVersion.getCreatedTime().getTime();
        }
        return this.getDateProperty(node, "exo:dateModified");
    }

    private VersionNode getLastUpdatedVersion(Node node) throws RepositoryException {
        VersionNode versionNode = new VersionNode(node, node.getSession());
        List versions = versionNode.getChildren();
        if (!versions.isEmpty()) {
            versions.sort(Comparator.comparingInt(v -> Integer.parseInt(v.getName())));
            return (VersionNode)versions.get(versions.size() - 1);
        }
        return null;
    }

    private String getCurrentUserId() {
        Identity currentIdentity = this.getCurrentIdentity();
        return currentIdentity != null ? currentIdentity.getUserId() : null;
    }

    private Identity getCurrentIdentity() {
        ConversationState conversationState = ConversationState.getCurrent();
        return conversationState != null ? conversationState.getIdentity() : null;
    }

    private String getPath(Node node) throws Exception {
        String nodePath = null;
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        if (nodeLocation != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("/").append(nodeLocation.getRepository()).append("/").append(nodeLocation.getWorkspace()).append(node.getPath());
            nodePath = Text.escapeIllegalJcrChars((String)sb.toString());
        }
        return nodePath;
    }

    private void removeIllustration(Node newsNode) throws Exception {
        if (newsNode.hasNode("illustration")) {
            newsNode.getNode("illustration").remove();
            newsNode.save();
        }
    }

    private Node getPublishedNewsFolder() throws Exception {
        Node publishedRootNode;
        Node newsRootNode;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node applicationDataNode = (Node)session.getItem(APPLICATION_DATA_PATH);
        if (!applicationDataNode.hasNode(NEWS_NODES_FOLDER)) {
            newsRootNode = applicationDataNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            applicationDataNode.save();
        } else {
            newsRootNode = applicationDataNode.getNode(NEWS_NODES_FOLDER);
        }
        if (!newsRootNode.hasNode(PUBLISHED_NEWS_NODES_FOLDER)) {
            publishedRootNode = newsRootNode.addNode(PUBLISHED_NEWS_NODES_FOLDER, "nt:unstructured");
            newsRootNode.save();
        } else {
            publishedRootNode = newsRootNode.getNode(PUBLISHED_NEWS_NODES_FOLDER);
        }
        return publishedRootNode;
    }

    @Override
    public void markAsRead(News news, String userId) throws Exception {
        String newsViewers;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(news.getId());
        if (newsNode == null) {
            throw new Exception("Unable to find a node with an UUID equal to: " + news.getId());
        }
        if (!newsNode.hasProperty("exo:viewers")) {
            newsNode.setProperty("exo:viewers", "");
        }
        newsViewers = (newsViewers = newsNode.getProperty("exo:viewers").getString()).isEmpty() ? newsViewers.concat(userId) : newsViewers.concat(",").concat(userId);
        newsNode.setProperty("exo:viewers", newsViewers);
        if (!newsNode.hasProperty("exo:viewsCount")) {
            newsNode.setProperty("exo:viewsCount", 0L);
        } else {
            Long newsViewsCount = newsNode.getProperty("exo:viewsCount").getValue().getLong() + 1L;
            newsNode.setProperty("exo:viewsCount", newsViewsCount.longValue());
        }
        newsNode.save();
    }

    @Override
    public boolean isCurrentUserInNewsViewers(String newsId, String userId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new Exception("Unable to find a node with an UUID equal to: " + newsId);
        }
        if (!newsNode.hasProperty("exo:viewers")) {
            newsNode.setProperty("exo:viewers", "");
        }
        String newsViewers = newsNode.getProperty("exo:viewers").getString();
        boolean isCurrentUserInNewsViewers = false;
        if (!newsViewers.isEmpty()) {
            String[] newsViewersArray = newsViewers.split(",");
            isCurrentUserInNewsViewers = Arrays.stream(newsViewersArray).anyMatch(userId::equals);
        }
        return isCurrentUserInNewsViewers;
    }

    @Override
    public void unpublishNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News news = this.getNewsById(newsId, false);
        if (news == null) {
            throw new Exception("Unable to find a news with an id equal to: " + newsId);
        }
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new Exception("Unable to find a node with an UUID equal to: " + newsId);
        }
        newsNode.setProperty("exo:pinned", false);
        if (newsNode.isNodeType("exo:privilegeable")) {
            ((ExtendedNode)newsNode).removePermission("*:/platform/users");
        }
        newsNode.save();
        this.newsAttachmentsService.unmakeAttachmentsPublic(newsNode);
        Node publishedRootNode = this.getPublishedNewsFolder();
        if (publishedRootNode == null) {
            throw new Exception("Unable to find the root published folder: /Application Data/News/pinned");
        }
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(publishedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsFolderNode == null) {
            throw new Exception("Unable to find the parent node of the current published node");
        }
        Node publishedNode = newsFolderNode.getNode(newsNode.getName());
        if (publishedNode == null) {
            throw new Exception("Unable to find the current published node");
        }
        publishedNode.remove();
        newsFolderNode.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News unScheduleNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News draftNews = null;
        try {
            Node unScheduledNewsNode = session.getNodeByUUID(news.getId());
            if (unScheduledNewsNode == null) {
                throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + news.getId());
            }
            String schedulePostDate = news.getSchedulePostDate();
            if (schedulePostDate != null) {
                unScheduledNewsNode.setProperty(LAST_PUBLISHER, this.getCurrentUserId());
                unScheduledNewsNode.save();
                this.publicationService.changeState(unScheduledNewsNode, "draft", new HashMap());
            }
            if (unScheduledNewsNode.hasProperty("publication:startPublishedDate")) {
                unScheduledNewsNode.getProperty("publication:startPublishedDate").remove();
                unScheduledNewsNode.save();
            }
            draftNews = this.getNewsById(news.getId(), false);
            draftNews.setSchedulePostDate(null);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return draftNews;
    }

    @Override
    public void archiveNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + newsId);
        }
        boolean isPublished = newsNode.getProperty("exo:pinned").getBoolean();
        if (isPublished) {
            this.unpublishNews(newsId);
        }
        newsNode.setProperty("exo:archived", true);
        newsNode.save();
    }

    @Override
    public void unarchiveNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new ItemNotFoundException("Unable to find a node with an UUID equal to: " + newsId);
        }
        newsNode.setProperty("exo:archived", false);
        newsNode.save();
    }

    @Override
    public List<News> searchNews(NewsFilter filter, String lang) throws Exception {
        SearchContext context = new SearchContext(null, null);
        context.lang(lang);
        ArrayList<News> newsList = new ArrayList<News>();
        List<SearchResult> searchResults = this.newsSearchConnector.search(filter, filter.getOffset(), filter.getLimit(), "relevancy", "desc");
        searchResults.forEach(res -> {
            try {
                Node newsNode = ((NewsSearchResult)((Object)res)).getNode();
                News news = this.getNewsById(newsNode.getUUID(), false);
                newsList.add(news);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while processing search result in News", (Throwable)e);
            }
        });
        return newsList;
    }

    @Override
    public void shareNews(News news, Space space, org.exoplatform.social.core.identity.model.Identity userIdentity, String sharedActivityId) throws IllegalAccessException, ObjectNotFoundException {
        String newsId = news.getId();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ExtendedNode newsNode = (ExtendedNode)this.getNewsNodeById(newsId, sessionProvider);
            if (newsNode == null) {
                throw new ObjectNotFoundException("News with id " + newsId + "wasn't found");
            }
            if (newsNode.canAddMixin("exo:privilegeable")) {
                newsNode.addMixin("exo:privilegeable");
            }
            if (newsNode.hasProperty("exo:attachmentsIds")) {
                this.newsAttachmentsService.shareAttachments((Node)newsNode, space);
            }
            newsNode.setPermission("*:" + space.getGroupId(), SHARE_NEWS_PERMISSIONS);
            newsNode.save();
            if (sharedActivityId != null) {
                if (newsNode.hasProperty("exo:activities")) {
                    String activities = newsNode.getProperty("exo:activities").getString();
                    activities = activities.concat(";").concat(space.getId()).concat(":").concat(sharedActivityId);
                    newsNode.setProperty("exo:activities", activities);
                } else {
                    newsNode.setProperty("exo:activities", sharedActivityId);
                }
                newsNode.save();
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Error while sharing news with id " + newsId + " to space " + space.getId() + " by user" + userIdentity.getId(), e);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when sharing news with id " + newsId + " attachments in " + space.getId()));
        }
    }

    public Node getNewsNodeById(String newsId, SessionProvider sessionProvider) throws RepositoryException, ItemNotFoundException {
        Session session = this.getSession(sessionProvider);
        Node node = session.getNodeByUUID(newsId);
        return node;
    }

    private Session getSession(SessionProvider sessionProvider) throws RepositoryException {
        return sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
    }
}

