/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.notification.plugin.PostNewsNotificationPlugin;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.news.notification.utils.NotificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class PublishNewsNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(PublishNewsNotificationPlugin.class);
    public static final String ID = "PublishNewsNotificationPlugin";
    private SpaceService spaceService;

    public PublishNewsNotificationPlugin(InitParams initParams, SpaceService spaceService) {
        super(initParams);
        this.spaceService = spaceService;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String currentUserName;
        String contentAuthorUserName;
        String contentTitle = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_TITLE);
        NotificationConstants.NOTIFICATION_CONTEXT context = (NotificationConstants.NOTIFICATION_CONTEXT)((Object)ctx.value(PostNewsNotificationPlugin.CONTEXT));
        String contentAuthor = contentAuthorUserName = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_AUTHOR);
        try {
            contentAuthor = NotificationUtils.getUserFullName(contentAuthorUserName);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurred when trying to retrieve a user with username " + contentAuthorUserName + " " + e.getMessage()), (Throwable)e);
        }
        String currentUserFullName = currentUserName = (String)ctx.value(PostNewsNotificationPlugin.CURRENT_USER);
        try {
            currentUserFullName = NotificationUtils.getUserFullName(currentUserName);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurred when trying to retrieve a user with username " + currentUserName + " " + e.getMessage()), (Throwable)e);
        }
        String contentSpaceName = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_SPACE);
        String illustrationUrl = (String)ctx.value(PostNewsNotificationPlugin.ILLUSTRATION_URL);
        String authorAvatarUrl = (String)ctx.value(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL);
        String activityLink = (String)ctx.value(PostNewsNotificationPlugin.ACTIVITY_LINK);
        String newsId = (String)ctx.value(PostNewsNotificationPlugin.NEWS_ID);
        String contentSpaceId = (String)ctx.value(PostNewsNotificationPlugin.CONTENT_SPACE_ID);
        String audience = (String)ctx.value(PostNewsNotificationPlugin.AUDIENCE);
        NotificationInfo notificationInfo = NotificationInfo.instance().setFrom(currentUserName).with("CONTENT_TITLE", contentTitle).with("CONTENT_AUTHOR", contentAuthor).with("CURRENT_USER", currentUserFullName).with("CONTENT_SPACE", contentSpaceName).with("ILLUSTRATION_URL", illustrationUrl).with("AUTHOR_AVATAR_URL", authorAvatarUrl).with("ACTIVITY_LINK", activityLink).with("CONTEXT", context.getContext()).with("NEWS_ID", newsId).key(this.getKey());
        if (audience.equals("space")) {
            notificationInfo.to(this.getSpaceReceivers(contentSpaceId, currentUserName));
        } else {
            notificationInfo.setSendAllInternals(true);
            ArrayList<String> excludedUsers = new ArrayList<String>();
            excludedUsers.add(currentUserName);
            if (audience.equals("excludeSpaceMembers")) {
                excludedUsers.addAll(this.getSpaceReceivers(contentSpaceId, currentUserName));
            }
            notificationInfo.exclude(excludedUsers);
        }
        return notificationInfo.end();
    }

    private List<String> getSpaceReceivers(String contentSpaceId, String currentUserName) {
        Space space = this.spaceService.getSpaceById(contentSpaceId);
        return space != null ? Arrays.stream(space.getMembers()).filter(member -> !member.equals(currentUserName)).toList() : new ArrayList<String>();
    }
}

